/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyDoubleNegationInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection", "getGroupDisplayName"));
        }
        return "Potentially confusing code constructs";
    }

    @NotNull
    public String getDisplayName() {
        if ("Double negation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection", "getDisplayName"));
        }
        return "Double negation";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("Double negation #ref #loc" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection", "buildErrorString"));
        }
        return "Double negation #ref #loc";
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection", "buildFix"));
        }
        return new DoubleNegationFix();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        DoubleNegationVisitor doubleNegationVisitor = new DoubleNegationVisitor();
        if (doubleNegationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection", "buildVisitor"));
        }
        return doubleNegationVisitor;
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationVisitor", "visitUnaryExpression"));
            }
            super.visitUnaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mLNOT.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mNOT_EQUAL.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        private void checkParent(GrExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof GrParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof GrUnaryExpression)) {
                return;
            }
            GrUnaryExpression prefixExpression = (GrUnaryExpression)parent;
            IElementType parentTokenType = prefixExpression.getOperationTokenType();
            if (!GroovyTokenTypes.mLNOT.equals(parentTokenType)) {
                return;
            }
            this.registerError(prefixExpression);
        }
    }

    private static class DoubleNegationFix
    extends GroovyFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove double negation" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationFix", "getFamilyName"));
            }
            return "Remove double negation";
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationFix", "doFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationFix", "doFix"));
            }
            GrUnaryExpression expression = (GrUnaryExpression)descriptor2.getPsiElement();
            GrExpression operand = (GrExpression)PsiUtil.skipParentheses(expression.getOperand(), false);
            if (operand instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)operand;
                GrExpression innerOperand = prefixExpression.getOperand();
                if (innerOperand == null) {
                    return;
                }
                DoubleNegationFix.replaceExpression(expression, innerOperand.getText());
            } else if (operand instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)operand;
                GrExpression lhs = binaryExpression.getLeftOperand();
                String lhsText = lhs.getText();
                StringBuilder builder = new StringBuilder(lhsText);
                builder.append("==");
                GrExpression rhs = binaryExpression.getRightOperand();
                if (rhs != null) {
                    String rhsText = rhs.getText();
                    builder.append(rhsText);
                }
                DoubleNegationFix.replaceExpression(expression, builder.toString());
            }
        }
    }
}

