/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;

public class GroovyCodeStyleSettings
extends CustomCodeStyleSettings
implements ImportsLayoutSettings {
    public boolean USE_FLYING_GEESE_BRACES = false;
    public boolean SPACE_IN_NAMED_ARGUMENT = true;
    public boolean ALIGN_MULTILINE_LIST_OR_MAP = true;
    public boolean SPACE_WITHIN_LIST_OR_MAP = false;
    public boolean ALIGN_NAMED_ARGS_IN_MAP = true;
    public boolean SPACE_BEFORE_CLOSURE_LBRACE = true;
    public boolean SPACE_WITHIN_GSTRING_INJECTION_BRACES = false;
    public boolean SPACE_WITHIN_TUPLE_EXPRESSION = false;
    public boolean INDENT_LABEL_BLOCKS = true;
    public boolean SPACE_AROUND_REGEX_OPERATORS = true;
    public boolean USE_FQ_CLASS_NAMES = false;
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    public boolean INSERT_INNER_CLASS_IMPORTS = false;
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    public final PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
    public final PackageEntryTable IMPORT_LAYOUT_TABLE = new PackageEntryTable();
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    public int IMPORT_ANNOTATION_WRAP = 2;

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    public GroovyCodeStyleSettings(CodeStyleSettings container) {
        super("GroovyCodeStyleSettings", container);
        this.initImportsByDefault();
    }

    public int getNamesCountToUseImportOnDemand() {
        return this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setNamesCountToUseImportOnDemand(int value) {
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    public int getClassCountToUseImportOnDemand() {
        return this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setClassCountToUseImportOnDemand(int value) {
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    public boolean isInsertInnerClassImports() {
        return this.INSERT_INNER_CLASS_IMPORTS;
    }

    public void setInsertInnerClassImports(boolean value) {
        this.INSERT_INNER_CLASS_IMPORTS = value;
    }

    public boolean isUseSingleClassImports() {
        return this.USE_SINGLE_CLASS_IMPORTS;
    }

    public void setUseSingleClassImports(boolean value) {
        this.USE_SINGLE_CLASS_IMPORTS = value;
    }

    public boolean isUseFqClassNames() {
        return this.USE_FQ_CLASS_NAMES;
    }

    public void setUseFqClassNames(boolean value) {
        this.USE_FQ_CLASS_NAMES = value;
    }

    public PackageEntryTable getImportLayoutTable() {
        return this.IMPORT_LAYOUT_TABLE;
    }

    public PackageEntryTable getPackagesToUseImportOnDemand() {
        return this.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
    }

    public boolean isLayoutStaticImportsSeparately() {
        return this.LAYOUT_STATIC_IMPORTS_SEPARATELY;
    }

    public void setLayoutStaticImportsSeparately(boolean value) {
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = value;
    }
}

