/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.clauses;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrCaseSectionImpl
extends GroovyPsiElementImpl
implements GrCaseSection {
    public GrCaseSectionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitCaseSection(this);
    }

    public String toString() {
        return "Case section";
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "processDeclarations"));
        }
        return ResolveUtil.processChildren(this, processor, state, lastParent, place);
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    @Override
    @NotNull
    public GrCaseLabel[] getCaseLabels() {
        List labels = this.findChildrenByType(GroovyElementTypes.CASE_LABEL);
        GrCaseLabel[] grCaseLabelArray = labels.toArray(new GrCaseLabel[labels.size()]);
        if (grCaseLabelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "getCaseLabels"));
        }
        return grCaseLabelArray;
    }

    @Override
    public boolean isDefault() {
        List labels = this.findChildrenByType(GroovyElementTypes.CASE_LABEL);
        for (GrCaseLabel label : labels) {
            if (!label.isDefault()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        GrStatement[] grStatementArray = PsiImplUtil.getStatements(this);
        if (grStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "getStatements"));
        }
        return grStatementArray;
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement element, @Nullable GrStatement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "addStatementBefore"));
        }
        ASTNode elemNode = element.copy().getNode();
        assert (elemNode != null);
        ASTNode anchorNode = anchor != null ? anchor.getNode() : null;
        this.getNode().addChild(elemNode, anchorNode);
        if (this.mayUseNewLinesAsSeparators()) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mSEMI, (CharSequence)";", anchorNode);
        }
        GrStatement grStatement = (GrStatement)elemNode.getPsi();
        if (grStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrCaseSectionImpl", "addStatementBefore"));
        }
        return grStatement;
    }

    private boolean mayUseNewLinesAsSeparators() {
        for (GrCaseSectionImpl parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof GrString)) continue;
            GrString grString = (GrString)((Object)parent);
            return !grString.isPlainString();
        }
        return true;
    }
}

