/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.copyright.ui.CopyrightFormattingConfigurable;
import com.maddyhome.idea.copyright.ui.CopyrightProfilesPanel;
import com.maddyhome.idea.copyright.ui.ProjectSettingsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CopyrightProjectConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll {
    private final Project project;
    private ProjectSettingsPanel myOptionsPanel = null;
    private final CopyrightProfilesPanel myProfilesPanel;

    public CopyrightProjectConfigurable(Project project) {
        this.project = project;
        this.myProfilesPanel = new CopyrightProfilesPanel(project);
    }

    public String getDisplayName() {
        return "Copyright";
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        this.myOptionsPanel = new ProjectSettingsPanel(this.project, this.myProfilesPanel);
        this.myProfilesPanel.setUpdate(this::reloadProfiles);
        return this.myOptionsPanel.getMainComponent();
    }

    public boolean isModified() {
        if (this.myOptionsPanel != null) {
            return this.myOptionsPanel.isModified();
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.apply();
        }
    }

    public void reset() {
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.reset();
        }
    }

    public void disposeUIResources() {
        this.myOptionsPanel = null;
    }

    public boolean hasOwnContent() {
        return true;
    }

    @NotNull
    public String getId() {
        if ("copyright" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/ui/CopyrightProjectConfigurable", "getId"));
        }
        return "copyright";
    }

    protected Configurable[] buildConfigurables() {
        return new Configurable[]{this.myProfilesPanel, new CopyrightFormattingConfigurable(this.project)};
    }

    private void reloadProfiles() {
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.reloadCopyrightProfiles();
        }
    }
}

