/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.intention;

import com.android.resources.ResourceType;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.VariableOfTypeMacro;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.intention.CreateXmlResourceParameters;
import org.jetbrains.kotlin.android.intention.CreateXmlResourceParametersKt;
import org.jetbrains.kotlin.android.intention.KotlinAndroidAddStringResource;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J@\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0017\u0010\u0018\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002J\b\u0010!\u001a\u00020\u001dH\u0016J\f\u0010\"\u001a\u00020\u001d*\u00020#H\u0002J\f\u0010$\u001a\u00020\u001d*\u00020#H\u0002J\u0014\u0010%\u001a\u00020\u001d*\u00020&2\u0006\u0010'\u001a\u00020\u0010H\u0002J\u001a\u0010(\u001a\u00020\u001d*\u00020\u000e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0002J\u001a\u0010(\u001a\u00020\u001d*\u00020+2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0002J\u001a\u0010(\u001a\u00020\u001d*\u00020,2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0002J\u0014\u0010-\u001a\u00020\u001d*\u00020&2\u0006\u0010'\u001a\u00020\u0010H\u0002J\u001a\u0010.\u001a\u00020\u001d*\u00020#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0002J\u001a\u0010/\u001a\u00020\u001d*\u00020\u000e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0002\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/android/intention/KotlinAndroidAddStringResource;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "createResourceReference", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lcom/intellij/psi/PsiElement;", "aPackage", "", "resName", "resType", "Lcom/android/resources/ResourceType;", "getCreateXmlResourceParameters", "Lorg/jetbrains/kotlin/android/intention/CreateXmlResourceParameters;", "contextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getManifestPackage", "Lorg/jetbrains/annotations/Nullable;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "isApplicableTo", "", "caretOffset", "", "needContextReceiver", "startInWriteAction", "isInnerClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isObjectLiteral", "isStrictSubclassOf", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "className", "isSubclassExtensionOfAny", "baseClasses", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isSubclassOf", "isSubclassOfAny", "isSubclassOrSubclassExtension", "Companion", "idea-android"})
public final class KotlinAndroidAddStringResource
extends SelfTargetingIntention<KtLiteralStringTemplateEntry> {
    private static final String CLASS_CONTEXT = "android.content.Context";
    private static final String CLASS_FRAGMENT = "android.app.Fragment";
    private static final String CLASS_SUPPORT_FRAGMENT = "android.support.v4.app.Fragment";
    private static final String CLASS_VIEW = "android.view.View";
    private static final String GET_STRING_METHOD = "getString";
    private static final String EXTRACT_RESOURCE_DIALOG_TITLE = "Extract Resource";
    private static final String PACKAGE_NOT_FOUND_ERROR = "package.not.found.error";
    private static final String RESOURCE_DIR_ERROR = "check.resource.dir.error";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtLiteralStringTemplateEntry element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (AndroidFacet.getInstance((PsiElement)((PsiElement)element2.getContainingFile())) == null) {
            return false;
        }
        return ((Object[])element2.getParent().getChildren()).length == 1;
    }

    @Override
    public void applyTo(@NotNull KtLiteralStringTemplateEntry element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)((PsiElement)element2.getContainingFile()));
        if (editor == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor.");
        }
        if (facet == null) {
            throw (Throwable)new IllegalStateException("This intention requires android facet.");
        }
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile file2 = (KtFile)psiFile;
        Project project = file2.getProject();
        String manifestPackage = this.getManifestPackage(facet);
        if (manifestPackage == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message((String)KotlinAndroidAddStringResource.Companion.getPACKAGE_NOT_FOUND_ERROR(), (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        Module module = facet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
        CreateXmlResourceParameters createXmlResourceParameters = this.getCreateXmlResourceParameters(module, element2, virtualFile2);
        if (createXmlResourceParameters == null) {
            return;
        }
        CreateXmlResourceParameters parameters2 = createXmlResourceParameters;
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this, project, parameters2, facet, editor, file2, element2, manifestPackage){
            final /* synthetic */ KotlinAndroidAddStringResource this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ CreateXmlResourceParameters $parameters;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ KtLiteralStringTemplateEntry $element;
            final /* synthetic */ String $manifestPackage;

            public final void invoke() {
                if (!AndroidResourceUtil.createValueResource((Project)this.$project, (VirtualFile)this.$parameters.getResourceDirectory(), (String)this.$parameters.getName(), (ResourceType)ResourceType.STRING, (String)this.$parameters.getFileName(), this.$parameters.getDirectoryNames(), (String)this.$parameters.getValue())) {
                    return;
                }
                Module module = this.$facet.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
                KotlinAndroidAddStringResource.access$createResourceReference(this.this$0, module, this.$editor, this.$file, (PsiElement)this.$element, this.$manifestPackage, this.$parameters.getName(), ResourceType.STRING);
                PsiDocumentManager.getInstance((Project)this.$project).commitAllDocuments();
                UndoUtil.markPsiFileForUndo((PsiFile)((PsiFile)this.$file));
            }
            {
                this.this$0 = kotlinAndroidAddStringResource;
                this.$project = project;
                this.$parameters = createXmlResourceParameters;
                this.$facet = androidFacet;
                this.$editor = editor;
                this.$file = ktFile;
                this.$element = ktLiteralStringTemplateEntry;
                this.$manifestPackage = string;
                super(0);
            }
        });
    }

    private final CreateXmlResourceParameters getCreateXmlResourceParameters(Module module, KtLiteralStringTemplateEntry element2, VirtualFile contextFile) {
        String stringValue = element2.getText();
        boolean showDialog = !ApplicationManager.getApplication().isUnitTestMode();
        String resourceName = (String)element2.getUserData(CreateXmlResourceParametersKt.getCREATE_XML_RESOURCE_PARAMETERS_NAME_KEY());
        CreateXmlResourceDialog dialog2 = new CreateXmlResourceDialog(module, ResourceType.STRING, resourceName, stringValue, true, null, contextFile);
        dialog2.setTitle(KotlinAndroidAddStringResource.Companion.getEXTRACT_RESOURCE_DIALOG_TITLE());
        if (showDialog) {
            if (!dialog2.showAndGet()) {
                return null;
            }
        } else {
            dialog2.close(0);
        }
        VirtualFile resourceDirectory = dialog2.getResourceDirectory();
        if (resourceDirectory == null) {
            AndroidUtils.reportError((Project)module.getProject(), (String)AndroidBundle.message((String)KotlinAndroidAddStringResource.Companion.getRESOURCE_DIR_ERROR(), (Object[])new Object[]{module}));
            return null;
        }
        String string = dialog2.getResourceName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.resourceName");
        String string2 = dialog2.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dialog.value");
        String string3 = dialog2.getFileName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dialog.fileName");
        List list2 = dialog2.getDirNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"dialog.dirNames");
        return new CreateXmlResourceParameters(string, string2, string3, resourceDirectory, list2);
    }

    private final void createResourceReference(Module module, Editor editor, KtFile file2, PsiElement element2, String aPackage, String resName, ResourceType resType) {
        TemplateImpl template2;
        String rFieldName = AndroidResourceUtil.getRJavaFieldName((String)resName);
        String fieldName = aPackage + ".R." + resType + "." + rFieldName;
        if (!this.needContextReceiver(element2)) {
            template2 = new TemplateImpl("", KotlinAndroidAddStringResource.Companion.getGET_STRING_METHOD() + "(" + fieldName + ")", "");
        } else {
            template2 = new TemplateImpl("", "$" + "context" + "$" + "." + KotlinAndroidAddStringResource.Companion.getGET_STRING_METHOD() + "(" + fieldName + ")", "");
            MacroCallNode marker = new MacroCallNode((Macro)new VariableOfTypeMacro());
            marker.addParameter((Expression)new ConstantNode(KotlinAndroidAddStringResource.Companion.getCLASS_CONTEXT()));
            template2.addVariable("context", (Expression)marker, (Expression)new ConstantNode("context"), true);
        }
        PsiElement containingLiteralExpression = element2.getParent();
        editor.getCaretModel().moveToOffset(containingLiteralExpression.getTextOffset());
        editor.getDocument().deleteString(containingLiteralExpression.getTextRange().getStartOffset(), containingLiteralExpression.getTextRange().getEndOffset());
        RangeMarker marker = editor.getDocument().createRangeMarker(containingLiteralExpression.getTextOffset(), containingLiteralExpression.getTextOffset());
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        TemplateManager.getInstance((Project)module.getProject()).startTemplate(editor, (Template)template2, false, null, (TemplateEditingListener)new TemplateEditingAdapter(file2, marker){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ RangeMarker $marker;

            public void waitingForInput(@Nullable Template template2) {
                ShortenReferences.DEFAULT.process(this.$file, this.$marker.getStartOffset(), this.$marker.getEndOffset());
            }

            public void beforeTemplateFinished(@Nullable TemplateState state, @Nullable Template template2) {
                ShortenReferences.DEFAULT.process(this.$file, this.$marker.getStartOffset(), this.$marker.getEndOffset());
            }
            {
                this.$file = $captured_local_variable$0;
                this.$marker = $captured_local_variable$1;
            }
        });
    }

    private final boolean needContextReceiver(PsiElement element2) {
        List classesWithGetSting = CollectionsKt.listOf((Object[])new String[]{KotlinAndroidAddStringResource.Companion.getCLASS_CONTEXT(), KotlinAndroidAddStringResource.Companion.getCLASS_FRAGMENT(), KotlinAndroidAddStringResource.Companion.getCLASS_SUPPORT_FRAGMENT()});
        List viewClass = CollectionsKt.listOf((Object)KotlinAndroidAddStringResource.Companion.getCLASS_VIEW());
        PsiElement parent2 = PsiTreeUtil.findFirstParent((PsiElement)element2, (boolean)true, (Condition)needContextReceiver.parent.1.INSTANCE);
        while (parent2 != null) {
            if (this.isSubclassOrSubclassExtension(parent2, classesWithGetSting)) {
                return false;
            }
            if (this.isSubclassOrSubclassExtension(parent2, viewClass) || parent2 instanceof KtClassOrObject && !this.isInnerClass((KtClassOrObject)parent2) && !this.isObjectLiteral((KtClassOrObject)parent2)) {
                return true;
            }
            parent2 = PsiTreeUtil.findFirstParent((PsiElement)parent2, (boolean)true, (Condition)needContextReceiver.1.INSTANCE);
        }
        return true;
    }

    private final String getManifestPackage(AndroidFacet facet) {
        Manifest manifest = facet.getManifest();
        return manifest != null && (manifest = manifest.getPackage()) != null ? (String)manifest.getValue() : null;
    }

    private final boolean isSubclassOrSubclassExtension(@NotNull PsiElement $receiver, Collection<String> baseClasses) {
        PsiElement psiElement2 = $receiver;
        if (!(psiElement2 instanceof KtClassOrObject)) {
            psiElement2 = null;
        }
        KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement2;
        return ktClassOrObject != null ? this.isSubclassOfAny(ktClassOrObject, baseClasses) : this.isSubclassExtensionOfAny($receiver, baseClasses);
    }

    private final boolean isSubclassExtensionOfAny(@NotNull PsiElement $receiver, Collection<String> baseClasses) {
        Boolean bl;
        PsiElement psiElement2 = $receiver;
        if (!(psiElement2 instanceof KtLambdaExpression)) {
            psiElement2 = null;
        }
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)psiElement2;
        if (ktLambdaExpression != null) {
            bl = this.isSubclassExtensionOfAny(ktLambdaExpression, baseClasses);
        } else {
            PsiElement psiElement3 = $receiver;
            if (!(psiElement3 instanceof KtFunction)) {
                psiElement3 = null;
            }
            KtFunction ktFunction = (KtFunction)psiElement3;
            bl = ktFunction != null ? Boolean.valueOf(this.isSubclassExtensionOfAny(ktFunction, baseClasses)) : null;
        }
        return bl != null ? bl : false;
    }

    private final boolean isObjectLiteral(@NotNull KtClassOrObject $receiver) {
        KtClassOrObject ktClassOrObject = $receiver;
        if (!(ktClassOrObject instanceof KtObjectDeclaration)) {
            ktClassOrObject = null;
        }
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)ktClassOrObject;
        return ktObjectDeclaration != null ? ktObjectDeclaration.isObjectLiteral() : false;
    }

    private final boolean isInnerClass(@NotNull KtClassOrObject $receiver) {
        KtClassOrObject ktClassOrObject = $receiver;
        if (!(ktClassOrObject instanceof KtClass)) {
            ktClassOrObject = null;
        }
        KtClass ktClass = (KtClass)ktClassOrObject;
        return ktClass != null ? ktClass.isInner() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSubclassExtensionOfAny(@NotNull KtFunction $receiver, Collection<String> baseClasses) {
        Object element$iv;
        String it;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default($receiver, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        }
        FunctionDescriptor descriptor2 = (FunctionDescriptor)declarationDescriptor;
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        Object object = receiverParameterDescriptor;
        if (receiverParameterDescriptor == null) return false;
        KotlinType kotlinType = object.getType();
        object = kotlinType;
        if (kotlinType == null) return false;
        TypeConstructor typeConstructor2 = ((KotlinType)object).getConstructor();
        object = typeConstructor2;
        if (typeConstructor2 == null) return false;
        ClassifierDescriptor classifierDescriptor = object.getDeclarationDescriptor();
        ClassifierDescriptor extendedTypeDescriptor = classifierDescriptor;
        if (extendedTypeDescriptor == null) return false;
        Iterable $receiver$iv = baseClasses;
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!this.isSubclassOf(extendedTypeDescriptor, it = (String)(element$iv = iterator2.next())));
        return true;
    }

    private final boolean isSubclassExtensionOfAny(@NotNull KtLambdaExpression $receiver, Collection<String> baseClasses) {
        BindingContext bindingContext2 = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
        KotlinType type2 = bindingContext2.getType($receiver);
        if (type2 == null || !FunctionTypesKt.isExtensionFunctionType(type2)) {
            return false;
        }
        ClassifierDescriptor extendedTypeDescriptor = ((TypeProjection)CollectionsKt.first(type2.getArguments())).getType().getConstructor().getDeclarationDescriptor();
        if (extendedTypeDescriptor != null) {
            boolean bl;
            block3: {
                Iterable $receiver$iv = baseClasses;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!this.isSubclassOf(extendedTypeDescriptor, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private final boolean isSubclassOfAny(@NotNull KtClassOrObject $receiver, Collection<String> baseClasses) {
        boolean bl;
        block1: {
            BindingContext bindingContext2 = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
            ClassDescriptor declarationDescriptor = (ClassDescriptor)bindingContext2.get(BindingContext.CLASS, $receiver);
            Iterable $receiver$iv = baseClasses;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                ClassDescriptor classDescriptor = declarationDescriptor;
                if (!(classDescriptor != null ? this.isSubclassOf(classDescriptor, it) : false)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSubclassOf(@NotNull ClassifierDescriptor $receiver, String className2) {
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe($receiver).asString(), (Object)className2) || this.isStrictSubclassOf($receiver, className2);
    }

    private final boolean isStrictSubclassOf(@NotNull ClassifierDescriptor $receiver, String className2) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = $receiver.getDefaultType().getConstructor().getSupertypes();
            for (Object element$iv : $receiver$iv) {
                KotlinType it = (KotlinType)element$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor != null ? this.isSubclassOf(classifierDescriptor, className2) : false)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public KotlinAndroidAddStringResource() {
        super(KtLiteralStringTemplateEntry.class, "Extract string resource", null, 4, null);
    }

    static {
        CLASS_CONTEXT = CLASS_CONTEXT;
        CLASS_FRAGMENT = CLASS_FRAGMENT;
        CLASS_SUPPORT_FRAGMENT = CLASS_SUPPORT_FRAGMENT;
        CLASS_VIEW = CLASS_VIEW;
        GET_STRING_METHOD = GET_STRING_METHOD;
        EXTRACT_RESOURCE_DIALOG_TITLE = EXTRACT_RESOURCE_DIALOG_TITLE;
        PACKAGE_NOT_FOUND_ERROR = PACKAGE_NOT_FOUND_ERROR;
        RESOURCE_DIR_ERROR = RESOURCE_DIR_ERROR;
    }

    public static final /* synthetic */ void access$createResourceReference(KotlinAndroidAddStringResource $this, @NotNull Module module, @NotNull Editor editor, @NotNull KtFile file2, @NotNull PsiElement element2, @NotNull String aPackage, @NotNull String resName, @NotNull ResourceType resType) {
        $this.createResourceReference(module, editor, file2, element2, aPackage, resName, resType);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/android/intention/KotlinAndroidAddStringResource$Companion;", "", "()V", "CLASS_CONTEXT", "", "getCLASS_CONTEXT", "()Ljava/lang/String;", "CLASS_FRAGMENT", "getCLASS_FRAGMENT", "CLASS_SUPPORT_FRAGMENT", "getCLASS_SUPPORT_FRAGMENT", "CLASS_VIEW", "getCLASS_VIEW", "EXTRACT_RESOURCE_DIALOG_TITLE", "getEXTRACT_RESOURCE_DIALOG_TITLE", "GET_STRING_METHOD", "getGET_STRING_METHOD", "PACKAGE_NOT_FOUND_ERROR", "getPACKAGE_NOT_FOUND_ERROR", "RESOURCE_DIR_ERROR", "getRESOURCE_DIR_ERROR", "idea-android"})
    private static final class Companion {
        private final String getCLASS_CONTEXT() {
            return CLASS_CONTEXT;
        }

        private final String getCLASS_FRAGMENT() {
            return CLASS_FRAGMENT;
        }

        private final String getCLASS_SUPPORT_FRAGMENT() {
            return CLASS_SUPPORT_FRAGMENT;
        }

        private final String getCLASS_VIEW() {
            return CLASS_VIEW;
        }

        private final String getGET_STRING_METHOD() {
            return GET_STRING_METHOD;
        }

        private final String getEXTRACT_RESOURCE_DIALOG_TITLE() {
            return EXTRACT_RESOURCE_DIALOG_TITLE;
        }

        private final String getPACKAGE_NOT_FOUND_ERROR() {
            return PACKAGE_NOT_FOUND_ERROR;
        }

        private final String getRESOURCE_DIR_ERROR() {
            return RESOURCE_DIR_ERROR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

