/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ClearableLazyValue;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptConfigurationManagerKt$sam$Runnable$5974abf6;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptDependenciesClassFinder;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.script.KotlinScriptExternalImportsProvider;
import org.jetbrains.kotlin.script.ScriptTemplateProviderExtensionPointKt;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u0018\u001a\u00020\u0010J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u001a\u001a\u00020\u0010J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u000eJ\b\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J$\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/KotlinScriptConfigurationManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "dumbService", "Lcom/intellij/openapi/project/DumbService;", "scriptDefinitionProvider", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;", "scriptExternalImportsProvider", "Lorg/jetbrains/kotlin/script/KotlinScriptExternalImportsProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/project/DumbService;Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;Lorg/jetbrains/kotlin/script/KotlinScriptExternalImportsProvider;)V", "allLibrarySourcesCache", "Lorg/jetbrains/kotlin/idea/core/script/ClearableLazyValue;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "allLibrarySourcesScope", "Lcom/intellij/psi/search/NonClasspathDirectoriesScope;", "allScriptsClasspathCache", "allScriptsClasspathScope", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "cacheAllScriptsExtraImports", "", "getAllLibrarySources", "getAllLibrarySourcesScope", "getAllScriptsClasspath", "getAllScriptsClasspathScope", "getScriptClasspath", "file", "invalidateLocalCaches", "notifyRootsChanged", "reloadScriptDefinitions", "updateExternalImportsCache", "files", "", "onChange", "Lkotlin/Function0;", "Companion", "idea-core"})
public final class KotlinScriptConfigurationManager {
    private final ReentrantReadWriteLock cacheLock;
    private final ClearableLazyValue<List<VirtualFile>> allScriptsClasspathCache;
    private final ClearableLazyValue<NonClasspathDirectoriesScope> allScriptsClasspathScope;
    private final ClearableLazyValue<List<VirtualFile>> allLibrarySourcesCache;
    private final ClearableLazyValue<NonClasspathDirectoriesScope> allLibrarySourcesScope;
    private final Project project;
    private final DumbService dumbService;
    private final KotlinScriptDefinitionProvider scriptDefinitionProvider;
    private final KotlinScriptExternalImportsProvider scriptExternalImportsProvider;
    @NotNull
    private static final Logger log;
    public static final Companion Companion;

    private final void notifyRootsChanged() {
        Function0 rootsChangesRunnable2 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ KotlinScriptConfigurationManager this$0;

            public final void invoke() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ notifyRootsChanged.rootsChangesRunnable.1 this$0;

                    public final void invoke() {
                        if (KotlinScriptConfigurationManager.access$getProject$p(this.this$0.this$0).isDisposed()) {
                            return;
                        }
                        ProjectRootManagerEx projectRootManagerEx = ProjectRootManagerEx.getInstanceEx((Project)KotlinScriptConfigurationManager.access$getProject$p(this.this$0.this$0));
                        if (projectRootManagerEx != null) {
                            projectRootManagerEx.makeRootsChange(EmptyRunnable.getInstance(), false, true);
                        }
                        ScriptDependenciesModificationTracker.Companion.getInstance(KotlinScriptConfigurationManager.access$getProject$p(this.this$0.this$0)).incModificationCount();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = kotlinScriptConfigurationManager;
                super(0);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            rootsChangesRunnable2.invoke();
        } else {
            application.invokeLater((Runnable)new KotlinScriptConfigurationManagerKt$sam$Runnable$5974abf6(rootsChangesRunnable2));
        }
    }

    @NotNull
    public final List<VirtualFile> getScriptClasspath(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Object object = this.scriptExternalImportsProvider.getExternalImports(file2);
        if (object == null || (object = object.getClasspath()) == null) {
            object = CollectionsKt.emptyList();
        }
        return Companion.toVfsRoots((Iterable<? extends File>)object);
    }

    @NotNull
    public final List<VirtualFile> getAllScriptsClasspath() {
        return this.allScriptsClasspathCache.get();
    }

    @NotNull
    public final List<VirtualFile> getAllLibrarySources() {
        return this.allLibrarySourcesCache.get();
    }

    @NotNull
    public final NonClasspathDirectoriesScope getAllScriptsClasspathScope() {
        return this.allScriptsClasspathScope.get();
    }

    @NotNull
    public final NonClasspathDirectoriesScope getAllLibrarySourcesScope() {
        return this.allLibrarySourcesScope.get();
    }

    private final void reloadScriptDefinitions() {
        List<KotlinScriptDefinitionFromAnnotatedTemplate> list2;
        List<KotlinScriptDefinitionFromAnnotatedTemplate> it = list2 = ScriptTemplateProviderExtensionPointKt.makeScriptDefsFromTemplatesProviderExtensions(this.project, (Function2<? super ScriptTemplatesProvider, ? super Exception, Unit>)((Function2)reloadScriptDefinitions.1.INSTANCE));
        this.scriptDefinitionProvider.setScriptDefinitions(it);
    }

    private final void cacheAllScriptsExtraImports() {
        ApplicationUtilsKt.runReadAction((Function0)new Function0<KotlinScriptExternalImportsProvider>(this){
            final /* synthetic */ KotlinScriptConfigurationManager this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final KotlinScriptExternalImportsProvider invoke() {
                void $receiver$iv$iv;
                void $receiver$iv;
                KotlinScriptExternalImportsProvider kotlinScriptExternalImportsProvider;
                KotlinScriptExternalImportsProvider $receiver = kotlinScriptExternalImportsProvider = KotlinScriptConfigurationManager.access$getScriptExternalImportsProvider$p(this.this$0);
                $receiver.invalidateCaches();
                Iterable<LanguageFileType> iterable = KotlinScriptConfigurationManager.access$getScriptDefinitionProvider$p(this.this$0).getAllKnownFileTypes();
                KotlinScriptExternalImportsProvider kotlinScriptExternalImportsProvider2 = $receiver;
                void var5_5 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    LanguageFileType it = (LanguageFileType)element$iv$iv;
                    Iterable list$iv$iv = FileTypeIndex.getFiles((FileType)((FileType)it), (GlobalSearchScope)GlobalSearchScope.allScope((Project)$receiver.getProject()));
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                kotlinScriptExternalImportsProvider2.cacheExternalImports(list2);
                return kotlinScriptExternalImportsProvider;
            }
            {
                this.this$0 = kotlinScriptConfigurationManager;
                super(0);
            }
        });
    }

    private final void updateExternalImportsCache(Iterable<? extends VirtualFile> files2, Function0<Unit> onChange) {
        boolean isChanged = CollectionsKt.any(this.scriptExternalImportsProvider.updateExternalImportsCache(files2));
        if (isChanged) {
            onChange.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void invalidateLocalCaches() {
        void $receiver$iv$iv;
        this.allScriptsClasspathCache.clear();
        this.allScriptsClasspathScope.clear();
        this.allLibrarySourcesCache.clear();
        this.allLibrarySourcesScope.clear();
        Object[] $receiver$iv = Extensions.getArea((AreaInstance)((AreaInstance)this.project)).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions();
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            if (!(element$iv$iv instanceof KotlinScriptDependenciesClassFinder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KotlinScriptDependenciesClassFinder kotlinScriptDependenciesClassFinder = (KotlinScriptDependenciesClassFinder)CollectionsKt.single((List)((List)destination$iv$iv));
        kotlinScriptDependenciesClassFinder.clearCache();
    }

    public KotlinScriptConfigurationManager(@NotNull Project project, @NotNull DumbService dumbService, @NotNull KotlinScriptDefinitionProvider scriptDefinitionProvider, @NotNull KotlinScriptExternalImportsProvider scriptExternalImportsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dumbService, (String)"dumbService");
        Intrinsics.checkParameterIsNotNull((Object)scriptDefinitionProvider, (String)"scriptDefinitionProvider");
        Intrinsics.checkParameterIsNotNull((Object)scriptExternalImportsProvider, (String)"scriptExternalImportsProvider");
        this.project = project;
        this.dumbService = dumbService;
        this.scriptDefinitionProvider = scriptDefinitionProvider;
        this.scriptExternalImportsProvider = scriptExternalImportsProvider;
        this.reloadScriptDefinitions();
        StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public final void run() {
                DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        this.cacheAllScriptsExtraImports();
                        this.invalidateLocalCaches();
                        this.notifyRootsChanged();
                    }
                });
            }
        });
        this.project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            /*
             * WARNING - void declaration
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                Iterable iterable = events;
                KotlinScriptConfigurationManager kotlinScriptConfigurationManager = this;
                void var3_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    VirtualFile virtualFile2;
                    Object element$iv$iv = element$iv$iv$iv;
                    VFileEvent it = (VFileEvent)element$iv$iv;
                    if (it.getFile() == null) continue;
                    VirtualFile it$iv$iv = virtualFile2;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                kotlinScriptConfigurationManager.updateExternalImportsCache(list2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ 2 this$0;

                    public final void invoke() {
                        KotlinScriptConfigurationManager.access$invalidateLocalCaches(this.this$0.this);
                        KotlinScriptConfigurationManager.access$notifyRootsChanged(this.this$0.this);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
        });
        this.cacheLock = new ReentrantReadWriteLock();
        this.allScriptsClasspathCache = new ClearableLazyValue(this.cacheLock, (Function0)new Function0<List<? extends VirtualFile>>(this){
            final /* synthetic */ KotlinScriptConfigurationManager this$0;

            @NotNull
            public final List<VirtualFile> invoke() {
                return KotlinScriptConfigurationManager.Companion.toVfsRoots(CollectionsKt.distinct((Iterable)KotlinScriptConfigurationManager.access$getScriptExternalImportsProvider$p(this.this$0).getKnownCombinedClasspath()));
            }
            {
                this.this$0 = kotlinScriptConfigurationManager;
                super(0);
            }
        });
        this.allScriptsClasspathScope = new ClearableLazyValue(this.cacheLock, (Function0)new Function0<NonClasspathDirectoriesScope>(this){
            final /* synthetic */ KotlinScriptConfigurationManager this$0;

            @NotNull
            public final NonClasspathDirectoriesScope invoke() {
                return new NonClasspathDirectoriesScope((Collection)this.this$0.getAllScriptsClasspath());
            }
            {
                this.this$0 = kotlinScriptConfigurationManager;
                super(0);
            }
        });
        this.allLibrarySourcesCache = new ClearableLazyValue(this.cacheLock, (Function0)new Function0<List<? extends VirtualFile>>(this){
            final /* synthetic */ KotlinScriptConfigurationManager this$0;

            @NotNull
            public final List<VirtualFile> invoke() {
                return KotlinScriptConfigurationManager.Companion.toVfsRoots(CollectionsKt.distinct((Iterable)KotlinScriptConfigurationManager.access$getScriptExternalImportsProvider$p(this.this$0).getKnownSourceRoots()));
            }
            {
                this.this$0 = kotlinScriptConfigurationManager;
                super(0);
            }
        });
        this.allLibrarySourcesScope = new ClearableLazyValue(this.cacheLock, (Function0)new Function0<NonClasspathDirectoriesScope>(this){
            final /* synthetic */ KotlinScriptConfigurationManager this$0;

            @NotNull
            public final NonClasspathDirectoriesScope invoke() {
                return new NonClasspathDirectoriesScope((Collection)this.this$0.getAllLibrarySources());
            }
            {
                this.this$0 = kotlinScriptConfigurationManager;
                super(0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        log = Logger.getInstance(KotlinScriptConfigurationManager.class);
    }

    @NotNull
    public static final /* synthetic */ KotlinScriptDefinitionProvider access$getScriptDefinitionProvider$p(KotlinScriptConfigurationManager $this) {
        return $this.scriptDefinitionProvider;
    }

    @JvmStatic
    @NotNull
    public static final KotlinScriptConfigurationManager getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u0013H\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/KotlinScriptConfigurationManager$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog$idea_core", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/KotlinScriptConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "reloadScriptDefinitions", "", "toVfsRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "Ljava/io/File;", "classpathEntryToVfs", "idea-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final KotlinScriptConfigurationManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, KotlinScriptConfigurationManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ationManager::class.java)");
            return (KotlinScriptConfigurationManager)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> toVfsRoots(@NotNull Iterable<? extends File> roots) {
            void $receiver$iv$iv;
            Iterable<? extends File> $receiver$iv;
            Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
            Iterable<? extends File> iterable = $receiver$iv = roots;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                VirtualFile virtualFile2;
                Object element$iv$iv = element$iv$iv$iv;
                File it = (File)element$iv$iv;
                if (Companion.classpathEntryToVfs(it) == null) continue;
                VirtualFile it$iv$iv = virtualFile2;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final VirtualFile classpathEntryToVfs(@NotNull File $receiver) {
            Object object;
            if (!$receiver.exists()) {
                object = null;
            } else if ($receiver.isDirectory()) {
                VirtualFileSystem virtualFileSystem = StandardFileSystems.local();
                object = virtualFileSystem != null ? virtualFileSystem.findFileByPath($receiver.getCanonicalPath()) : null;
            } else if ($receiver.isFile()) {
                VirtualFileSystem virtualFileSystem = StandardFileSystems.jar();
                object = virtualFileSystem != null ? virtualFileSystem.findFileByPath($receiver.getCanonicalPath() + "!/") : null;
            } else {
                object = null;
            }
            VirtualFile res2 = object;
            return res2;
        }

        @NotNull
        public final Logger getLog$idea_core() {
            return log;
        }

        public final void reloadScriptDefinitions(@NotNull Project project) {
            KotlinScriptConfigurationManager kotlinScriptConfigurationManager;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            KotlinScriptConfigurationManager $receiver = kotlinScriptConfigurationManager = this.getInstance(project);
            $receiver.reloadScriptDefinitions();
            $receiver.scriptExternalImportsProvider.invalidateCaches();
            $receiver.invalidateLocalCaches();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

