/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.highlighter.AnnotationPresentationInfo$WhenMappings;
import org.jetbrains.kotlin.idea.highlighter.IdeErrorMessages;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo;", "", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "nonDefaultMessage", "", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "textAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "(Ljava/util/List;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;Lcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "getHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "getNonDefaultMessage", "()Ljava/lang/String;", "getRanges", "()Ljava/util/List;", "getTextAttributes", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "create", "Lcom/intellij/lang/annotation/Annotation;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "range", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getDefaultMessage", "getMessage", "idea-analysis"})
final class AnnotationPresentationInfo {
    @NotNull
    private final List<TextRange> ranges;
    @Nullable
    private final String nonDefaultMessage;
    @Nullable
    private final ProblemHighlightType highlightType;
    @Nullable
    private final TextAttributesKey textAttributes;

    @NotNull
    public final Annotation create(@NotNull Diagnostic diagnostic, @NotNull TextRange range, @NotNull AnnotationHolder holder) {
        Annotation annotation2;
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        String string = this.nonDefaultMessage;
        if (string == null) {
            string = this.getDefaultMessage(diagnostic);
        }
        String defaultMessage = string;
        switch (AnnotationPresentationInfo$WhenMappings.$EnumSwitchMapping$0[diagnostic.getSeverity().ordinal()]) {
            case 1: {
                annotation2 = holder.createErrorAnnotation(range, defaultMessage);
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)this.highlightType, (Object)ProblemHighlightType.WEAK_WARNING)) {
                    annotation2 = holder.createWeakWarningAnnotation(range, defaultMessage);
                    break;
                }
                annotation2 = holder.createWarningAnnotation(range, defaultMessage);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Only ERROR and WARNING diagnostics are supported");
            }
        }
        Annotation annotation3 = annotation2;
        annotation3.setTooltip(this.getMessage(diagnostic));
        if (this.highlightType != null) {
            annotation3.setHighlightType(this.highlightType);
        }
        if (this.textAttributes != null) {
            annotation3.setTextAttributes(this.textAttributes);
        }
        Annotation annotation4 = annotation3;
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation4, (String)"annotation");
        return annotation4;
    }

    private final String getMessage(Diagnostic diagnostic) {
        String message2 = IdeErrorMessages.render(diagnostic);
        if (KotlinInternalMode.Instance.getEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            String factoryName = diagnostic.getFactory().getName();
            if (StringsKt.startsWith$default((String)message2, (String)"<html>", (boolean)false, (int)2, null)) {
                String string = message2;
                int n = "<html>".length();
                StringBuilder stringBuilder = new StringBuilder().append("<html>[").append(factoryName).append("] ");
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                message2 = stringBuilder.append(string4).toString();
            } else {
                message2 = "[" + factoryName + "] " + message2;
            }
        }
        if (!StringsKt.startsWith$default((String)message2, (String)"<html>", (boolean)false, (int)2, null)) {
            message2 = "<html><body>" + XmlStringUtil.escapeString((String)message2) + "</body></html>";
        }
        String string = message2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        return string;
    }

    private final String getDefaultMessage(Diagnostic diagnostic) {
        String message2 = DefaultErrorMessages.render(diagnostic);
        if (KotlinInternalMode.Instance.getEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            return "[" + diagnostic.getFactory().getName() + "] " + message2;
        }
        String string = message2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        return string;
    }

    @NotNull
    public final List<TextRange> getRanges() {
        return this.ranges;
    }

    @Nullable
    public final String getNonDefaultMessage() {
        return this.nonDefaultMessage;
    }

    @Nullable
    public final ProblemHighlightType getHighlightType() {
        return this.highlightType;
    }

    @Nullable
    public final TextAttributesKey getTextAttributes() {
        return this.textAttributes;
    }

    public AnnotationPresentationInfo(@NotNull List<? extends TextRange> ranges, @Nullable String nonDefaultMessage, @Nullable ProblemHighlightType highlightType, @Nullable TextAttributesKey textAttributes) {
        Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
        this.ranges = ranges;
        this.nonDefaultMessage = nonDefaultMessage;
        this.highlightType = highlightType;
        this.textAttributes = textAttributes;
    }

    public /* synthetic */ AnnotationPresentationInfo(List list2, String string, ProblemHighlightType problemHighlightType, TextAttributesKey textAttributesKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            problemHighlightType = null;
        }
        if ((n & 8) != 0) {
            textAttributesKey = null;
        }
        this(list2, string, problemHighlightType, textAttributesKey);
    }
}

