/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "member", "Lcom/intellij/psi/PsiMember;", "objectName", "", "(Lcom/intellij/psi/PsiMember;Ljava/lang/String;)V", "convertedCodeProcessor", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "getConvertedCodeProcessor", "()Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "javaCodeProcessors", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing$AppendObjectNameProcessor;", "getJavaCodeProcessors", "()Ljava/util/List;", "kotlinCodeProcessors", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "getKotlinCodeProcessors", "targetElement", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "AppendObjectNameProcessor", "j2k"})
public final class MemberIntoObjectProcessing
implements UsageProcessing {
    @NotNull
    private final List<AppendObjectNameProcessor> javaCodeProcessors;
    @NotNull
    private final List<ExternalCodeProcessor> kotlinCodeProcessors;
    private final PsiMember member;
    private final String objectName;

    @Override
    @NotNull
    public PsiElement getTargetElement() {
        return (PsiElement)this.member;
    }

    @Override
    @Nullable
    public ConvertedCodeProcessor getConvertedCodeProcessor() {
        return null;
    }

    @NotNull
    public List<AppendObjectNameProcessor> getJavaCodeProcessors() {
        return this.javaCodeProcessors;
    }

    @Override
    @NotNull
    public List<ExternalCodeProcessor> getKotlinCodeProcessors() {
        return this.kotlinCodeProcessors;
    }

    public MemberIntoObjectProcessing(@NotNull PsiMember member, @NotNull String objectName) {
        Intrinsics.checkParameterIsNotNull((Object)member, (String)"member");
        Intrinsics.checkParameterIsNotNull((Object)objectName, (String)"objectName");
        this.member = member;
        this.objectName = objectName;
        this.javaCodeProcessors = CollectionsKt.listOf((Object)new AppendObjectNameProcessor());
        this.kotlinCodeProcessors = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing$AppendObjectNameProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "(Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing;)V", "processUsage", "", "Lcom/intellij/psi/PsiReference;", "reference", "(Lcom/intellij/psi/PsiReference;)[Lcom/intellij/psi/PsiReference;", "j2k"})
    public final class AppendObjectNameProcessor
    implements ExternalCodeProcessor {
        @Override
        @Nullable
        public PsiReference[] processUsage(@NotNull PsiReference reference2) {
            Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
            PsiElement psiElement2 = reference2.getElement();
            if (!(psiElement2 instanceof PsiReferenceExpression)) {
                psiElement2 = null;
            }
            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiElement2;
            if (psiReferenceExpression == null) {
                return null;
            }
            PsiReferenceExpression refExpr = psiReferenceExpression;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)MemberIntoObjectProcessing.this.member.getProject());
            if (qualifier != null) {
                PsiExpression newQualifier = factory2.createExpressionFromText(qualifier.getText() + "." + MemberIntoObjectProcessing.this.objectName, null);
                qualifier.replace((PsiElement)newQualifier);
                PsiReference[] elements$iv = new PsiReference[]{reference2};
                return elements$iv;
            }
            PsiExpression psiExpression = factory2.createExpressionFromText(MemberIntoObjectProcessing.this.objectName + "." + refExpr.getText(), null);
            if (psiExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiReferenceExpression");
            }
            PsiReferenceExpression qualifiedExpr = (PsiReferenceExpression)psiExpression;
            PsiElement psiElement3 = refExpr.replace((PsiElement)qualifiedExpr);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiReferenceExpression");
            }
            qualifiedExpr = (PsiReferenceExpression)psiElement3;
            PsiReference[] elements$iv = new PsiReference[]{(PsiReference)qualifiedExpr};
            return elements$iv;
        }
    }
}

