/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class GridPaneRowResizer {
    private static final PropertyName minHeightName = new PropertyName("minHeight");
    private static final PropertyName prefHeightName = new PropertyName("prefHeight");
    private static final PropertyName maxHeightName = new PropertyName("maxHeight");
    private static final PropertyName percentHeightName = new PropertyName("percentHeight");
    private final GridPane gridPane;
    private final int rowIndex;
    private final RowSizing originalSizing;
    private final RowSizing originalSizingNext;
    private final boolean usePercentSizing;
    private final double y1;
    private final double y2;
    private final double y3;
    private final double y4;
    private final double ym;

    public GridPaneRowResizer(GridPane gridPane, int rowIndex) {
        assert (gridPane != null);
        assert (rowIndex >= 0);
        assert (rowIndex + 1 < gridPane.getRowConstraints().size());
        this.gridPane = gridPane;
        this.rowIndex = rowIndex;
        this.originalSizing = new RowSizing((RowConstraints)gridPane.getRowConstraints().get(rowIndex));
        this.originalSizingNext = new RowSizing((RowConstraints)gridPane.getRowConstraints().get(rowIndex + 1));
        this.usePercentSizing = this.countPercentWidths() == Deprecation.getGridPaneColumnCount(gridPane);
        Bounds cellBounds = Deprecation.getGridPaneCellBounds(gridPane, 0, rowIndex);
        Bounds nextBounds = Deprecation.getGridPaneCellBounds(gridPane, 0, rowIndex + 1);
        this.y1 = cellBounds.getMinY();
        this.y2 = cellBounds.getMaxY();
        this.y3 = nextBounds.getMinY();
        this.y4 = nextBounds.getMaxY();
        this.ym = this.y4 - (this.y3 - this.y2);
        assert (this.y1 <= this.ym);
    }

    public GridPane getSceneGraphObject() {
        return this.gridPane;
    }

    public int getColumnIndex() {
        return this.rowIndex;
    }

    public void updateHeight(double dy) {
        double newY2 = Math.max(this.y1, Math.min(this.ym, this.y2 + dy));
        double newY3 = newY2 + (this.y3 - this.y2);
        double newCellHeight = newY2 - this.y1;
        double newNextHeight = this.y4 - newY3;
        RowConstraints rc = (RowConstraints)this.gridPane.getRowConstraints().get(this.rowIndex);
        RowConstraints rcNext = (RowConstraints)this.gridPane.getRowConstraints().get(this.rowIndex + 1);
        if (this.usePercentSizing) {
            double ratio = newCellHeight / (this.ym - this.y1);
            double base = this.originalSizing.getPercentHeight() + this.originalSizingNext.getPercentHeight();
            double newPercentHeight = Math.floor(ratio * base);
            double newPercentHeightNext = base - newPercentHeight;
            rc.setPercentHeight(newPercentHeight);
            rcNext.setPercentHeight(newPercentHeightNext);
        } else {
            rc.setPrefHeight(newCellHeight);
            if (rc.getMinHeight() == -1.0) {
                rc.setMinHeight(newCellHeight);
            } else {
                rc.setMinHeight(Math.min(newCellHeight, rc.getMinHeight()));
            }
            if (rc.getMaxHeight() == -1.0) {
                rc.setMaxHeight(newCellHeight);
            } else {
                rc.setMaxHeight(Math.max(newCellHeight, rc.getMaxHeight()));
            }
            rcNext.setPrefHeight(newNextHeight);
            if (rcNext.getMinHeight() == -1.0) {
                rcNext.setMinHeight(newNextHeight);
            } else {
                rcNext.setMinHeight(Math.min(newNextHeight, rcNext.getMinHeight()));
            }
            if (rcNext.getMaxHeight() == -1.0) {
                rcNext.setMaxHeight(newNextHeight);
            } else {
                rcNext.setMaxHeight(Math.max(newNextHeight, rcNext.getMaxHeight()));
            }
        }
    }

    public void revertToOriginalSize() {
        RowConstraints cc = (RowConstraints)this.gridPane.getRowConstraints().get(this.rowIndex);
        RowConstraints ccNext = (RowConstraints)this.gridPane.getRowConstraints().get(this.rowIndex + 1);
        this.originalSizing.applyTo(cc);
        this.originalSizingNext.applyTo(ccNext);
    }

    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        RowConstraints cc = (RowConstraints)this.gridPane.getRowConstraints().get(this.rowIndex);
        if (!MathUtils.equals(cc.getMinHeight(), this.originalSizing.getMinHeight())) {
            result.put(minHeightName, cc.getMinHeight());
        }
        if (!MathUtils.equals(cc.getPrefHeight(), this.originalSizing.getPrefHeight())) {
            result.put(prefHeightName, cc.getPrefHeight());
        }
        if (!MathUtils.equals(cc.getMaxHeight(), this.originalSizing.getMaxHeight())) {
            result.put(maxHeightName, cc.getMaxHeight());
        }
        if (!MathUtils.equals(cc.getPercentHeight(), this.originalSizing.getPercentHeight())) {
            result.put(percentHeightName, cc.getPercentHeight());
        }
        return result;
    }

    public Map<PropertyName, Object> getChangeMapNext() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        RowConstraints ccNext = (RowConstraints)this.gridPane.getRowConstraints().get(this.rowIndex + 1);
        if (!MathUtils.equals(ccNext.getMinHeight(), this.originalSizingNext.getMinHeight())) {
            result.put(minHeightName, ccNext.getMinHeight());
        }
        if (!MathUtils.equals(ccNext.getPrefHeight(), this.originalSizingNext.getPrefHeight())) {
            result.put(prefHeightName, ccNext.getPrefHeight());
        }
        if (!MathUtils.equals(ccNext.getMaxHeight(), this.originalSizingNext.getMaxHeight())) {
            result.put(maxHeightName, ccNext.getMaxHeight());
        }
        if (!MathUtils.equals(ccNext.getPercentHeight(), this.originalSizingNext.getPercentHeight())) {
            result.put(percentHeightName, ccNext.getPercentHeight());
        }
        return result;
    }

    private int countPercentWidths() {
        int result = 0;
        for (RowConstraints cc : this.gridPane.getRowConstraints()) {
            if (cc.getPercentHeight() == -1.0) continue;
            ++result;
        }
        return result;
    }

    private static class RowSizing {
        private final double minHeight;
        private final double maxHeight;
        private final double prefHeight;
        private final double percentHeight;

        public RowSizing(RowConstraints cc) {
            this.minHeight = cc.getMinHeight();
            this.maxHeight = cc.getMaxHeight();
            this.prefHeight = cc.getPrefHeight();
            this.percentHeight = cc.getPercentHeight();
        }

        public double getMinHeight() {
            return this.minHeight;
        }

        public double getMaxHeight() {
            return this.maxHeight;
        }

        public double getPrefHeight() {
            return this.prefHeight;
        }

        public double getPercentHeight() {
            return this.percentHeight;
        }

        public void applyTo(RowConstraints cc) {
            cc.setMinHeight(this.minHeight);
            cc.setMaxHeight(this.maxHeight);
            cc.setPrefHeight(this.prefHeight);
            cc.setPercentHeight(this.percentHeight);
        }
    }
}

