/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationArtifactType;

public class JavaFxModuleUtil {
    public static boolean isInJavaFxProject(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "isInJavaFxProject"));
        }
        Project project = file.getProject();
        if (JavaFxModuleUtil.hasJavaFxArtifacts(project)) {
            return true;
        }
        return JavaFxModuleUtil.isInJavaFxModule(file);
    }

    private static boolean isInJavaFxModule(@NotNull PsiFile file) {
        Project project;
        Module fileModule;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "isInJavaFxModule"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)(project = file.getProject()))) != null) {
            return JavaFxModuleUtil.getCachedJavaFxModules(project).contains(fileModule);
        }
        return false;
    }

    @NotNull
    private static Set<Module> getCachedJavaFxModules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "getCachedJavaFxModules"));
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "lambda$getCachedJavaFxModules$1"));
            }
            Collection files = FileTypeIndex.getFiles((FileType)JavaFxFileTypeFactory.getFileType(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            Set modules = (Set)files.stream().filter(JavaFxFileTypeFactory::isFxml).map(file -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "lambda$null$0"));
                }
                return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            }).collect(Collectors.toCollection(THashSet::new));
            return CachedValueProvider.Result.create((Object)modules, (Object[])new Object[]{FxmlPresenceListener.getModificationTracker(project)});
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "getCachedJavaFxModules"));
        }
        return set;
    }

    private static boolean hasJavaFxArtifacts(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "hasJavaFxArtifacts"));
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil", "lambda$hasJavaFxArtifacts$2"));
            }
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
            Collection artifacts = artifactManager.getArtifactsByType((ArtifactType)JavaFxApplicationArtifactType.getInstance());
            return CachedValueProvider.Result.create((Object)(!artifacts.isEmpty() ? 1 : 0), (Object[])new Object[]{artifactManager.getModificationTracker()});
        });
    }

    private static class FxmlPresenceListener
    extends VirtualFileAdapter {
        private static final Key<ModificationTracker> KEY = Key.create((String)"fxml.presence.modification.tracker");
        private final SimpleModificationTracker myModificationTracker;

        public FxmlPresenceListener(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "<init>"));
            }
            this.myModificationTracker = new SimpleModificationTracker();
            project.putUserData(KEY, (Object)this.myModificationTracker);
        }

        private static ModificationTracker getModificationTracker(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "getModificationTracker"));
            }
            return (ModificationTracker)project.getUserData(KEY);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "fileCreated"));
            }
            this.checkEvent(event);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "fileDeleted"));
            }
            this.checkEvent(event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "fileMoved"));
            }
            this.checkEvent((VirtualFileEvent)event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "fileCopied"));
            }
            this.checkEvent((VirtualFileEvent)event);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName())) {
                String oldName = (String)event.getOldValue();
                String newName = (String)event.getNewValue();
                if (oldName != null && newName != null && oldName.endsWith(".fxml") != newName.endsWith(".fxml")) {
                    this.myModificationTracker.incModificationCount();
                }
            }
        }

        private void checkEvent(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$FxmlPresenceListener", "checkEvent"));
            }
            if (JavaFxFileTypeFactory.isFxml(event.getFile())) {
                this.myModificationTracker.incModificationCount();
            }
        }
    }

    public static class JavaFxDetectionStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$JavaFxDetectionStartupActivity", "runActivity"));
            }
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new FxmlPresenceListener(project), (Disposable)project);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$JavaFxDetectionStartupActivity", "lambda$runActivity$2"));
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$JavaFxDetectionStartupActivity", "lambda$null$1"));
                    }
                    DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$JavaFxDetectionStartupActivity", "lambda$null$0"));
                        }
                        JavaFxDetectionStartupActivity.populateCachedJavaFxModules(project);
                    });
                });
            });
        }

        private static void populateCachedJavaFxModules(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil$JavaFxDetectionStartupActivity", "populateCachedJavaFxModules"));
            }
            if (!project.isDisposed() && project.isOpen()) {
                JavaFxModuleUtil.hasJavaFxArtifacts(project);
                JavaFxModuleUtil.getCachedJavaFxModules(project);
            }
        }
    }
}

