/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata;

import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.CustomComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BooleanPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.StringPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.ColorPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.PaintPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import javafx.fxml.FXMLLoader;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

class MetadataIntrospector {
    private final Class<?> componentClass;
    private final ComponentClassMetadata ancestorMetadata;
    private int counter;

    public MetadataIntrospector(Class<?> componentClass, ComponentClassMetadata ancestorMetadata) {
        this.componentClass = componentClass;
        this.ancestorMetadata = ancestorMetadata;
    }

    public ComponentClassMetadata introspect() {
        Exception exception;
        HashSet<PropertyMetadata> properties = new HashSet<PropertyMetadata>();
        Set<PropertyName> hiddenProperties = Metadata.getMetadata().getHiddenProperties();
        try {
            Object sample = this.instantiate();
            BeanInfo beanInfo = Introspector.getBeanInfo(this.componentClass);
            for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
                PropertyName name = new PropertyName(d.getName());
                PropertyMetadata propertyMetadata = this.lookupPropertyMetadata(this.ancestorMetadata, name);
                if (propertyMetadata != null || hiddenProperties.contains(name) || (propertyMetadata = this.makePropertyMetadata(name, d, sample)) == null) continue;
                properties.add(propertyMetadata);
            }
            exception = null;
        }
        catch (IntrospectionException | IOException x) {
            exception = x;
        }
        CustomComponentClassMetadata result = new CustomComponentClassMetadata(this.componentClass, this.ancestorMetadata, exception);
        result.getProperties().addAll(properties);
        return result;
    }

    private Object instantiate() throws IOException {
        Object result;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<?import ");
        sb.append(this.componentClass.getCanonicalName());
        sb.append("?>");
        sb.append("<");
        sb.append(this.componentClass.getSimpleName());
        sb.append("/>\n");
        FXMLLoader fxmlLoader = new FXMLLoader();
        String fxmlText = sb.toString();
        byte[] fxmlBytes = fxmlText.getBytes(Charset.forName("UTF-8"));
        try {
            fxmlLoader.setClassLoader(this.componentClass.getClassLoader());
            result = fxmlLoader.load((InputStream)new ByteArrayInputStream(fxmlBytes));
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
        return result;
    }

    private PropertyMetadata lookupPropertyMetadata(ComponentClassMetadata ccm, PropertyName propertyName) {
        PropertyMetadata result = null;
        while (ccm != null && result == null) {
            result = ccm.lookupProperty(propertyName);
            ccm = ccm.getParentMetadata();
        }
        return result;
    }

    private PropertyMetadata makePropertyMetadata(PropertyName name, PropertyDescriptor d, Object sample) {
        ValuePropertyMetadata result;
        if (d.getPropertyType() == null) {
            result = null;
        } else if (d.getReadMethod() == null) {
            result = null;
        } else {
            Class<?> propertyType = this.canonizeClass(d.getPropertyType());
            boolean readWrite = d.getWriteMethod() != null;
            InspectorPath inspectorPath = new InspectorPath("Properties", "Custom", this.counter++);
            if (propertyType.isArray()) {
                result = null;
            } else if (propertyType.isEnum()) {
                Object fallback = propertyType.getEnumConstants()[0];
                result = new EnumerationPropertyMetadata(name, propertyType, readWrite, (Enum)this.getDefaultValue(sample, d.getReadMethod(), fallback), inspectorPath);
            } else {
                result = propertyType == Boolean.class ? new BooleanPropertyMetadata(name, readWrite, (Boolean)this.getDefaultValue(sample, d.getReadMethod(), false), inspectorPath) : (propertyType == Integer.class ? new IntegerPropertyMetadata(name, readWrite, (Integer)this.getDefaultValue(sample, d.getReadMethod(), 0), inspectorPath) : (propertyType == Double.class ? new DoublePropertyMetadata(name, DoublePropertyMetadata.DoubleKind.COORDINATE, readWrite, (Double)this.getDefaultValue(sample, d.getReadMethod(), 0.0), inspectorPath) : (propertyType == String.class ? new StringPropertyMetadata(name, readWrite, (String)this.getDefaultValue(sample, d.getReadMethod(), null), inspectorPath) : (propertyType == Color.class ? new ColorPropertyMetadata(name, readWrite, (Color)this.getDefaultValue(sample, d.getReadMethod(), null), inspectorPath) : (propertyType == Paint.class ? new PaintPropertyMetadata(name, readWrite, (Paint)this.getDefaultValue(sample, d.getReadMethod(), null), inspectorPath) : null)))));
            }
        }
        return result;
    }

    private Class<?> canonizeClass(Class<?> c) {
        Class result = c.equals(Boolean.TYPE) ? Boolean.class : (c.equals(Double.TYPE) ? Double.class : (c.equals(Integer.TYPE) ? Integer.class : c));
        return result;
    }

    private Object getDefaultValue(Object sample, Method readMethod, Object fallback) {
        Object result;
        try {
            result = readMethod.invoke(sample, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException x) {
            result = fallback;
        }
        return result;
    }
}

