/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.java.JpsJavaDependenciesRootsEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtilsKt;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.modules.ModulesUtilKt;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u001d\u001a\u00020\fR\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator;", "", "()V", "getRelatedProductionModule", "Lkotlin/Function1;", "Lorg/jetbrains/jps/model/module/JpsModule;", "getGetRelatedProductionModule$jps_plugin", "()Lkotlin/jvm/functions/Function1;", "findClassPathRoots", "", "Ljava/io/File;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "findModularJdkRoot", "findSourceRoots", "", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "generateModuleDescription", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "sourceFiles", "Lcom/intellij/util/containers/MultiMap;", "hasRemovedFiles", "", "getAdditionalOutputDirsWhereInternalsAreVisible", "getOutputDirSafe", "getProductionModulesWhichInternalsAreVisible", "from", "jps-plugin"})
public final class KotlinBuilderModuleScriptGenerator {
    @NotNull
    private static final Function1<JpsModule, JpsModule> getRelatedProductionModule;
    public static final KotlinBuilderModuleScriptGenerator INSTANCE;

    @NotNull
    public final Function1<JpsModule, JpsModule> getGetRelatedProductionModule$jps_plugin() {
        return getRelatedProductionModule;
    }

    @Nullable
    public final File generateModuleDescription(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull MultiMap<ModuleBuildTarget, File> sourceFiles, boolean hasRemovedFiles) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        boolean noSources = true;
        HashSet<File> outputDirs = new HashSet<File>();
        Iterator iterator2 = chunk.getTargets().iterator();
        while (iterator2.hasNext()) {
            ModuleBuildTarget target;
            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            outputDirs.add(this.getOutputDirSafe(moduleBuildTarget));
        }
        BuildLoggingManager buildLoggingManager = context.getLoggingManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildLoggingManager, (String)"context.loggingManager");
        ProjectBuilderLogger logger = buildLoggingManager.getProjectBuilderLogger();
        Iterator iterator3 = chunk.getTargets().iterator();
        while (iterator3.hasNext()) {
            Collection collection;
            ModuleBuildTarget target;
            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            File outputDir2 = this.getOutputDirSafe(moduleBuildTarget);
            List<File> friendDirs = this.getAdditionalOutputDirsWhereInternalsAreVisible(target);
            if (IncrementalCompilation.isEnabled()) {
                Collection collection2 = sourceFiles.get((Object)target);
                collection = collection2;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"sourceFiles.get(target)");
            } else {
                List<File> list = KotlinSourceFileCollector.getAllKotlinSourceFiles(target);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"KotlinSourceFileCollecto\u2026KotlinSourceFiles(target)");
                collection = list;
            }
            ArrayList moduleSources = new ArrayList(collection);
            if (moduleSources.size() > 0 || hasRemovedFiles) {
                noSources = false;
                ProjectBuilderLogger projectBuilderLogger = logger;
                Intrinsics.checkExpressionValueIsNotNull((Object)projectBuilderLogger, (String)"logger");
                if (projectBuilderLogger.isEnabled()) {
                    logger.logCompiledFiles((Collection)moduleSources, KotlinBuilder.KOTLIN_BUILDER_NAME, "Compiling files:");
                }
            }
            BuildTargetType targetType = target.getTargetType();
            boolean bl = targetType instanceof JavaModuleBuildTargetType;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            TargetId targetId = ModulesUtilKt.TargetId(target);
            String string = targetId.getName();
            String string2 = outputDir2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputDir.absolutePath");
            BuildTargetType buildTargetType = targetType;
            if (buildTargetType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.jps.builders.java.JavaModuleBuildTargetType");
            }
            builder.addModule(string, string2, moduleSources, (Iterable<JvmSourceRoot>)this.findSourceRoots(context, target), (Iterable<? extends File>)this.findClassPathRoots(target), this.findModularJdkRoot(target), targetId.getType(), ((JavaModuleBuildTargetType)buildTargetType).isTests(), (Set<? extends File>)outputDirs, (Iterable<? extends File>)friendDirs);
        }
        if (noSources) {
            return null;
        }
        File scriptFile = File.createTempFile("kjps", StringUtil.sanitizeJavaIdentifier((String)chunk.getName()) + ".script.xml");
        FileUtil.writeToFile((File)scriptFile, (String)((Object)builder.asText()).toString());
        return scriptFile;
    }

    @NotNull
    public final File getOutputDirSafe(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = target.getOutputDir();
        if (file == null) {
            throw (Throwable)new ProjectBuildException("No output directory found for " + target);
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JpsModule> getProductionModulesWhichInternalsAreVisible(@NotNull ModuleBuildTarget from) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        if (!from.isTests()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        SmartList result = new SmartList((Object)from.getModule());
        Collection collection = (Collection)result;
        JpsModule jpsModule = from.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"from.module");
        CollectionsKt.addIfNotNull(collection, getRelatedProductionModule.invoke((Object)jpsModule));
        Iterable iterable = $receiver$iv = (Iterable)result;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JpsModule it;
            JpsModule jpsModule2 = it = (JpsModule)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule2, (String)"it");
            if (!JpsJsModuleUtilsKt.getHasProductionSourceRoot(jpsModule2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getAdditionalOutputDirsWhereInternalsAreVisible(@NotNull ModuleBuildTarget target) {
        void var3_3;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Iterable iterable = this.getProductionModulesWhichInternalsAreVisible(target);
        Collection destination$iv = (Collection)new SmartList();
        void $receiver$iv$iv = $receiver$iv;
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            File file;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            JpsModule it = (JpsModule)element$iv;
            if (JpsJavaExtensionService.getInstance().getOutputDirectory(it, false) == null) continue;
            File it$iv = file;
            destination$iv.add(it$iv);
        }
        return (List)var3_3;
    }

    /*
     * Unable to fully structure code
     */
    private final Collection<File> findClassPathRoots(ModuleBuildTarget target) {
        v0 = JpsUtils.getAllDependencies(target).classes();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"getAllDependencies(target).classes()");
        v1 = v0.getRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"getAllDependencies(target).classes().roots");
        var3_3 = $receiver$iv = (Iterable)v1;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            file = (File)element$iv$iv;
            if (file.exists()) ** GOTO lbl-1000
            v2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"file");
            extension = FilesKt.getExtension((File)v2);
            if (!Intrinsics.areEqual((Object)extension, (Object)"class") && !Intrinsics.areEqual((Object)extension, (Object)"jar")) {
                v3 = false;
            } else lbl-1000:
            // 2 sources

            {
                v3 = true;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final File findModularJdkRoot(ModuleBuildTarget target) {
        Object v3;
        block2: {
            Collection urls2;
            JpsJavaDependenciesRootsEnumerator jpsJavaDependenciesRootsEnumerator = JpsJavaExtensionService.dependencies((JpsModule)target.getModule()).satisfying((Condition)findModularJdkRoot.urls.1.INSTANCE).classes();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesRootsEnumerator, (String)"JpsJavaExtensionService.\u2026               .classes()");
            Collection collection = urls2 = jpsJavaDependenciesRootsEnumerator.getUrls();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"urls");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                String it;
                String string = it = (String)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                if (!StringsKt.startsWith$default((String)string, (String)"jrt://", (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        String string = v3;
        if (string == null) {
            return null;
        }
        String url = string;
        return new File(StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)url, (String)"jrt://", null, (int)2, null), (String)"!/", null, (int)2, null));
    }

    private final List<JvmSourceRoot> findSourceRoots(CompileContext context, ModuleBuildTarget target) {
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"context.projectDescriptor");
        List roots = projectDescriptor.getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        ArrayList result = ContainerUtil.newArrayList();
        Iterator iterator2 = roots.iterator();
        while (iterator2.hasNext()) {
            JavaSourceRootDescriptor root;
            JavaSourceRootDescriptor javaSourceRootDescriptor = root = (JavaSourceRootDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootDescriptor, (String)"root");
            File file = javaSourceRootDescriptor.getRootFile();
            String prefix = root.getPackagePrefix();
            if (!file.exists()) continue;
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            String string = prefix;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prefix");
            CharSequence charSequence = string;
            result.add(new JvmSourceRoot(file2, charSequence.length() == 0 ? null : prefix));
        }
        ArrayList arrayList = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"result");
        return arrayList;
    }

    private KotlinBuilderModuleScriptGenerator() {
    }

    static {
        Function1 function1;
        block4: {
            Method getProductionModuleMethod;
            Method getTestModulePropertiesMethod;
            Class<?> clazz;
            KotlinBuilderModuleScriptGenerator kotlinBuilderModuleScriptGenerator;
            KotlinBuilderModuleScriptGenerator kotlinBuilderModuleScriptGenerator2;
            INSTANCE = kotlinBuilderModuleScriptGenerator2 = new KotlinBuilderModuleScriptGenerator();
            KotlinBuilderModuleScriptGenerator $receiver = kotlinBuilderModuleScriptGenerator = kotlinBuilderModuleScriptGenerator2;
            try {
                clazz = Class.forName("org.jetbrains.jps.model.module.JpsTestModuleProperties");
            }
            catch (ClassNotFoundException e) {
                function1 = FunctionsKt.alwaysNull();
                break block4;
            }
            Class<?> klass = clazz;
            try {
                Method method = JpsJavaExtensionService.class.getDeclaredMethod("getTestModuleProperties", JpsModule.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"JpsJavaExtensionService:\u2026\", JpsModule::class.java)");
                getTestModulePropertiesMethod = method;
                Method method2 = klass.getDeclaredMethod("getProductionModule", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"klass.getDeclaredMethod(\"getProductionModule\")");
                getProductionModuleMethod = method2;
            }
            catch (NoSuchMethodException e) {
                function1 = FunctionsKt.alwaysNull();
                break block4;
            }
            function1 = (Function1)new Function1<JpsModule, JpsModule>(getTestModulePropertiesMethod, getProductionModuleMethod){
                final /* synthetic */ Method $getTestModulePropertiesMethod;
                final /* synthetic */ Method $getProductionModuleMethod;

                @Nullable
                public final JpsModule invoke(@NotNull JpsModule module) {
                    JpsModule jpsModule;
                    Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                    Object object = this.$getTestModulePropertiesMethod.invoke((Object)JpsJavaExtensionService.getInstance(), module);
                    if (object != null) {
                        Object object2;
                        Object it = object2 = object;
                        jpsModule = (JpsModule)this.$getProductionModuleMethod.invoke(it, new Object[0]);
                    } else {
                        jpsModule = null;
                    }
                    return jpsModule;
                }
                {
                    this.$getTestModulePropertiesMethod = method;
                    this.$getProductionModuleMethod = method2;
                    super(1);
                }
            };
        }
        getRelatedProductionModule = function1;
    }
}

