/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.KotlinModuleTypeManager;

public class KotlinPluginUtil {
    public static final PluginId KOTLIN_PLUGIN_ID = PluginId.getId((String)"org.jetbrains.kotlin");

    @NotNull
    public static String getPluginVersion() {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)KOTLIN_PLUGIN_ID);
        assert (plugin != null) : "Kotlin plugin not found: " + Arrays.toString(PluginManagerCore.getPlugins());
        return plugin.getVersion();
    }

    public static boolean isSnapshotVersion() {
        return "@snapshot@".equals(KotlinPluginUtil.getPluginVersion());
    }

    public static boolean isAndroidGradleModule(@NotNull Module module) {
        return KotlinModuleTypeManager.getInstance().isAndroidGradleModule(module);
    }

    public static boolean isGradleModule(@NotNull Module module) {
        return KotlinModuleTypeManager.getInstance().isGradleModule(module);
    }

    public static boolean isMavenModule(@NotNull Module module) {
        return "true".equals(module.getOptionValue("org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule"));
    }
}

