/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WrapUnaryOperatorInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "numberTypes", "", "Lorg/jetbrains/kotlin/KtNodeType;", "kotlin.jvm.PlatformType", "getNumberTypes", "()Ljava/util/List;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "WrapUnaryOperatorQuickfix", "idea"})
public final class WrapUnaryOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    private final List<KtNodeType> numberTypes = CollectionsKt.listOf((Object[])new KtNodeType[]{KtNodeTypes.INTEGER_CONSTANT, KtNodeTypes.FLOAT_CONSTANT});

    @NotNull
    public final List<KtNodeType> getNumberTypes() {
        return this.numberTypes;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ WrapUnaryOperatorInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitPrefixExpression(@NotNull KtPrefixExpression expression2) {
                KtExpression receiverExpression;
                KtExpression baseExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitPrefixExpression(expression2);
                IElementType iElementType = expression2.getOperationToken();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.operationToken");
                if (this.isUnaryMinusOrPlus(iElementType) && (baseExpression = expression2.getBaseExpression()) instanceof KtDotQualifiedExpression && (receiverExpression = ((KtDotQualifiedExpression)baseExpression).getReceiverExpression()) instanceof KtConstantExpression) {
                    Iterable iterable = this.this$0.getNumberTypes();
                    ASTNode aSTNode = ((KtConstantExpression)receiverExpression).getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"receiverExpression.node");
                    if (CollectionsKt.contains((Iterable)iterable, (Object)aSTNode.getElementType())) {
                        this.$holder.registerProblem((PsiElement)expression2, "Wrap unary operator and value with ()", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new WrapUnaryOperatorQuickfix()});
                    }
                }
            }

            private final boolean isUnaryMinusOrPlus(@NotNull IElementType $receiver) {
                return Intrinsics.areEqual((Object)$receiver, (Object)((Object)KtTokens.MINUS)) || Intrinsics.areEqual((Object)$receiver, (Object)((Object)KtTokens.PLUS));
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WrapUnaryOperatorInspection$WrapUnaryOperatorQuickfix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class WrapUnaryOperatorQuickfix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Wrap unary operator and value with ()";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtPrefixExpression)) {
                psiElement2 = null;
            }
            KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)psiElement2;
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression expression2 = ktPrefixExpression;
            KtExpression ktExpression = expression2.getBaseExpression();
            if (!(ktExpression instanceof KtDotQualifiedExpression)) {
                ktExpression = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression dotQualifiedExpression = ktDotQualifiedExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            Object[] objectArray = new Object[2];
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
            String string = ktSimpleNameExpression.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.operationReference.text");
            objectArray[0] = string;
            objectArray[1] = UtilsKt.getLeftMostReceiverExpression(dotQualifiedExpression);
            KtExpression newReceiver = CreateByPatternKt.createExpressionByPattern$default(factory2, "($0$1)", objectArray, false, 4, null);
            KtExpression newExpression2 = UtilsKt.replaceFirstReceiver$default(dotQualifiedExpression, factory2, newReceiver, false, 4, null);
            expression2.replace((PsiElement)newExpression2);
        }
    }
}

