/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.modules;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleHighlightUtil2 {
    private static final Attributes.Name MULTI_RELEASE = new Attributes.Name("Multi-Release");

    @Nullable
    static PsiJavaModule getModuleDescriptor(@NotNull VirtualFile file2, @NotNull Project project) {
        ProjectFileIndex index2 = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (index2.isInLibrary(file2)) {
            VirtualFile root = index2.getClassRootForFile(file2);
            if (root != null) {
                VirtualFile alt;
                VirtualFile descriptorFile = root.findChild("module-info.class");
                if (descriptorFile == null && (alt = root.findFileByRelativePath("META-INF/versions/9/module-info.class")) != null && ModuleHighlightUtil2.isMultiReleaseJar(root)) {
                    descriptorFile = alt;
                }
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (root.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(root.getExtension())) {
                    return LightJavaModule.getModule((PsiManager)PsiManager.getInstance((Project)project), (VirtualFile)root);
                }
            } else {
                PsiFile psiFile;
                VirtualFile descriptorFile;
                root = index2.getSourceRootForFile(file2);
                if (root != null && (descriptorFile = root.findChild("module-info.java")) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile)) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        } else {
            Module module = index2.getModuleForFile(file2);
            if (module != null) {
                PsiFile psiFile;
                boolean isTest = index2.isInTestSourceContent(file2);
                List files2 = FilenameIndex.getVirtualFilesByName((Project)project, (String)"module-info.java", (GlobalSearchScope)module.getModuleScope()).stream().filter(f -> index2.isInTestSourceContent(f) == isTest).collect(Collectors.toList());
                if (files2.size() == 1 && (psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)files2.get(0))) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMultiReleaseJar(VirtualFile root) {
        if (!(root.getFileSystem() instanceof JarFileSystem)) return false;
        VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) return false;
        try (InputStream stream2 = manifest.getInputStream();){
            boolean bl = Boolean.valueOf(new Manifest(stream2).getMainAttributes().getValue(MULTI_RELEASE));
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

