/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameConflictUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J$\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J,\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\fH\u0016J9\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0004H\u0016J\u001c\u0010#\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\f\u0010&\u001a\u00020\u0004*\u00020\u0012H\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "getClassOrObject", "getQualifiedNameAfterRename", "nonJava", "isToSearchForTextOccurrences", "isToSearchInComments", "psiElement", "prepareRenaming", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "setToSearchForTextOccurrences", "enabled", "setToSearchInComments", "substituteElementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "isCompanionObjectClassReference", "idea"})
public final class RenameKotlinClassProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3 instanceof KtClassOrObject || element3 instanceof KtLightClass || element3 instanceof KtConstructor;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
    }

    public void setToSearchInComments(@NotNull PsiElement element3, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element3, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS = enabled;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.getClassOrObject(element3);
    }

    public void prepareRenaming(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames) {
        String nameWithoutExtensions;
        KtFile file2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        super.prepareRenaming(element3, newName2, allRenames);
        PsiElement psiElement2 = this.getClassOrObject(element3);
        if (!(psiElement2 instanceof KtClassOrObject)) {
            psiElement2 = null;
        }
        KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement2;
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        KtFile ktFile = file2 = classOrObject.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
        VirtualFile virtualFile2 = ktFile.getVirtualFile();
        if (virtualFile2 != null && Intrinsics.areEqual((Object)(nameWithoutExtensions = virtualFile2.getNameWithoutExtension()), (Object)classOrObject.getName())) {
            String newFileName = newName2 + "." + virtualFile2.getExtension();
            allRenames.put((PsiElement)file2, newFileName);
            RenamePsiElementProcessor.forElement((PsiElement)((PsiElement)file2)).prepareRenaming((PsiElement)file2, newFileName, allRenames);
        }
    }

    @Nullable
    public String getQualifiedNameAfterRename(@NotNull PsiElement element3, @Nullable String newName2, boolean nonJava) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!nonJava) {
            return newName2;
        }
        PsiElement psiElement2 = element3;
        if (psiElement2 instanceof KtClassOrObject) {
            object = ((KtClassOrObject)element3).getFqName();
            if (object == null || (object = ((FqName)object).asString()) == null) {
                object = ((KtClassOrObject)element3).getName();
            }
        } else if (psiElement2 instanceof PsiClass) {
            object = ((PsiClass)element3).getQualifiedName();
            if (object == null) {
                object = ((PsiClass)element3).getName();
            }
        } else {
            return null;
        }
        Object qualifiedName2 = object;
        return PsiUtilCore.getQualifiedNameAfterRename((String)qualifiedName2, (String)newName2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3 instanceof KtObjectDeclaration && ((KtObjectDeclaration)element3).isCompanion()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)super.findReferences(element3);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                if (!(!this.isCompanionObjectClassReference(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return super.findReferences(element3);
    }

    private final boolean isCompanionObjectClassReference(@NotNull PsiReference $receiver) {
        if (!($receiver instanceof KtSimpleNameReference)) {
            return false;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)((KtSimpleNameReference)$receiver).getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"element");
        BindingContext bindingContext2 = ResolutionUtils.analyze(ktSimpleNameExpression, BodyResolveMode.PARTIAL);
        return bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, ((KtSimpleNameReference)$receiver).getElement()) != null;
    }

    public void findCollisions(@NotNull PsiElement element3, @Nullable String newName2, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (newName2 == null) {
            return;
        }
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement(element3);
        if (!(psiNamedElement instanceof KtNamedDeclaration)) {
            psiNamedElement = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiNamedElement;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default(declaration2, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor descriptor2 = (ClassDescriptor)declarationDescriptor;
        SmartList collisions = new SmartList();
        RenameConflictUtilsKt.checkRedeclarations(descriptor2, newName2, collisions);
        RenameConflictUtilsKt.checkOriginalUsagesRetargeting(declaration2, newName2, result2, collisions);
        RenameConflictUtilsKt.checkNewNameUsagesRetargeting(declaration2, newName2, collisions);
        Collection collection = result2;
        CollectionsKt.addAll((Collection)collection, (Iterable)collisions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiElement getClassOrObject(PsiElement element3) {
        PsiElement psiElement2;
        PsiElement psiElement3 = element3;
        if (psiElement3 instanceof KtLightClass) {
            PsiElement psiElement4 = element3;
            if (psiElement4 instanceof KtLightClassForSourceDeclaration) {
                psiElement2 = ((KtLightClassForSourceDeclaration)element3).getKotlinOrigin();
                return psiElement2;
            } else {
                if (!(psiElement4 instanceof KtLightClassForFacade)) throw (Throwable)((Object)new AssertionError((Object)("Should not be suggested to rename element of type " + element3.getClass() + " " + element3)));
                psiElement2 = element3;
            }
            return psiElement2;
        } else if (psiElement3 instanceof KtConstructor) {
            psiElement2 = ((KtConstructor)element3).getContainingClassOrObject();
            return psiElement2;
        } else {
            PsiElement psiElement5 = element3;
            if (!(psiElement5 instanceof KtClassOrObject)) {
                psiElement5 = null;
            }
            psiElement2 = (KtClassOrObject)psiElement5;
        }
        return psiElement2;
    }

    public void renameElement(@NotNull PsiElement element3, @Nullable String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        ArrayList simpleUsages = new ArrayList(((Object[])usages2).length);
        com.intellij.util.SmartList ambiguousImportUsages = new com.intellij.util.SmartList();
        for (int i = 0; i < usages2.length; ++i) {
            Collection collection;
            UsageInfo usage = usages2[i];
            if (this.isAmbiguousImportUsage(usage)) {
                collection = (Collection)ambiguousImportUsages;
                collection.add(usage);
                continue;
            }
            collection = simpleUsages;
            collection.add(usage);
        }
        this.setAmbiguousImportUsages(element3, (List)ambiguousImportUsages);
        Object[] thisCollection$iv = $receiver$iv = (Object[])simpleUsages;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[thisCollection$iv.size()]);
        if (usageInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        super.renameElement(element3, newName2, usageInfoArray, listener2);
        $receiver$iv = usages2;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            UsageInfo it = (UsageInfo)element$iv;
            UsageInfo usageInfo = it;
            if (!(usageInfo instanceof KtResolvableCollisionUsageInfo)) {
                usageInfo = null;
            }
            KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = (KtResolvableCollisionUsageInfo)usageInfo;
            if (ktResolvableCollisionUsageInfo == null) continue;
            ktResolvableCollisionUsageInfo.apply();
        }
    }
}

