/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class KtArrayAccessReference
extends KtSimpleReference<KtArrayAccessExpression>
implements MultiRangeReference {
    private static final List<Name> NAMES = Lists.newArrayList((Object[])new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET});

    public KtArrayAccessReference(@NotNull KtArrayAccessExpression expression2) {
        super(expression2);
    }

    public TextRange getRangeInElement() {
        return ((KtArrayAccessExpression)this.getElement()).getTextRange().shiftRight(-((KtArrayAccessExpression)this.getElement()).getTextOffset());
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> getTargetDescriptors(@NotNull BindingContext context) {
        ResolvedCall<FunctionDescriptor> setFunction;
        ArrayList result2 = Lists.newArrayList();
        ResolvedCall<FunctionDescriptor> getFunction = context.get(BindingContext.INDEXED_LVALUE_GET, this.getExpression());
        if (getFunction != null) {
            result2.add(getFunction.getCandidateDescriptor());
        }
        if ((setFunction = context.get(BindingContext.INDEXED_LVALUE_SET, this.getExpression())) != null) {
            result2.add(setFunction.getCandidateDescriptor());
        }
        return result2;
    }

    public List<TextRange> getRanges() {
        ArrayList<TextRange> list2 = new ArrayList<TextRange>();
        KtContainerNode indices = ((KtArrayAccessExpression)this.getExpression()).getIndicesNode();
        TextRange textRange = indices.getNode().findChildByType((IElementType)KtTokens.LBRACKET).getTextRange();
        TextRange lBracketRange = textRange.shiftRight(-((KtArrayAccessExpression)this.getExpression()).getTextOffset());
        list2.add(lBracketRange);
        ASTNode rBracket = indices.getNode().findChildByType((IElementType)KtTokens.RBRACKET);
        if (rBracket != null) {
            textRange = rBracket.getTextRange();
            TextRange rBracketRange = textRange.shiftRight(-((KtArrayAccessExpression)this.getExpression()).getTextOffset());
            list2.add(rBracketRange);
        }
        return list2;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@Nullable String newElementName) {
        return ReferenceUtilKt.renameImplicitConventionalCall(this, newElementName);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return NAMES;
    }
}

