/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.os.Parcel;
import android.os.Parcelable;

public class TouchCalibration
implements Parcelable {
    public static final TouchCalibration IDENTITY = new TouchCalibration();
    public static final Parcelable.Creator<TouchCalibration> CREATOR = new Parcelable.Creator<TouchCalibration>(){

        @Override
        public TouchCalibration createFromParcel(Parcel in) {
            return new TouchCalibration(in);
        }

        public TouchCalibration[] newArray(int size) {
            return new TouchCalibration[size];
        }
    };
    private final float mXScale;
    private final float mXYMix;
    private final float mXOffset;
    private final float mYXMix;
    private final float mYScale;
    private final float mYOffset;

    public TouchCalibration() {
        this(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public TouchCalibration(float xScale, float xyMix, float xOffset, float yxMix, float yScale, float yOffset) {
        this.mXScale = xScale;
        this.mXYMix = xyMix;
        this.mXOffset = xOffset;
        this.mYXMix = yxMix;
        this.mYScale = yScale;
        this.mYOffset = yOffset;
    }

    public TouchCalibration(Parcel in) {
        this.mXScale = in.readFloat();
        this.mXYMix = in.readFloat();
        this.mXOffset = in.readFloat();
        this.mYXMix = in.readFloat();
        this.mYScale = in.readFloat();
        this.mYOffset = in.readFloat();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.mXScale);
        dest.writeFloat(this.mXYMix);
        dest.writeFloat(this.mXOffset);
        dest.writeFloat(this.mYXMix);
        dest.writeFloat(this.mYScale);
        dest.writeFloat(this.mYOffset);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public float[] getAffineTransform() {
        return new float[]{this.mXScale, this.mXYMix, this.mXOffset, this.mYXMix, this.mYScale, this.mYOffset};
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TouchCalibration) {
            TouchCalibration cal = (TouchCalibration)obj;
            return cal.mXScale == this.mXScale && cal.mXYMix == this.mXYMix && cal.mXOffset == this.mXOffset && cal.mYXMix == this.mYXMix && cal.mYScale == this.mYScale && cal.mYOffset == this.mYOffset;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.mXScale) ^ Float.floatToIntBits(this.mXYMix) ^ Float.floatToIntBits(this.mXOffset) ^ Float.floatToIntBits(this.mYXMix) ^ Float.floatToIntBits(this.mYScale) ^ Float.floatToIntBits(this.mYOffset);
    }

    public String toString() {
        return String.format("[%f, %f, %f, %f, %f, %f]", Float.valueOf(this.mXScale), Float.valueOf(this.mXYMix), Float.valueOf(this.mXOffset), Float.valueOf(this.mYXMix), Float.valueOf(this.mYScale), Float.valueOf(this.mYOffset));
    }
}

