/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestClassFilter;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TestNGTestPattern
extends TestNGTestObject {
    private static final Logger LOG = Logger.getInstance(TestNGTestPattern.class);

    public TestNGTestPattern(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        TestData data = this.myConfig.getPersistantData();
        Set<String> patterns = data.getPatterns();
        TestNGTestPattern.fillTestObjects(classes, patterns, this.myConfig.getPersistantData().getScope(), (ModuleBasedConfiguration)this.myConfig, this.getSearchScope());
    }

    public static void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes, Set<String> patterns, TestSearchScope testSearchScope, ModuleBasedConfiguration config, GlobalSearchScope searchScope) throws CantRunException {
        for (String string : patterns) {
            PsiClass psiClass;
            String className;
            String methodName;
            if (string.contains(",")) {
                methodName = StringUtil.getShortName((String)string, (char)',');
                className = StringUtil.getPackageName((String)string, (char)',');
            } else {
                className = string;
                methodName = null;
            }
            if ((psiClass = (PsiClass)ReadAction.compute(() -> ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)config.getProject()), (String)className.replace('/', '.'), null, (boolean)true, (GlobalSearchScope)searchScope))) == null) continue;
            Boolean hasTest = (Boolean)ReadAction.compute(() -> TestNGUtil.hasTest((PsiModifierListOwner)psiClass));
            if (hasTest.booleanValue()) {
                if (StringUtil.isEmpty((String)methodName)) {
                    TestNGTestPattern.calculateDependencies(null, classes, searchScope, psiClass);
                    continue;
                }
                TestNGTestPattern.collectTestMethods(classes, psiClass, methodName, searchScope);
                continue;
            }
            throw new CantRunException("No tests found in class " + className);
        }
        if (classes.size() != patterns.size()) {
            final ArrayList<Pattern> compilePatterns = new ArrayList<Pattern>();
            for (String p : patterns) {
                Pattern compilePattern;
                try {
                    compilePattern = Pattern.compile(p);
                }
                catch (PatternSyntaxException e) {
                    continue;
                }
                compilePatterns.add(compilePattern);
            }
            SourceScope sourceScope = testSearchScope.getSourceScope(config);
            TestClassFilter projectFilter = new TestClassFilter(sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)config.getProject()), config.getProject(), true, true){

                @Override
                public boolean isAccepted(PsiClass psiClass) {
                    if (super.isAccepted(psiClass)) {
                        String qualifiedName = (String)ReadAction.compute(() -> ((PsiClass)psiClass).getQualifiedName());
                        LOG.assertTrue(qualifiedName != null);
                        for (Pattern pattern : compilePatterns) {
                            if (!pattern.matcher(qualifiedName).matches()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
            TestNGTestPattern.calculateDependencies(null, classes, searchScope, TestNGUtil.getAllTestClasses(projectFilter, false));
            if (classes.size() == 0) {
                throw new CantRunException("No tests found in for patterns \"" + StringUtil.join(patterns, (String)" || ") + '\"');
            }
        }
    }

    @Override
    public String getGeneratedName() {
        Set<String> patterns = this.myConfig.getPersistantData().getPatterns();
        int size = patterns.size();
        if (size == 0) {
            return "Temp suite";
        }
        return StringUtil.getShortName((String)patterns.iterator().next()) + (size > 1 ? " and " + (size - 1) + " more" : "");
    }

    @Override
    public String getActionName() {
        return this.getGeneratedName();
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        Set<String> patterns = this.myConfig.getPersistantData().getPatterns();
        if (patterns.isEmpty()) {
            throw new RuntimeConfigurationWarning("No pattern selected");
        }
    }
}

