/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.drawing;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.tools.sherpa.animation.AnimatedColor;
import com.android.tools.sherpa.animation.AnimatedConnection;
import com.android.tools.sherpa.animation.AnimatedHoverAnchor;
import com.android.tools.sherpa.animation.AnimatedLine;
import com.android.tools.sherpa.animation.AnimationSet;
import com.android.tools.sherpa.animation.Choreographer;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.ConnectionDraw;
import com.android.tools.sherpa.drawing.SnapDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.WidgetDraw;
import com.android.tools.sherpa.drawing.decorator.ColorTheme;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import com.android.tools.sherpa.interaction.MouseInteraction;
import com.android.tools.sherpa.interaction.ResizeHandle;
import com.android.tools.sherpa.interaction.SnapCandidate;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.interaction.WidgetMotion;
import com.android.tools.sherpa.interaction.WidgetResize;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetCompanion;
import com.android.tools.sherpa.structure.WidgetsScene;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class SceneDraw {
    public static final int GRID_SPACING = 8;
    public static boolean DRAW_ONLY_ROOT_BACKGROUND = true;
    public static boolean DRAW_GRID = false;
    public static final boolean DRAW_ENTIRE_TREE = false;
    private ColorSet mColorSet;
    private boolean mDrawOutsideShade = false;
    private boolean mDrawResizeHandle = false;
    private int mViewWidth;
    private int mViewHeight;
    private final WidgetsScene mWidgetsScene;
    private final Selection mSelection;
    private final WidgetMotion mWidgetMotion;
    private final WidgetResize mWidgetResize;
    private Choreographer mChoreographer = new Choreographer();
    private AnimatedHoverAnchor mAnimationCurrentAnchor = null;
    private AnimationSet mAnimationCandidateAnchors = new AnimationSet();
    private AnimationSet mAnimationCreatedConstraints = new AnimationSet();
    private AnimatedColor mCurrentAnimation = null;
    private AnimatedColor mNormalToDark;
    private AnimatedColor mDarkToNormal;
    private ConstraintAnchor mCurrentUnderneathAnchor;
    private boolean mMoveOnlyMode = false;
    private boolean mApplyConstraints = true;
    private Repaintable mRepaintableSurface;
    private int mBackgroundFactorX;
    private int mBackgroundFactorY;
    private int mBackgroundFactorColor;
    private int mBackgroundFactorSize;

    public SceneDraw(ColorSet colorSet, WidgetsScene list, Selection selection, WidgetMotion motion, WidgetResize resize) {
        this.mWidgetsScene = list;
        this.mSelection = selection;
        this.mWidgetMotion = motion;
        this.mWidgetMotion.setSceneDraw(this);
        this.mWidgetResize = resize;
        this.mAnimationCandidateAnchors.setLoop(true);
        this.mAnimationCandidateAnchors.setDuration(1000);
        this.mAnimationCreatedConstraints.setDuration(600);
        this.setColorSet(colorSet);
    }

    public void setRepaintableSurface(Repaintable repaintableSurface) {
        this.mRepaintableSurface = repaintableSurface;
    }

    public void repaint() {
        if (this.mRepaintableSurface != null) {
            this.mRepaintableSurface.repaint();
        }
    }

    public void setColorSet(ColorSet set) {
        if (this.mColorSet == set) {
            return;
        }
        this.mColorSet = set;
        this.mNormalToDark = new AnimatedColor(this.mColorSet.getBackground(), this.mColorSet.getSubduedBackground());
        this.mDarkToNormal = new AnimatedColor(this.mColorSet.getSubduedBackground(), this.mColorSet.getBackground());
    }

    public void setDrawOutsideShade(boolean drawOutsideShade) {
        this.mDrawOutsideShade = drawOutsideShade;
    }

    public void setDrawResizeHandle(boolean drawResizeHandle) {
        this.mDrawResizeHandle = drawResizeHandle;
    }

    public void onMousePress(ConstraintAnchor selectedAnchor) {
        if (selectedAnchor != null) {
            this.mCurrentAnimation = this.mNormalToDark;
            this.mCurrentAnimation.start();
        } else {
            this.mCurrentAnimation = null;
        }
        if (this.mAnimationCurrentAnchor != null) {
            this.mAnimationCurrentAnchor.setShowTooltip(false);
        }
    }

    public void mouseReleased() {
        if (this.mCurrentAnimation != null) {
            this.mCurrentAnimation = this.mDarkToNormal;
            this.mCurrentAnimation.start();
        }
        this.mAnimationCandidateAnchors.clear();
        this.mChoreographer.removeAnimation(this.mAnimationCandidateAnchors);
        for (ConstraintWidget widget : this.mWidgetsScene.getWidgets()) {
            WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetDecorator decorator = companion.getWidgetDecorator(this.getCurrentStyle());
            if (decorator.getLook() != ColorTheme.Look.HIGHLIGHTED && decorator.getLook() != ColorTheme.Look.SUBDUED) continue;
            decorator.setLook(ColorTheme.Look.NORMAL);
        }
    }

    public Choreographer getChoreographer() {
        return this.mChoreographer;
    }

    private void animateInCandidateAnchors(ConstraintAnchor selectedAnchor) {
        if (selectedAnchor == null) {
            return;
        }
        this.mAnimationCandidateAnchors.clear();
        for (ConstraintWidget widget : this.mWidgetsScene.getWidgets()) {
            boolean highlighted = false;
            for (ConstraintAnchor a : widget.getAnchors()) {
                ConstraintHandle constraintHandle;
                if (!selectedAnchor.isValidConnection(a) || !selectedAnchor.isConnectionAllowed(a.getOwner(), a) || (constraintHandle = WidgetInteractionTargets.constraintHandle(a)) == null) continue;
                this.mAnimationCandidateAnchors.add(new AnimatedLine(constraintHandle));
                highlighted = true;
            }
            WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetDecorator decorator = companion.getWidgetDecorator(this.getCurrentStyle());
            if (decorator.getLook() != ColorTheme.Look.NORMAL) continue;
            if (highlighted) {
                decorator.setLook(ColorTheme.Look.HIGHLIGHTED);
                continue;
            }
            decorator.setLook(ColorTheme.Look.SUBDUED);
        }
        this.mChoreographer.addAnimation(this.mAnimationCandidateAnchors);
    }

    public void animateConstraints(int type) {
        this.mAnimationCreatedConstraints.clear();
        for (ConstraintWidget widget : this.mWidgetsScene.getWidgets()) {
            for (ConstraintAnchor a : widget.getAnchors()) {
                if (!a.isConnected() || a.getConnectionCreator() != type) continue;
                this.mAnimationCreatedConstraints.add(new AnimatedConnection(this.mColorSet, a));
            }
        }
        this.mChoreographer.addAnimation(this.mAnimationCreatedConstraints);
    }

    public boolean drawBackground(ConstraintWidget widgetToDraw, ViewTransform transform, Graphics2D g, int w, int h) {
        boolean needsRepaint = false;
        Color backgroundColor = this.mColorSet.getBackground();
        Paint backgroundPaint = this.mColorSet.getBackgroundPaint();
        if (this.mCurrentAnimation != null) {
            if (this.mCurrentAnimation.step()) {
                needsRepaint = true;
            }
            backgroundColor = this.mCurrentAnimation.getColor();
        }
        this.mColorSet.setBackgroundPaint(backgroundColor);
        int backgroundFactorColor = backgroundColor.getRGB();
        WidgetContainer root = this.mWidgetsScene.getRoot();
        if (root == null || root != widgetToDraw) {
            return needsRepaint;
        }
        int xr = transform.getSwingX(root.getDrawX());
        int yr = transform.getSwingY(root.getDrawY());
        w = transform.getSwingDimension(root.getWidth());
        h = transform.getSwingDimension(root.getHeight());
        int tileSize = transform.getSwingDimension(8);
        if (!DRAW_GRID) {
            backgroundPaint = backgroundColor;
        } else if (this.mBackgroundFactorColor != backgroundFactorColor || this.mBackgroundFactorX != xr || this.mBackgroundFactorY != yr || this.mBackgroundFactorSize != tileSize) {
            this.mBackgroundFactorColor = backgroundFactorColor;
            this.mBackgroundFactorX = xr;
            this.mBackgroundFactorY = yr;
            this.mBackgroundFactorSize = tileSize;
            if (tileSize > 0) {
                GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = environment.getDefaultScreenDevice();
                GraphicsConfiguration config = device.getDefaultConfiguration();
                BufferedImage image = config.createCompatibleImage(tileSize, tileSize);
                Graphics2D graphics = image.createGraphics();
                graphics.setColor(backgroundColor);
                graphics.fillRect(0, 0, tileSize, tileSize);
                Color backgroundLines = ColorTheme.updateBrightness(backgroundColor, 1.06f);
                graphics.setColor(backgroundLines);
                graphics.drawLine(0, tileSize - 1, tileSize, tileSize - 1);
                graphics.drawLine(tileSize - 1, 0, tileSize - 1, tileSize);
                graphics.dispose();
                backgroundPaint = new TexturePaint(image, new Rectangle(xr + 1, yr + 1, tileSize, tileSize));
                this.mColorSet.setBackgroundPaint(backgroundPaint);
            }
        }
        if (DRAW_ONLY_ROOT_BACKGROUND) {
            Paint paint = g.getPaint();
            g.setPaint(backgroundPaint);
            g.fillRect(xr, yr, w, h);
            g.setPaint(paint);
        } else {
            g.fillRect((int)transform.getTranslateX(), (int)transform.getTranslateY(), w, h);
            g.setColor(backgroundColor);
            g.fillRect(xr, yr, w, h);
            int wr = transform.getSwingDimension(root.getDrawWidth());
            int hr = transform.getSwingDimension(root.getDrawHeight());
            g.setPaint(backgroundPaint);
            g.fillRect((int)transform.getTranslateX(), (int)transform.getTranslateY(), wr, hr);
        }
        return needsRepaint;
    }

    private WidgetDecorator getDecorator(ConstraintWidget widget, ConstraintWidget selectedWidget, ConstraintAnchor selectedAnchor, ResizeHandle selectedResizeHandle) {
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        WidgetDecorator decorator = companion.getWidgetDecorator(this.getCurrentStyle());
        if (!decorator.isSelected()) {
            decorator.updateShowAnchorsPolicy(selectedWidget, selectedAnchor);
        } else {
            decorator.setShowResizeHandles(this.mWidgetMotion.needToShowDecorations());
            decorator.setShowSizeIndicator(selectedResizeHandle != null);
        }
        if (this.mMoveOnlyMode) {
            decorator.setShowResizeHandles(false);
        }
        return decorator;
    }

    private boolean paintWidgets(ViewTransform transform, Graphics2D g, ConstraintWidget rootDrawComponent, WidgetContainer container, ConstraintWidget selectedWidget, ConstraintAnchor selectedAnchor, ResizeHandle selectedResizeHandle) {
        if (container.getVisibility() == 8) {
            return false;
        }
        boolean needsRepaint = false;
        WidgetDecorator decorator = this.getDecorator((ConstraintWidget)container, selectedWidget, selectedAnchor, selectedResizeHandle);
        decorator.setRepaintableSurface(this.mRepaintableSurface);
        if (!decorator.isVisible()) {
            return needsRepaint;
        }
        if (container == rootDrawComponent || container.getParent() == rootDrawComponent) {
            needsRepaint |= decorator.onPaint(transform, g);
            if (container == rootDrawComponent) {
                int xr = transform.getSwingX(container.getDrawX());
                int yr = transform.getSwingY(container.getDrawY());
                int wr = transform.getSwingDimension(container.getDrawWidth());
                int hr = transform.getSwingDimension(container.getDrawHeight());
                if (this.mDrawOutsideShade && this.mColorSet.drawBackground()) {
                    g.setColor(this.mColorSet.getSubduedBackground());
                    g.fillRect((int)transform.getTranslateX(), (int)transform.getTranslateY(), this.mViewWidth, yr);
                    g.fillRect((int)transform.getTranslateX(), yr + hr, this.mViewWidth, this.mViewHeight - yr - hr);
                    g.fillRect((int)transform.getTranslateX(), yr, xr, hr);
                    g.fillRect(wr + xr, yr, this.mViewWidth - xr - wr, hr);
                    g.setStroke(SnapDraw.sLongDashedStroke);
                    g.setColor(this.mColorSet.getHighlightedFrames());
                    g.drawRect(xr, yr, wr, hr);
                }
                if (this.mDrawResizeHandle) {
                    g.setColor(this.mColorSet.getHighlightedFrames());
                    int resizeHandleSize = 10;
                    int gap = 8;
                    g.setStroke(new BasicStroke(3.0f));
                    g.drawLine(xr + wr - resizeHandleSize, yr + hr + gap, xr + wr + gap, yr + hr + gap);
                    g.drawLine(xr + wr + gap, yr + hr - resizeHandleSize, xr + wr + gap, yr + hr + gap);
                    g.setStroke(new BasicStroke(1.0f));
                }
            }
        }
        container.updateDrawPosition();
        for (ConstraintWidget widget : container.getChildren()) {
            if (widget.getVisibility() == 8) continue;
            if (widget instanceof WidgetContainer) {
                needsRepaint |= this.paintWidgets(transform, g, rootDrawComponent, (WidgetContainer)widget, selectedWidget, selectedAnchor, selectedResizeHandle);
                continue;
            }
            WidgetDecorator widgetDecorator = this.getDecorator(widget, selectedWidget, selectedAnchor, selectedResizeHandle);
            if (widget != rootDrawComponent && widget.getParent() != rootDrawComponent) continue;
            needsRepaint |= widgetDecorator.onPaint(transform, g);
            widgetDecorator.setRepaintableSurface(this.mRepaintableSurface);
        }
        if (needsRepaint) {
            this.repaint();
        }
        return needsRepaint;
    }

    public static float getAnchorSize(float scale) {
        float size = 7.0f;
        if (scale < 2.0f) {
            size = 6.0f;
            if (scale < 1.8f) {
                size = 5.0f;
            }
            if (scale < 1.4f) {
                size = 4.0f;
            }
        }
        return size;
    }

    public boolean paintWidgets(ConstraintWidget rootDrawComponent, int width, int height, ViewTransform transform, Graphics2D g, boolean showAllConstraints, MouseInteraction mouseInteraction) {
        WidgetDecorator decorator;
        WidgetCompanion widgetCompanion;
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        WidgetContainer root = this.mWidgetsScene.getRoot();
        if (root == null) {
            return false;
        }
        this.mViewWidth = width;
        this.mViewHeight = height;
        if (this.mApplyConstraints) {
            root.layout();
        }
        ConnectionDraw.CONNECTION_ANCHOR_SIZE = (int)SceneDraw.getAnchorSize(transform.getScale());
        ConstraintAnchor selectedAnchor = this.mSelection.getSelectedAnchor();
        ResizeHandle selectedResizeHandle = this.mSelection.getSelectedResizeHandle();
        boolean needsRepaint = false;
        WidgetDecorator.setShowAllConstraints(showAllConstraints);
        for (ConstraintWidget constraintWidget : this.mWidgetsScene.getWidgets()) {
            widgetCompanion = (WidgetCompanion)constraintWidget.getCompanionWidget();
            decorator = widgetCompanion.getWidgetDecorator(this.getCurrentStyle());
            WidgetInteractionTargets widgetInteraction = widgetCompanion.getWidgetInteractionTargets();
            widgetInteraction.updatePosition(transform);
            decorator.setColorSet(this.mColorSet);
            if (this.mSelection.contains(constraintWidget)) {
                decorator.setIsSelected(true);
                continue;
            }
            decorator.setIsSelected(false);
        }
        this.animateInCandidateAnchors(selectedAnchor);
        for (ConstraintWidget constraintWidget : this.mWidgetsScene.getWidgets()) {
            widgetCompanion = (WidgetCompanion)constraintWidget.getCompanionWidget();
            decorator = widgetCompanion.getWidgetDecorator(this.getCurrentStyle());
            decorator.applyLook();
        }
        for (ConstraintWidget constraintWidget : this.mWidgetsScene.getWidgets()) {
            widgetCompanion = (WidgetCompanion)constraintWidget.getCompanionWidget();
            decorator = widgetCompanion.getWidgetDecorator(this.getCurrentStyle());
            if (constraintWidget.getVisibility() == 8 || constraintWidget.getParent() != null && constraintWidget.getParent().getVisibility() == 8 || constraintWidget != rootDrawComponent && constraintWidget.getParent() != rootDrawComponent || !decorator.isVisible() || decorator.isSelected() || decorator.getLook() == ColorTheme.Look.HIGHLIGHTED) continue;
            decorator.onPaintConstraints(transform, g);
        }
        ConstraintWidget selectedWidget = null;
        if (this.mSelection.hasSingleElement()) {
            selectedWidget = this.mSelection.getFirstElement().widget;
        }
        needsRepaint |= this.paintWidgets(transform, g, rootDrawComponent, this.mWidgetsScene.getRoot(), selectedWidget, selectedAnchor, selectedResizeHandle);
        for (ConstraintWidget widget : this.mWidgetsScene.getWidgets()) {
            WidgetCompanion widgetCompanion2 = (WidgetCompanion)widget.getCompanionWidget();
            WidgetDecorator decorator2 = widgetCompanion2.getWidgetDecorator(this.getCurrentStyle());
            ConstraintWidget parent = widget.getParent();
            if (widget != rootDrawComponent && parent != rootDrawComponent || !decorator2.isVisible() || !decorator2.isSelected() && decorator2.getLook() != ColorTheme.Look.HIGHLIGHTED) continue;
            decorator2.onPaintConstraints(transform, g);
            decorator2.onPaintAnchors(transform, g);
            decorator2.onPaintActions(transform, g);
        }
        g.setColor(this.mColorSet.getHighlightedSnapGuides());
        for (SnapCandidate candidate : this.mWidgetMotion.getSimilarMargins()) {
            SnapDraw.drawSnapIndicator(transform, g, candidate);
        }
        g.setColor(this.mColorSet.getSnapGuides());
        for (SnapCandidate candidate : this.mWidgetMotion.getSnapCandidates()) {
            SnapDraw.drawSnapIndicator(transform, g, candidate);
        }
        for (SnapCandidate candidate : this.mWidgetResize.getSnapCandidates()) {
            SnapDraw.drawSnapIndicator(transform, g, candidate);
        }
        if (this.mSelection.hasSingleElement() && selectedAnchor != null) {
            ConstraintAnchor constraintAnchor = this.mSelection.getConnectionCandidateAnchor();
            ConstraintHandle selectedHandle = WidgetInteractionTargets.constraintHandle(selectedAnchor);
            g.setColor(this.mColorSet.getHighlightedConstraints());
            if (!selectedHandle.getAnchor().isConnected() || selectedHandle.getAnchor().getTarget() != constraintAnchor) {
                Point lastPoint = mouseInteraction.getLastPoint();
                if (lastPoint.x != 0 && lastPoint.y != 0) {
                    selectedHandle.drawConnection(transform, g, this.mColorSet, true, mouseInteraction.getLastPoint());
                }
            }
        }
        if (selectedResizeHandle != null) {
            g.setColor(this.mColorSet.getSelectionColor());
            WidgetDraw.drawResizeHandleSelection(transform, g, selectedResizeHandle);
        }
        if (this.mSelection.isEmpty() && mouseInteraction.isMouseDown()) {
            Point point = mouseInteraction.getStartPoint();
            Point lastMousePosition = mouseInteraction.getLastPoint();
            int x1 = Math.min(point.x, lastMousePosition.x);
            int x2 = Math.max(point.x, lastMousePosition.x);
            int y1 = Math.min(point.y, lastMousePosition.y);
            int y2 = Math.max(point.y, lastMousePosition.y);
            int ax1 = transform.getSwingX(x1);
            int ax2 = transform.getSwingX(x2);
            int ay1 = transform.getSwingY(y1);
            int ay2 = transform.getSwingY(y2);
            int w = x2 - x1;
            int h = y2 - y1;
            if (w > 0 || h > 0) {
                g.setColor(this.mColorSet.getSelectionColor());
                g.setStroke(SnapDraw.sDashedStroke);
                if (w >= 8 && h >= 8) {
                    g.drawRect(ax1, ay1, ax2 - ax1, ay2 - ay1);
                } else if (w >= 8 && h < 8) {
                    g.drawLine(ax1, ay1, ax2, ay1);
                } else {
                    g.drawLine(ax1, ay1, ax1, ay2);
                }
                g.setStroke(SnapDraw.sNormalStroke);
                if (w >= 8) {
                    ConnectionDraw.drawHorizontalMarginIndicator(g, String.valueOf(w), ax1, ax2, ay1 - 20);
                }
                if (h >= 8) {
                    ConnectionDraw.drawVerticalMarginIndicator(g, String.valueOf(h), ax1 - 20, ay1, ay2);
                }
            }
        }
        if (this.mSelection.getSelectionBounds() != null) {
            Selection.Element element = this.mSelection.getSelectionBounds();
            g.setColor(this.mColorSet.getSelectionColor());
            g.setStroke(SnapDraw.sDashedStroke);
            int x = transform.getSwingX(element.widget.getDrawX());
            int y = transform.getSwingY(element.widget.getDrawY());
            int w = transform.getSwingDimension(element.widget.getDrawWidth());
            int h = transform.getSwingDimension(element.widget.getDrawHeight());
            g.drawRect(x, y, w, h);
        }
        if (!(needsRepaint |= this.mChoreographer.onPaint(transform, g)) && !this.mSelection.isEmpty()) {
            for (Selection.Element element : this.mSelection.getElements()) {
                needsRepaint |= element.widget.isAnimating();
            }
        }
        if (!needsRepaint) {
            for (ConstraintWidget widget : this.mWidgetsScene.getWidgets()) {
                needsRepaint |= widget.isAnimating();
            }
        }
        if (needsRepaint) {
            this.repaint();
        }
        return needsRepaint;
    }

    public ConstraintAnchor getCurrentUnderneathAnchor() {
        return this.mCurrentUnderneathAnchor;
    }

    public void setCurrentUnderneathAnchor(ConstraintAnchor underneathAnchor) {
        if (this.mCurrentUnderneathAnchor != underneathAnchor) {
            this.mCurrentUnderneathAnchor = underneathAnchor;
            this.mChoreographer.removeAnimation(this.mAnimationCurrentAnchor);
            if (this.mCurrentUnderneathAnchor != null) {
                ConstraintHandle constraintHandle = WidgetInteractionTargets.constraintHandle(this.mCurrentUnderneathAnchor);
                this.mAnimationCurrentAnchor = new AnimatedHoverAnchor(this.mColorSet, constraintHandle);
                this.mChoreographer.addAnimation(this.mAnimationCurrentAnchor);
            } else {
                this.mAnimationCurrentAnchor = null;
            }
        }
    }

    public void setMoveOnlyMode(boolean moveOnlyMode) {
        this.mMoveOnlyMode = moveOnlyMode;
    }

    public void setApplyConstraints(boolean applyConstraints) {
        this.mApplyConstraints = applyConstraints;
    }

    public int getCurrentStyle() {
        if (this.mColorSet == null) {
            return 0;
        }
        return this.mColorSet.getStyle();
    }

    public static interface Repaintable {
        public void repaint();

        public void repaint(int var1, int var2, int var3, int var4);
    }
}

