/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.Optimizer;
import android.support.constraint.solver.widgets.Rectangle;
import android.support.constraint.solver.widgets.Snapshot;
import android.support.constraint.solver.widgets.WidgetContainer;
import java.util.ArrayList;
import java.util.Arrays;

public class ConstraintWidgetContainer
extends WidgetContainer {
    private static final boolean USE_THREAD = false;
    private static final boolean DEBUG = false;
    private static final boolean USE_SNAPSHOT = true;
    private static final boolean USE_DIRECT_CHAIN_RESOLUTION = true;
    protected LinearSystem mSystem = new LinearSystem();
    protected LinearSystem mBackgroundSystem = null;
    private Snapshot mSnapshot;
    static boolean ALLOW_ROOT_GROUP = true;
    int mWrapWidth;
    int mWrapHeight;
    int mPaddingLeft;
    int mPaddingTop;
    int mPaddingRight;
    int mPaddingBottom;
    private int mHorizontalChainsSize = 0;
    private int mVerticalChainsSize = 0;
    private ConstraintWidget[] mMatchConstraintsChainedWidgets = new ConstraintWidget[4];
    private ConstraintWidget[] mVerticalChainsArray = new ConstraintWidget[4];
    private ConstraintWidget[] mHorizontalChainsArray = new ConstraintWidget[4];
    private boolean mDirectResolution = true;

    public ConstraintWidgetContainer() {
    }

    public ConstraintWidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public ConstraintWidgetContainer(int width, int height) {
        super(width, height);
    }

    public void setDirectResolution(boolean value) {
        this.mDirectResolution = value;
    }

    @Override
    public String getType() {
        return "ConstraintLayout";
    }

    @Override
    public void reset() {
        this.mSystem.reset();
        this.mPaddingLeft = 0;
        this.mPaddingRight = 0;
        this.mPaddingTop = 0;
        this.mPaddingBottom = 0;
        super.reset();
    }

    public static ConstraintWidgetContainer createContainer(ConstraintWidgetContainer container, String name, ArrayList<ConstraintWidget> widgets, int padding) {
        Rectangle bounds = ConstraintWidgetContainer.getBounds(widgets);
        if (bounds.width == 0 || bounds.height == 0) {
            return null;
        }
        if (padding > 0) {
            int maxPadding = Math.min(bounds.x, bounds.y);
            if (padding > maxPadding) {
                padding = maxPadding;
            }
            bounds.grow(padding, padding);
        }
        container.setOrigin(bounds.x, bounds.y);
        container.setDimension(bounds.width, bounds.height);
        container.setDebugName(name);
        ConstraintWidget parent = widgets.get(0).getParent();
        int widgetsSize = widgets.size();
        for (int i = 0; i < widgetsSize; ++i) {
            ConstraintWidget widget = widgets.get(i);
            if (widget.getParent() != parent) continue;
            container.add(widget);
            widget.setX(widget.getX() - bounds.x);
            widget.setY(widget.getY() - bounds.y);
        }
        return container;
    }

    public boolean addChildrenToSolver(LinearSystem system, int group) {
        this.addToSolver(system, group);
        int count = this.mChildren.size();
        if (this.mDirectResolution && this.optimize(system)) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (widget instanceof ConstraintWidgetContainer) {
                ConstraintWidget.DimensionBehaviour horizontalBehaviour = widget.mHorizontalDimensionBehaviour;
                ConstraintWidget.DimensionBehaviour verticalBehaviour = widget.mVerticalDimensionBehaviour;
                if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                }
                if (verticalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                }
                widget.addToSolver(system, group);
                if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setHorizontalDimensionBehaviour(horizontalBehaviour);
                }
                if (verticalBehaviour != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) continue;
                widget.setVerticalDimensionBehaviour(verticalBehaviour);
                continue;
            }
            widget.addToSolver(system, group);
        }
        if (this.mHorizontalChainsSize > 0) {
            this.applyHorizontalChain(system);
        }
        if (this.mVerticalChainsSize > 0) {
            this.applyVerticalChain(system);
        }
        return true;
    }

    private boolean optimize(LinearSystem system) {
        ConstraintWidget widget;
        int i;
        int count = this.mChildren.size();
        boolean done = false;
        int dv = 0;
        int dh = 0;
        int n = 0;
        if (this.mDirectResolution) {
            for (int i2 = 0; i2 < count; ++i2) {
                ConstraintWidget widget2 = (ConstraintWidget)this.mChildren.get(i2);
                widget2.mHorizontalResolution = -1;
                widget2.mVerticalResolution = -1;
                if (widget2.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget2.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
                widget2.mHorizontalResolution = 1;
                widget2.mVerticalResolution = 1;
            }
            while (!done) {
                int prev = dv;
                int preh = dh;
                dv = 0;
                dh = 0;
                ++n;
                for (i = 0; i < count; ++i) {
                    widget = (ConstraintWidget)this.mChildren.get(i);
                    if (widget.mHorizontalResolution == -1) {
                        if (this.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                            widget.mHorizontalResolution = 1;
                        } else {
                            Optimizer.checkHorizontalSimpleDependency(this, system, widget);
                        }
                    }
                    if (widget.mVerticalResolution == -1) {
                        if (this.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                            widget.mVerticalResolution = 1;
                        } else {
                            Optimizer.checkVerticalSimpleDependency(this, system, widget);
                        }
                    }
                    if (widget.mVerticalResolution == -1) {
                        ++dv;
                    }
                    if (widget.mHorizontalResolution != -1) continue;
                    ++dh;
                }
                if (dv == 0 && dh == 0) {
                    done = true;
                    continue;
                }
                if (prev != dv || preh != dh) continue;
                done = true;
            }
        }
        int sh = 0;
        int sv = 0;
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)this.mChildren.get(i);
            if (!this.mDirectResolution) {
                widget.mHorizontalResolution = 1;
                widget.mVerticalResolution = 1;
                continue;
            }
            if (widget.mHorizontalResolution == 1 || widget.mHorizontalResolution == -1) {
                ++sh;
            }
            if (widget.mVerticalResolution != 1 && widget.mVerticalResolution != -1) continue;
            ++sv;
        }
        return this.mDirectResolution && sh == 0 && sv == 0;
    }

    private void applyHorizontalChain(LinearSystem system) {
        for (int i = 0; i < this.mHorizontalChainsSize; ++i) {
            ConstraintWidget previous;
            boolean isWrapContent;
            ConstraintWidget first = this.mHorizontalChainsArray[i];
            int numMatchConstraints = this.countMatchConstraintsChainedWidgets(this.mHorizontalChainsArray[i], 0);
            boolean chainPacked = first.mHorizontalChainStyle == 2;
            ConstraintWidget widget = first;
            boolean bl = isWrapContent = this.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (widget.mHorizontalChainFixedPosition && !chainPacked && !isWrapContent && first.mHorizontalChainStyle == 0) {
                Optimizer.applyDirectResolutionHorizontalChain(this, system, numMatchConstraints, widget);
                continue;
            }
            if (numMatchConstraints == 0 || chainPacked) {
                SolverVariable rightTarget;
                SolverVariable right;
                SolverVariable leftTarget;
                SolverVariable left;
                int rightMargin;
                int leftMargin;
                previous = null;
                while (previous == null || widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner == previous) {
                    leftMargin = widget.mLeft.getMargin();
                    rightMargin = widget.mRight.getMargin();
                    left = widget.mLeft.mSolverVariable;
                    leftTarget = widget.mLeft.mTarget != null ? widget.mLeft.mTarget.mSolverVariable : null;
                    right = widget.mRight.mSolverVariable;
                    rightTarget = widget.mRight.mTarget != null ? widget.mRight.mTarget.mSolverVariable : null;
                    int margin = leftMargin;
                    if (previous != null) {
                        margin += previous.mRight.getMargin();
                    }
                    if (leftTarget != null) {
                        if (widget == first && widget.mHorizontalChainStyle == 1 || chainPacked && widget != first) {
                            system.addEquality(left, leftTarget, margin, 3);
                        } else {
                            system.addGreaterThan(left, leftTarget, margin, 1);
                        }
                    }
                    if (rightTarget != null) {
                        margin = rightMargin;
                        ConstraintAnchor nextLeft = widget.mRight.mTarget.mOwner.mLeft;
                        ConstraintWidget nextLeftTarget = nextLeft.mTarget != null ? nextLeft.mTarget.mOwner : null;
                        boolean isLast = true;
                        if (nextLeftTarget == widget) {
                            margin += nextLeft.getMargin();
                            isLast = false;
                        }
                        if (!chainPacked) {
                            if (isLast && first.mHorizontalChainStyle == 1) {
                                system.addEquality(right, rightTarget, -margin, 3);
                            } else {
                                system.addLowerThan(right, rightTarget, -margin, 1);
                                if (leftTarget != null) {
                                    system.addCentering(left, leftTarget, leftMargin, 0.5f, rightTarget, right, rightMargin, 2);
                                }
                            }
                        }
                    }
                    if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        system.addEquality(widget.mRight.mSolverVariable, widget.mLeft.mSolverVariable, 0, 3);
                    }
                    previous = widget;
                    if (rightTarget == null) break;
                    widget = widget.mRight.mTarget.mOwner;
                }
                if (!chainPacked) continue;
                leftMargin = first.mLeft.getMargin();
                rightMargin = previous.mRight.getMargin();
                left = first.mLeft.mSolverVariable;
                leftTarget = first.mLeft.mTarget != null ? first.mLeft.mTarget.mSolverVariable : null;
                right = previous.mRight.mSolverVariable;
                SolverVariable solverVariable = rightTarget = previous.mRight.mTarget != null ? previous.mRight.mTarget.mSolverVariable : null;
                if (leftTarget == null || rightTarget == null) continue;
                system.addCentering(left, leftTarget, leftMargin, first.mHorizontalBiasPercent, rightTarget, right, rightMargin, 2);
                continue;
            }
            previous = null;
            float totalWeights = 0.0f;
            while (previous == null || widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner == previous) {
                if (widget.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    int margin = widget.mLeft.getMargin();
                    if (previous != null) {
                        margin += previous.mRight.getMargin();
                    }
                    int strength = 2;
                    if (widget.mLeft.mTarget.mOwner.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 1;
                    }
                    system.addGreaterThan(widget.mLeft.mSolverVariable, widget.mLeft.mTarget.mSolverVariable, margin, strength);
                    margin = widget.mRight.getMargin();
                    if (widget.mRight.mTarget.mOwner.mLeft.mTarget != null && widget.mRight.mTarget.mOwner.mLeft.mTarget.mOwner == widget) {
                        margin += widget.mRight.mTarget.mOwner.mLeft.getMargin();
                    }
                    strength = 2;
                    if (widget.mRight.mTarget.mOwner.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 1;
                    }
                    system.addLowerThan(widget.mRight.mSolverVariable, widget.mRight.mTarget.mSolverVariable, -margin, strength);
                } else {
                    totalWeights += widget.mHorizontalWeight;
                    system.addGreaterThan(widget.mRight.mSolverVariable, widget.mLeft.mSolverVariable, 0, 0);
                    system.addLowerThan(widget.mRight.mSolverVariable, widget.mRight.mTarget.mSolverVariable, 0, 0);
                }
                previous = widget;
                widget = widget.mRight.mTarget.mOwner;
            }
            if (numMatchConstraints == 1) {
                ConstraintWidget w = this.mMatchConstraintsChainedWidgets[0];
                int leftMargin = w.mLeft.getMargin();
                if (w.mLeft.mTarget != null) {
                    leftMargin += w.mLeft.mTarget.getMargin();
                }
                system.addEquality(w.mLeft.mSolverVariable, w.mLeft.mTarget.mSolverVariable, leftMargin, 0);
                int rightMargin = w.mRight.getMargin();
                if (w.mRight.mTarget != null) {
                    rightMargin += w.mRight.mTarget.getMargin();
                }
                system.addEquality(w.mRight.mSolverVariable, w.mRight.mTarget.mSolverVariable, -rightMargin, 0);
                continue;
            }
            for (int j = 0; j < numMatchConstraints - 1; ++j) {
                ConstraintWidget current = this.mMatchConstraintsChainedWidgets[j];
                ConstraintWidget nextWidget = this.mMatchConstraintsChainedWidgets[j + 1];
                SolverVariable left = current.mLeft.mSolverVariable;
                SolverVariable right = current.mRight.mSolverVariable;
                SolverVariable nextLeft = nextWidget.mLeft.mSolverVariable;
                SolverVariable nextRight = nextWidget.mRight.mSolverVariable;
                int margin = current.mLeft.getMargin();
                if (current.mLeft.mTarget != null && current.mLeft.mTarget.mOwner.mRight.mTarget != null && current.mLeft.mTarget.mOwner.mRight.mTarget.mOwner == current) {
                    margin += current.mLeft.mTarget.mOwner.mRight.getMargin();
                }
                system.addGreaterThan(left, current.mLeft.mTarget.mSolverVariable, margin, 1);
                margin = current.mRight.getMargin();
                if (current.mRight.mTarget != null && current.mRight.mTarget.mOwner.mLeft.mTarget != null && current.mRight.mTarget.mOwner.mLeft.mTarget.mOwner == current) {
                    margin += current.mRight.mTarget.mOwner.mLeft.getMargin();
                }
                system.addLowerThan(right, current.mRight.mTarget.mSolverVariable, -margin, 1);
                if (j + 1 == numMatchConstraints - 1) {
                    margin = nextWidget.mLeft.getMargin();
                    if (nextWidget.mLeft.mTarget != null && nextWidget.mLeft.mTarget.mOwner.mRight.mTarget != null && nextWidget.mLeft.mTarget.mOwner.mRight.mTarget.mOwner == nextWidget) {
                        margin += nextWidget.mLeft.mTarget.mOwner.mRight.getMargin();
                    }
                    system.addGreaterThan(nextLeft, nextWidget.mLeft.mTarget.mSolverVariable, margin, 1);
                    margin = nextWidget.mRight.getMargin();
                    if (nextWidget.mRight.mTarget != null && nextWidget.mRight.mTarget.mOwner.mLeft.mTarget != null && nextWidget.mRight.mTarget.mOwner.mLeft.mTarget.mOwner == nextWidget) {
                        margin += nextWidget.mRight.mTarget.mOwner.mLeft.getMargin();
                    }
                    system.addLowerThan(nextRight, nextWidget.mRight.mTarget.mSolverVariable, -margin, 1);
                }
                ArrayRow row = system.createRow();
                row.createRowEqualDimension(current.mHorizontalWeight, totalWeights, nextWidget.mHorizontalWeight, left, current.mLeft.getMargin(), right, current.mRight.getMargin(), nextLeft, nextWidget.mLeft.getMargin(), nextRight, nextWidget.mRight.getMargin());
                system.addConstraint(row);
            }
        }
    }

    private void applyVerticalChain(LinearSystem system) {
        for (int i = 0; i < this.mVerticalChainsSize; ++i) {
            ConstraintWidget previous;
            boolean isWrapContent;
            ConstraintWidget first = this.mVerticalChainsArray[i];
            int numMatchConstraints = this.countMatchConstraintsChainedWidgets(this.mVerticalChainsArray[i], 1);
            boolean chainPacked = first.mVerticalChainStyle == 2;
            ConstraintWidget widget = first;
            boolean bl = isWrapContent = this.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (widget.mVerticalChainFixedPosition && !chainPacked && !isWrapContent && first.mVerticalChainStyle == 0) {
                Optimizer.applyDirectResolutionVerticalChain(this, system, numMatchConstraints, widget);
                continue;
            }
            if (numMatchConstraints == 0 || chainPacked) {
                SolverVariable bottomTarget;
                SolverVariable bottom;
                SolverVariable topTarget;
                SolverVariable top;
                int bottomMargin;
                int topMargin;
                previous = null;
                while (previous == null || widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner == previous) {
                    topMargin = widget.mTop.getMargin();
                    bottomMargin = widget.mBottom.getMargin();
                    top = widget.mTop.mSolverVariable;
                    topTarget = widget.mTop.mTarget != null ? widget.mTop.mTarget.mSolverVariable : null;
                    bottom = widget.mBottom.mSolverVariable;
                    bottomTarget = widget.mBottom.mTarget != null ? widget.mBottom.mTarget.mSolverVariable : null;
                    int margin = topMargin;
                    if (previous != null) {
                        margin += previous.mBottom.getMargin();
                    }
                    if (topTarget != null) {
                        if (widget == first && widget.mVerticalChainStyle == 1 || chainPacked && widget != first) {
                            system.addEquality(top, topTarget, margin, 3);
                        } else {
                            system.addGreaterThan(top, topTarget, margin, 1);
                        }
                    }
                    if (bottomTarget != null) {
                        margin = bottomMargin;
                        ConstraintAnchor nextTop = widget.mBottom.mTarget.mOwner.mTop;
                        ConstraintWidget nextTopTarget = nextTop.mTarget != null ? nextTop.mTarget.mOwner : null;
                        boolean isLast = true;
                        if (nextTopTarget == widget) {
                            margin += nextTop.getMargin();
                            isLast = false;
                        }
                        if (!chainPacked) {
                            if (isLast && first.mVerticalChainStyle == 1) {
                                system.addEquality(bottom, bottomTarget, -margin, 3);
                            } else {
                                system.addLowerThan(bottom, bottomTarget, -margin, 1);
                                if (topTarget != null) {
                                    system.addCentering(top, topTarget, topMargin, 0.5f, bottomTarget, bottom, bottomMargin, 2);
                                }
                            }
                        }
                    }
                    if (widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        system.addEquality(widget.mBottom.mSolverVariable, widget.mTop.mSolverVariable, 0, 3);
                    }
                    previous = widget;
                    if (bottomTarget == null) break;
                    widget = widget.mBottom.mTarget.mOwner;
                }
                if (!chainPacked) continue;
                topMargin = first.mTop.getMargin();
                bottomMargin = previous.mBottom.getMargin();
                top = first.mTop.mSolverVariable;
                topTarget = first.mTop.mTarget != null ? first.mTop.mTarget.mSolverVariable : null;
                bottom = previous.mBottom.mSolverVariable;
                SolverVariable solverVariable = bottomTarget = previous.mBottom.mTarget != null ? previous.mBottom.mTarget.mSolverVariable : null;
                if (topTarget == null || bottomTarget == null) continue;
                system.addCentering(top, topTarget, topMargin, first.mVerticalBiasPercent, bottomTarget, bottom, bottomMargin, 2);
                continue;
            }
            previous = null;
            float totalWeights = 0.0f;
            while (previous == null || widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner == previous) {
                if (widget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    int margin = widget.mTop.getMargin();
                    if (previous != null) {
                        margin += previous.mBottom.getMargin();
                    }
                    int strength = 2;
                    if (widget.mTop.mTarget.mOwner.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 1;
                    }
                    system.addGreaterThan(widget.mTop.mSolverVariable, widget.mTop.mTarget.mSolverVariable, margin, strength);
                    margin = widget.mBottom.getMargin();
                    if (widget.mBottom.mTarget.mOwner.mTop.mTarget != null && widget.mBottom.mTarget.mOwner.mTop.mTarget.mOwner == widget) {
                        margin += widget.mBottom.mTarget.mOwner.mTop.getMargin();
                    }
                    strength = 2;
                    if (widget.mBottom.mTarget.mOwner.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 1;
                    }
                    system.addLowerThan(widget.mBottom.mSolverVariable, widget.mBottom.mTarget.mSolverVariable, -margin, strength);
                } else {
                    totalWeights += widget.mVerticalWeight;
                    system.addGreaterThan(widget.mBottom.mSolverVariable, widget.mTop.mSolverVariable, 0, 0);
                    system.addLowerThan(widget.mBottom.mSolverVariable, widget.mBottom.mTarget.mSolverVariable, 0, 0);
                }
                previous = widget;
                widget = widget.mBottom.mTarget.mOwner;
            }
            if (numMatchConstraints == 1) {
                ConstraintWidget w = this.mMatchConstraintsChainedWidgets[0];
                int topMargin = w.mTop.getMargin();
                if (w.mTop.mTarget != null) {
                    topMargin += w.mTop.mTarget.getMargin();
                }
                system.addEquality(w.mTop.mSolverVariable, w.mTop.mTarget.mSolverVariable, topMargin, 0);
                int bottomMargin = w.mBottom.getMargin();
                if (w.mBottom.mTarget != null) {
                    bottomMargin += w.mBottom.mTarget.getMargin();
                }
                system.addEquality(w.mBottom.mSolverVariable, w.mBottom.mTarget.mSolverVariable, -bottomMargin, 0);
                continue;
            }
            for (int j = 0; j < numMatchConstraints - 1; ++j) {
                ConstraintWidget current = this.mMatchConstraintsChainedWidgets[j];
                ConstraintWidget nextWidget = this.mMatchConstraintsChainedWidgets[j + 1];
                SolverVariable top = current.mTop.mSolverVariable;
                SolverVariable bottom = current.mBottom.mSolverVariable;
                SolverVariable nextLeft = nextWidget.mTop.mSolverVariable;
                SolverVariable nextRight = nextWidget.mBottom.mSolverVariable;
                int margin = current.mTop.getMargin();
                if (current.mTop.mTarget != null && current.mTop.mTarget.mOwner.mBottom.mTarget != null && current.mTop.mTarget.mOwner.mBottom.mTarget.mOwner == current) {
                    margin += current.mTop.mTarget.mOwner.mBottom.getMargin();
                }
                system.addGreaterThan(top, current.mTop.mTarget.mSolverVariable, margin, 1);
                margin = current.mBottom.getMargin();
                if (current.mBottom.mTarget != null && current.mBottom.mTarget.mOwner.mTop.mTarget != null && current.mBottom.mTarget.mOwner.mTop.mTarget.mOwner == current) {
                    margin += current.mBottom.mTarget.mOwner.mTop.getMargin();
                }
                system.addLowerThan(bottom, current.mBottom.mTarget.mSolverVariable, -margin, 1);
                if (j + 1 == numMatchConstraints - 1) {
                    margin = nextWidget.mTop.getMargin();
                    if (nextWidget.mTop.mTarget != null && nextWidget.mTop.mTarget.mOwner.mBottom.mTarget != null && nextWidget.mTop.mTarget.mOwner.mBottom.mTarget.mOwner == nextWidget) {
                        margin += nextWidget.mTop.mTarget.mOwner.mBottom.getMargin();
                    }
                    system.addGreaterThan(nextLeft, nextWidget.mTop.mTarget.mSolverVariable, margin, 1);
                    margin = nextWidget.mBottom.getMargin();
                    if (nextWidget.mBottom.mTarget != null && nextWidget.mBottom.mTarget.mOwner.mTop.mTarget != null && nextWidget.mBottom.mTarget.mOwner.mTop.mTarget.mOwner == nextWidget) {
                        margin += nextWidget.mBottom.mTarget.mOwner.mTop.getMargin();
                    }
                    system.addLowerThan(nextRight, nextWidget.mBottom.mTarget.mSolverVariable, -margin, 1);
                }
                ArrayRow row = system.createRow();
                row.createRowEqualDimension(current.mVerticalWeight, totalWeights, nextWidget.mVerticalWeight, top, current.mTop.getMargin(), bottom, current.mBottom.getMargin(), nextLeft, nextWidget.mTop.getMargin(), nextRight, nextWidget.mBottom.getMargin());
                system.addConstraint(row);
            }
        }
    }

    public void updateChildrenFromSolver(LinearSystem system, int group) {
        this.updateFromSolver(system, group);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            widget.updateFromSolver(system, group);
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
    }

    @Override
    public void layout() {
        int prex = this.mX;
        int prey = this.mY;
        int prew = this.getWidth();
        int preh = this.getHeight();
        if (this.mParent != null) {
            if (this.mSnapshot == null) {
                this.mSnapshot = new Snapshot(this);
            }
            this.mSnapshot.updateFrom(this);
            this.setX(this.mPaddingLeft);
            this.setY(this.mPaddingTop);
            this.resetAnchors();
            this.resetSolverVariables(this.mSystem.getCache());
        } else {
            this.mX = 0;
            this.mY = 0;
        }
        this.resetChains();
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
        boolean needsSolving = true;
        try {
            this.mSystem.reset();
            needsSolving = this.addChildrenToSolver(this.mSystem, Integer.MAX_VALUE);
            if (needsSolving) {
                this.mSystem.minimize();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (needsSolving) {
            this.updateChildrenFromSolver(this.mSystem, Integer.MAX_VALUE);
        } else {
            this.updateFromSolver(this.mSystem, Integer.MAX_VALUE);
        }
        if (this.mParent != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.mSnapshot.applyTo(this);
            this.setWidth(width + this.mPaddingLeft + this.mPaddingRight);
            this.setHeight(height + this.mPaddingTop + this.mPaddingBottom);
        } else {
            this.mX = prex;
            this.mY = prey;
        }
        this.resetSolverVariables(this.mSystem.getCache());
        if (this == this.getRootConstraintContainer()) {
            this.updateDrawPosition();
        }
    }

    static int setGroup(ConstraintAnchor anchor, int group) {
        int oldGroup = anchor.mGroup;
        if (anchor.mOwner.getParent() == null) {
            return group;
        }
        if (oldGroup <= group) {
            return oldGroup;
        }
        anchor.mGroup = group;
        ConstraintAnchor opposite = anchor.getOpposite();
        ConstraintAnchor target = anchor.mTarget;
        group = opposite != null ? ConstraintWidgetContainer.setGroup(opposite, group) : group;
        group = target != null ? ConstraintWidgetContainer.setGroup(target, group) : group;
        anchor.mGroup = group = opposite != null ? ConstraintWidgetContainer.setGroup(opposite, group) : group;
        return group;
    }

    public int layoutFindGroupsSimple() {
        int size = this.mChildren.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            widget.mLeft.mGroup = 0;
            widget.mRight.mGroup = 0;
            widget.mTop.mGroup = 1;
            widget.mBottom.mGroup = 1;
            widget.mBaseline.mGroup = 1;
        }
        return 2;
    }

    public void findWrapRecursive(ConstraintWidget widget) {
        int h;
        int w;
        int distToRight = w = widget.getWrapWidth();
        int distToLeft = w;
        ConstraintWidget leftWidget = null;
        ConstraintWidget rightWidget = null;
        widget.mWrapVisited = true;
        if (!widget.mRight.isConnected() && !widget.mLeft.isConnected()) {
            distToLeft += widget.getX();
        } else {
            if (widget.mRight.mTarget != null) {
                rightWidget = widget.mRight.mTarget.getOwner();
                distToRight += widget.mRight.getMargin();
                if (!rightWidget.isRoot() && !rightWidget.mWrapVisited) {
                    this.findWrapRecursive(rightWidget);
                }
            }
            if (widget.mLeft.isConnected()) {
                leftWidget = widget.mLeft.mTarget.getOwner();
                distToLeft += widget.mLeft.getMargin();
                if (!leftWidget.isRoot() && !leftWidget.mWrapVisited) {
                    this.findWrapRecursive(leftWidget);
                }
            }
            if (widget.mRight.mTarget != null && !rightWidget.isRoot()) {
                if (widget.mRight.mTarget.mType == ConstraintAnchor.Type.RIGHT) {
                    distToRight += rightWidget.mDistToRight - rightWidget.getWrapWidth();
                } else if (widget.mRight.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToRight += rightWidget.mDistToRight;
                }
            }
            if (widget.mLeft.mTarget != null && !leftWidget.isRoot()) {
                if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToLeft += leftWidget.mDistToLeft - leftWidget.getWrapWidth();
                } else if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.RIGHT) {
                    distToLeft += leftWidget.mDistToLeft;
                }
            }
        }
        widget.mDistToLeft = distToLeft;
        widget.mDistToRight = distToRight;
        int distToTop = h = widget.getWrapHeight();
        int distToBottom = h;
        ConstraintWidget topWidget = null;
        if (widget.mBaseline.mTarget == null && widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
            distToTop += widget.getY();
        } else {
            if (widget.mBaseline.isConnected()) {
                ConstraintWidget baseLineWidget = widget.mBaseline.mTarget.getOwner();
                if (!baseLineWidget.mWrapVisited) {
                    this.findWrapRecursive(baseLineWidget);
                }
                if (baseLineWidget.mDistToBottom > distToBottom) {
                    distToBottom = baseLineWidget.mDistToBottom;
                }
                if (baseLineWidget.mDistToTop > distToTop) {
                    distToTop = baseLineWidget.mDistToTop;
                }
                widget.mDistToTop = distToTop;
                widget.mDistToBottom = distToBottom;
                return;
            }
            if (widget.mTop.isConnected()) {
                topWidget = widget.mTop.mTarget.getOwner();
                distToTop += widget.mTop.getMargin();
                if (!topWidget.isRoot() && !topWidget.mWrapVisited) {
                    this.findWrapRecursive(topWidget);
                }
            }
            ConstraintWidget bottomWidget = null;
            if (widget.mBottom.isConnected()) {
                bottomWidget = widget.mBottom.mTarget.getOwner();
                distToBottom += widget.mBottom.getMargin();
                if (!bottomWidget.isRoot() && !bottomWidget.mWrapVisited) {
                    this.findWrapRecursive(bottomWidget);
                }
            }
            if (widget.mTop.mTarget != null && !topWidget.isRoot()) {
                if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToTop += topWidget.mDistToTop - topWidget.getWrapHeight();
                } else if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToTop += topWidget.mDistToTop;
                }
            }
            if (widget.mBottom.mTarget != null && !bottomWidget.isRoot()) {
                if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToBottom += bottomWidget.mDistToBottom - bottomWidget.getWrapHeight();
                } else if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToBottom += bottomWidget.mDistToBottom;
                }
            }
        }
        widget.mDistToTop = distToTop;
        widget.mDistToBottom = distToBottom;
    }

    public void findWrapSize(ArrayList<ConstraintWidget> children) {
        int maxTopDist = 0;
        int maxLeftDist = 0;
        int maxRightDist = 0;
        int maxBottomDist = 0;
        int maxConnectWidth = 0;
        int maxConnectHeight = 0;
        int size = children.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = children.get(j);
            if (widget.isRoot()) continue;
            if (!widget.mWrapVisited) {
                this.findWrapRecursive(widget);
            }
            int connectWidth = widget.mDistToLeft + widget.mDistToRight - widget.getWrapWidth();
            int connectHeight = widget.mDistToTop + widget.mDistToBottom - widget.getWrapHeight();
            maxLeftDist = Math.max(maxLeftDist, widget.mDistToLeft);
            maxRightDist = Math.max(maxRightDist, widget.mDistToRight);
            maxBottomDist = Math.max(maxBottomDist, widget.mDistToBottom);
            maxTopDist = Math.max(maxTopDist, widget.mDistToTop);
            maxConnectWidth = Math.max(maxConnectWidth, connectWidth);
            maxConnectHeight = Math.max(maxConnectHeight, connectHeight);
        }
        int max = Math.max(maxLeftDist, maxRightDist);
        this.mWrapWidth = Math.max(max, maxConnectWidth);
        max = Math.max(maxTopDist, maxBottomDist);
        this.mWrapHeight = Math.max(max, maxConnectHeight);
        for (int j = 0; j < size; ++j) {
            children.get((int)j).mWrapVisited = false;
        }
    }

    public int layoutFindGroups() {
        ConstraintAnchor anchor;
        ConstraintAnchor.Type[] dir = new ConstraintAnchor.Type[]{ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.BASELINE, ConstraintAnchor.Type.BOTTOM};
        int label = 1;
        int size = this.mChildren.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            ConstraintAnchor anchor2 = null;
            anchor2 = widget.mLeft;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mTop;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mRight;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mBottom;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mBaseline;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) != label) continue;
                ++label;
                continue;
            }
            anchor2.mGroup = Integer.MAX_VALUE;
        }
        boolean notDone = true;
        int count = 0;
        int fix = 0;
        while (notDone) {
            notDone = false;
            ++count;
            for (int j = 0; j < size; ++j) {
                ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
                for (int i = 0; i < dir.length; ++i) {
                    ConstraintAnchor opposite;
                    ConstraintAnchor.Type type = dir[i];
                    anchor = null;
                    switch (type) {
                        case LEFT: {
                            anchor = widget.mLeft;
                            break;
                        }
                        case TOP: {
                            anchor = widget.mTop;
                            break;
                        }
                        case RIGHT: {
                            anchor = widget.mRight;
                            break;
                        }
                        case BOTTOM: {
                            anchor = widget.mBottom;
                            break;
                        }
                        case BASELINE: {
                            anchor = widget.mBaseline;
                        }
                    }
                    ConstraintAnchor target = anchor.mTarget;
                    if (target == null) continue;
                    if (target.mOwner.getParent() != null && target.mGroup != anchor.mGroup) {
                        anchor.mGroup = anchor.mGroup > target.mGroup ? target.mGroup : anchor.mGroup;
                        target.mGroup = anchor.mGroup;
                        ++fix;
                        notDone = true;
                    }
                    if ((opposite = target.getOpposite()) == null || opposite.mGroup == anchor.mGroup) continue;
                    anchor.mGroup = anchor.mGroup > opposite.mGroup ? opposite.mGroup : anchor.mGroup;
                    opposite.mGroup = anchor.mGroup;
                    ++fix;
                    notDone = true;
                }
            }
        }
        int index = 0;
        int[] table = new int[this.mChildren.size() * dir.length + 1];
        Arrays.fill(table, -1);
        for (int j = 0; j < size; ++j) {
            int g;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            anchor = null;
            anchor = widget.mLeft;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mTop;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mRight;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mBottom;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mBaseline;
            if (anchor.mGroup == Integer.MAX_VALUE) continue;
            g = anchor.mGroup;
            if (table[g] == -1) {
                table[g] = index++;
            }
            anchor.mGroup = table[g];
        }
        return index;
    }

    public void layoutWithGroup(int numOfGroups) {
        int i;
        int prex = this.mX;
        int prey = this.mY;
        if (this.mParent != null) {
            if (this.mSnapshot == null) {
                this.mSnapshot = new Snapshot(this);
            }
            this.mSnapshot.updateFrom(this);
            this.mX = 0;
            this.mY = 0;
            this.resetAnchors();
            this.resetSolverVariables(this.mSystem.getCache());
        } else {
            this.mX = 0;
            this.mY = 0;
        }
        int count = this.mChildren.size();
        for (i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
        this.mLeft.mGroup = 0;
        this.mRight.mGroup = 0;
        this.mTop.mGroup = 1;
        this.mBottom.mGroup = 1;
        this.mSystem.reset();
        for (i = 0; i < numOfGroups; ++i) {
            try {
                this.addToSolver(this.mSystem, i);
                this.mSystem.minimize();
                this.updateFromSolver(this.mSystem, i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateFromSolver(this.mSystem, -2);
        }
        if (this.mParent != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.mSnapshot.applyTo(this);
            this.setWidth(width);
            this.setHeight(height);
        } else {
            this.mX = prex;
            this.mY = prey;
        }
        if (this == this.getRootConstraintContainer()) {
            this.updateDrawPosition();
        }
    }

    @Override
    public boolean isAnimating() {
        if (super.isAnimating()) {
            return true;
        }
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!widget.isAnimating()) continue;
            return true;
        }
        return false;
    }

    public boolean handlesInternalConstraints() {
        return false;
    }

    public ArrayList<Guideline> getVerticalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 1) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public ArrayList<Guideline> getHorizontalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 0) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public LinearSystem getSystem() {
        return this.mSystem;
    }

    private void resetChains() {
        this.mHorizontalChainsSize = 0;
        this.mVerticalChainsSize = 0;
    }

    void addChain(ConstraintWidget constraintWidget, int type) {
        ConstraintWidget widget = constraintWidget;
        if (type == 0) {
            while (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner.mRight.mTarget != null && widget.mLeft.mTarget.mOwner.mRight.mTarget == widget.mLeft && widget.mLeft.mTarget.mOwner != widget) {
                widget = widget.mLeft.mTarget.mOwner;
            }
            this.addHorizontalChain(widget);
        } else if (type == 1) {
            while (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner.mBottom.mTarget != null && widget.mTop.mTarget.mOwner.mBottom.mTarget == widget.mTop && widget.mTop.mTarget.mOwner != widget) {
                widget = widget.mTop.mTarget.mOwner;
            }
            this.addVerticalChain(widget);
        }
    }

    private void addHorizontalChain(ConstraintWidget widget) {
        for (int i = 0; i < this.mHorizontalChainsSize; ++i) {
            if (this.mHorizontalChainsArray[i] != widget) continue;
            return;
        }
        if (this.mHorizontalChainsSize + 1 >= this.mHorizontalChainsArray.length) {
            this.mHorizontalChainsArray = Arrays.copyOf(this.mHorizontalChainsArray, this.mHorizontalChainsArray.length * 2);
        }
        this.mHorizontalChainsArray[this.mHorizontalChainsSize] = widget;
        ++this.mHorizontalChainsSize;
    }

    private void addVerticalChain(ConstraintWidget widget) {
        for (int i = 0; i < this.mVerticalChainsSize; ++i) {
            if (this.mVerticalChainsArray[i] != widget) continue;
            return;
        }
        if (this.mVerticalChainsSize + 1 >= this.mVerticalChainsArray.length) {
            this.mVerticalChainsArray = Arrays.copyOf(this.mVerticalChainsArray, this.mVerticalChainsArray.length * 2);
        }
        this.mVerticalChainsArray[this.mVerticalChainsSize] = widget;
        ++this.mVerticalChainsSize;
    }

    private int countMatchConstraintsChainedWidgets(ConstraintWidget widget, int direction) {
        int count = 0;
        if (direction == 0) {
            boolean fixedPosition = true;
            ConstraintWidget first = widget;
            if (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            while (widget.mRight.mTarget != null) {
                if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (count + 1 >= this.mMatchConstraintsChainedWidgets.length) {
                        this.mMatchConstraintsChainedWidgets = Arrays.copyOf(this.mMatchConstraintsChainedWidgets, this.mMatchConstraintsChainedWidgets.length * 2);
                    }
                    this.mMatchConstraintsChainedWidgets[count++] = widget;
                }
                if (widget.mRight.mTarget.mOwner.mLeft.mTarget == null || widget.mRight.mTarget.mOwner.mLeft.mTarget.mOwner != widget || widget.mRight.mTarget.mOwner == widget) break;
                widget = widget.mRight.mTarget.mOwner;
            }
            if (widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            first.mHorizontalChainFixedPosition = fixedPosition;
        } else {
            boolean fixedPosition = true;
            ConstraintWidget first = widget;
            if (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            while (widget.mBottom.mTarget != null) {
                if (widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (count + 1 >= this.mMatchConstraintsChainedWidgets.length) {
                        this.mMatchConstraintsChainedWidgets = Arrays.copyOf(this.mMatchConstraintsChainedWidgets, this.mMatchConstraintsChainedWidgets.length * 2);
                    }
                    this.mMatchConstraintsChainedWidgets[count++] = widget;
                }
                if (widget.mBottom.mTarget.mOwner.mTop.mTarget == null || widget.mBottom.mTarget.mOwner.mTop.mTarget.mOwner != widget || widget.mBottom.mTarget.mOwner == widget) break;
                widget = widget.mBottom.mTarget.mOwner;
            }
            if (widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            first.mVerticalChainFixedPosition = fixedPosition;
        }
        return count;
    }
}

