/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.applet.BasicAppletContext;
import org.fest.swing.applet.BasicAppletStub;
import org.fest.swing.applet.StatusDisplay;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class AppletViewer
extends JFrame
implements StatusDisplay {
    private static final Dimension DEFAULT_SIZE = new Dimension(100, 100);
    private final JLabel statusLabel;
    private final Applet applet;
    private transient AppletStub stub;
    private boolean loaded;

    @Nonnull
    @RunsInEDT
    public static AppletViewer newViewer(@Nonnull Applet applet) {
        if (applet == null) {
            AppletViewer.$$$reportNull$$$0(0);
        }
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(new BasicAppletStub(viewer, new BasicAppletContext(viewer)));
        AppletViewer appletViewer = viewer;
        if (appletViewer == null) {
            AppletViewer.$$$reportNull$$$0(1);
        }
        return appletViewer;
    }

    @Nonnull
    @RunsInEDT
    public static AppletViewer newViewer(@Nonnull Applet applet, @Nonnull Map<String, String> parameters) {
        if (applet == null) {
            AppletViewer.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            AppletViewer.$$$reportNull$$$0(3);
        }
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(new BasicAppletStub(viewer, new BasicAppletContext(viewer), parameters));
        AppletViewer appletViewer = viewer;
        if (appletViewer == null) {
            AppletViewer.$$$reportNull$$$0(4);
        }
        return appletViewer;
    }

    @RunsInEDT
    public static AppletViewer newViewer(@Nonnull Applet applet, @Nonnull AppletStub stub) {
        if (applet == null) {
            AppletViewer.$$$reportNull$$$0(5);
        }
        if (stub == null) {
            AppletViewer.$$$reportNull$$$0(6);
        }
        Preconditions.checkNotNull((Object)applet);
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(stub);
        return viewer;
    }

    @RunsInEDT
    private static AppletViewer createInEDT(final @Nonnull Applet applet) {
        if (applet == null) {
            AppletViewer.$$$reportNull$$$0(7);
        }
        return GuiActionRunner.execute(new GuiQuery<AppletViewer>(){

            @Override
            protected AppletViewer executeInEDT() {
                return new AppletViewer(applet);
            }
        });
    }

    private AppletViewer(@Nonnull Applet applet) {
        if (applet == null) {
            AppletViewer.$$$reportNull$$$0(8);
        }
        this.statusLabel = new JLabel();
        this.applet = (Applet)Preconditions.checkNotNull((Object)applet);
        this.setUpFrame();
        this.addContent();
    }

    private void setUpFrame() {
        this.setTitle(Strings.concat((Object[])new Object[]{"Applet Viewer: ", this.applet.getClass().getName()}));
        this.setSize(DEFAULT_SIZE);
        this.setLayout(new BorderLayout());
    }

    private void addContent() {
        this.add((Component)this.applet, "Center");
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.statusLabel.setName("status");
        this.add((Component)this.statusLabel, "South");
    }

    private void appletStub(@Nonnull AppletStub newAppletStub) {
        if (newAppletStub == null) {
            AppletViewer.$$$reportNull$$$0(9);
        }
        Preconditions.checkNotNull((Object)newAppletStub);
        this.stub = newAppletStub;
        this.applet.setStub(this.stub);
        this.setUpApplet();
    }

    private void setUpApplet() {
        this.loadApplet();
        this.showStatus("Applet loaded");
    }

    public void reloadApplet() {
        if (this.loaded) {
            this.unloadApplet();
        }
        this.loadApplet();
    }

    private void loadApplet() {
        this.applet.init();
        this.applet.start();
        this.loaded = true;
    }

    public void unloadApplet() {
        this.applet.stop();
        this.applet.destroy();
        this.loaded = false;
    }

    public boolean appletLoaded() {
        return this.loaded;
    }

    @Override
    @RunsInEDT
    public void showStatus(final @Nonnull String status) {
        if (status == null) {
            AppletViewer.$$$reportNull$$$0(10);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.setStatus(status);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppletViewer.this.setStatus(status);
            }
        });
    }

    @RunsInCurrentThread
    private void setStatus(@Nonnull String status) {
        if (status == null) {
            AppletViewer.$$$reportNull$$$0(11);
        }
        this.statusLabel.setText(status);
    }

    @Nonnull
    public Applet getApplet() {
        Applet applet = this.applet;
        if (applet == null) {
            AppletViewer.$$$reportNull$$$0(12);
        }
        return applet;
    }

    @Nonnull
    public AppletStub getAppletStub() {
        AppletStub appletStub = this.stub;
        if (appletStub == null) {
            AppletViewer.$$$reportNull$$$0(13);
        }
        return appletStub;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 13: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applet";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/applet/AppletViewer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAppletStub";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/applet/AppletViewer";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newViewer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppletStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newViewer";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInEDT";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appletStub";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showStatus";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

