/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Robot;
import javax.annotation.Nonnull;
import org.fest.swing.core.ComponentLookupScope;
import org.fest.swing.util.Platform;
import org.fest.util.VisibleForTesting;

public class Settings {
    private static final int DEFAULT_DELAY = 30000;
    private ComponentLookupScope componentLookupScope;
    private int timeoutToBeVisible;
    private int timeoutToFindPopup;
    private int timeoutToFindSubMenu;
    private int delayBetweenEvents;
    private int dragDelay;
    private int dropDelay;
    private int eventPostingDelay;
    private int idleTimeout;
    private Robot robot;

    public Settings() {
        this.timeoutToBeVisible(30000);
        this.timeoutToFindPopup(30000);
        this.timeoutToFindSubMenu(100);
        this.delayBetweenEvents(60);
        this.dragDelay(0);
        this.dropDelay(0);
        this.eventPostingDelay(100);
        this.componentLookupScope(ComponentLookupScope.DEFAULT);
        this.idleTimeout(10000);
    }

    void attachTo(@Nonnull Robot newRobot) {
        if (newRobot == null) {
            Settings.$$$reportNull$$$0(0);
        }
        this.robot = newRobot;
        if (this.delayBetweenEvents < 0) {
            this.delayBetweenEvents = this.robot.getAutoDelay();
        } else {
            this.updateRobotAutoDelay();
        }
    }

    @Nonnull
    @VisibleForTesting
    Robot robot() {
        Robot robot = this.robot;
        if (robot == null) {
            Settings.$$$reportNull$$$0(1);
        }
        return robot;
    }

    public int delayBetweenEvents() {
        return this.delayBetweenEvents;
    }

    public void delayBetweenEvents(int ms) {
        this.delayBetweenEvents = this.valueToUpdate(ms, -1, 60000);
        if (this.robot != null) {
            this.updateRobotAutoDelay();
        }
    }

    private void updateRobotAutoDelay() {
        this.robot.setAutoDelay(this.delayBetweenEvents);
    }

    public int timeoutToBeVisible() {
        return this.timeoutToBeVisible;
    }

    public void timeoutToBeVisible(int ms) {
        this.timeoutToBeVisible = this.valueToUpdate(ms, 0, 60000);
    }

    public int timeoutToFindPopup() {
        return this.timeoutToFindPopup;
    }

    public void timeoutToFindPopup(int ms) {
        this.timeoutToFindPopup = this.valueToUpdate(ms, 0, 60000);
    }

    public int timeoutToFindSubMenu() {
        return this.timeoutToFindSubMenu;
    }

    public void timeoutToFindSubMenu(int ms) {
        this.timeoutToFindSubMenu = this.valueToUpdate(ms, 0, 10000);
    }

    public int dragDelay() {
        return this.dragDelay;
    }

    public void dragDelay(int ms) {
        int min = Platform.isX11() || Platform.isOSX() ? 100 : 0;
        this.dragDelay = this.valueToUpdate(ms, min, 60000);
    }

    public int eventPostingDelay() {
        return this.eventPostingDelay;
    }

    public void eventPostingDelay(int ms) {
        this.eventPostingDelay = this.valueToUpdate(ms, 0, 1000);
    }

    public int dropDelay() {
        return this.dropDelay;
    }

    public void dropDelay(int ms) {
        int min = Platform.isWindows() ? 200 : 0;
        this.dropDelay = this.valueToUpdate(ms, min, 60000);
    }

    @Nonnull
    public ComponentLookupScope componentLookupScope() {
        ComponentLookupScope componentLookupScope = this.componentLookupScope;
        if (componentLookupScope == null) {
            Settings.$$$reportNull$$$0(2);
        }
        return componentLookupScope;
    }

    public void componentLookupScope(@Nonnull ComponentLookupScope scope) {
        if (scope == null) {
            Settings.$$$reportNull$$$0(3);
        }
        this.componentLookupScope = scope;
    }

    public int idleTimeout() {
        return this.idleTimeout;
    }

    public void idleTimeout(int ms) {
        this.idleTimeout = this.valueToUpdate(ms, 0, Integer.MAX_VALUE);
    }

    private int valueToUpdate(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRobot";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/Settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/Settings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "robot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "componentLookupScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachTo";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "componentLookupScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

