/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractButtonSelectedQuery;
import org.fest.swing.driver.AbstractButtonTextQuery;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class AbstractButtonDriver
extends JComponentDriver
implements TextDisplayDriver<AbstractButton> {
    private static final String SELECTED_PROPERTY = "selected";
    private static final String TEXT_PROPERTY = "text";

    public AbstractButtonDriver(@Nonnull Robot robot) {
        if (robot == null) {
            AbstractButtonDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull AbstractButton button, @Nullable String expected) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(1);
        }
        TextAssert.verifyThat(this.textOf(button)).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    public void requireText(@Nonnull AbstractButton button, @Nonnull Pattern pattern) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            AbstractButtonDriver.$$$reportNull$$$0(3);
        }
        TextAssert.verifyThat(this.textOf(button)).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)).matches(pattern);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public String textOf(@Nonnull AbstractButton button) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(4);
        }
        String string = AbstractButtonTextQuery.textOf(button);
        if (string == null) {
            AbstractButtonDriver.$$$reportNull$$$0(5);
        }
        return string;
    }

    @RunsInEDT
    public void select(@Nonnull AbstractButton button) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(6);
        }
        if (AbstractButtonDriver.checkSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    public void deselect(@Nonnull AbstractButton button) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(7);
        }
        if (!AbstractButtonDriver.checkSelected(button)) {
            return;
        }
        this.robot.click(button);
    }

    @RunsInEDT
    private static boolean checkSelected(final @Nonnull AbstractButton button) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(8);
        }
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            @Nullable
            protected Boolean executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(button);
                return button.isSelected();
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    public void requireSelected(@Nonnull AbstractButton button) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(9);
        }
        this.assertThatButtonIsSelected(button, true);
    }

    @RunsInEDT
    public void requireNotSelected(@Nonnull AbstractButton button) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(10);
        }
        this.assertThatButtonIsSelected(button, false);
    }

    @RunsInEDT
    private void assertThatButtonIsSelected(@Nonnull AbstractButton button, boolean selected) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(11);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)AbstractButtonSelectedQuery.isSelected(button)).as(AbstractButtonDriver.selectedProperty(button))).isEqualTo(selected);
    }

    @Nonnull
    @RunsInEDT
    private static Description selectedProperty(@Nonnull AbstractButton button) {
        if (button == null) {
            AbstractButtonDriver.$$$reportNull$$$0(12);
        }
        Description description = AbstractButtonDriver.propertyName(button, SELECTED_PROPERTY);
        if (description == null) {
            AbstractButtonDriver.$$$reportNull$$$0(13);
        }
        return description;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/AbstractButtonDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/AbstractButtonDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "textOf";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requireText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "textOf";
                break;
            }
            case 5: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deselect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkSelected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "requireSelected";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requireNotSelected";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertThatButtonIsSelected";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectedProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

