/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;
import org.fest.util.Preconditions;

public class BasicJListCellReader
implements JListCellReader {
    private final CellRendererReader rendererReader;

    public BasicJListCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJListCellReader(@Nonnull CellRendererReader rendererReader) {
        if (rendererReader == null) {
            BasicJListCellReader.$$$reportNull$$$0(0);
        }
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)rendererReader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JList list, int index) {
        String value;
        if (list == null) {
            BasicJListCellReader.$$$reportNull$$$0(1);
        }
        Object element = list.getModel().getElementAt(index);
        Component c = list.getCellRenderer().getListCellRendererComponent(list, element, index, true, true);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        return ModelValueToString.asText(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererReader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/BasicJListCellReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "valueAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

