/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Pair;
import org.fest.util.Preconditions;

final class JComboBoxSelectionValueQuery {
    private static final Pair<Boolean, String> NO_SELECTION = Pair.of(false, null);

    @Nonnull
    @RunsInEDT
    static Pair<Boolean, String> selection(final @Nonnull JComboBox comboBox, final @Nonnull JComboBoxCellReader cellReader) {
        if (comboBox == null) {
            JComboBoxSelectionValueQuery.$$$reportNull$$$0(0);
        }
        if (cellReader == null) {
            JComboBoxSelectionValueQuery.$$$reportNull$$$0(1);
        }
        Pair<Boolean, String> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, String>>(){

            @Override
            @Nullable
            protected Pair<Boolean, String> executeInEDT() {
                int selectedIndex = comboBox.getSelectedIndex();
                if (selectedIndex == -1) {
                    return JComboBoxSelectionValueQuery.valueForNoSelection(comboBox);
                }
                return JComboBoxSelectionValueQuery.selection(cellReader.valueAt(comboBox, selectedIndex));
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JComboBoxSelectionValueQuery.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @Nonnull
    private static Pair<Boolean, String> valueForNoSelection(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxSelectionValueQuery.$$$reportNull$$$0(3);
        }
        if (!comboBox.isEditable()) {
            Pair<Boolean, String> pair = NO_SELECTION;
            if (pair == null) {
                JComboBoxSelectionValueQuery.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Object selectedItem = comboBox.getSelectedItem();
        if (selectedItem instanceof String) {
            Pair<Boolean, String> pair = JComboBoxSelectionValueQuery.selection((String)selectedItem);
            if (pair == null) {
                JComboBoxSelectionValueQuery.$$$reportNull$$$0(5);
            }
            return pair;
        }
        if (selectedItem != null) {
            Pair<Boolean, String> pair = JComboBoxSelectionValueQuery.selection(selectedItem.toString());
            if (pair == null) {
                JComboBoxSelectionValueQuery.$$$reportNull$$$0(6);
            }
            return pair;
        }
        Pair<Boolean, String> pair = NO_SELECTION;
        if (pair == null) {
            JComboBoxSelectionValueQuery.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Nonnull
    private static Pair<Boolean, String> selection(@Nullable String selection) {
        Pair<Boolean, String> pair = Pair.of(true, selection);
        if (pair == null) {
            JComboBoxSelectionValueQuery.$$$reportNull$$$0(8);
        }
        return pair;
    }

    private JComboBoxSelectionValueQuery() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JComboBoxSelectionValueQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JComboBoxSelectionValueQuery";
                break;
            }
            case 2: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "selection";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "valueForNoSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selection";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "valueForNoSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

