/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JLabelTextQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.util.InternalApi;

@InternalApi
public class JLabelDriver
extends JComponentDriver
implements TextDisplayDriver<JLabel> {
    private static final String TEXT_PROPERTY = "text";

    public JLabelDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JLabelDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JLabel label, @Nullable String expected) {
        if (label == null) {
            JLabelDriver.$$$reportNull$$$0(1);
        }
        TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JLabel label, @Nonnull Pattern pattern) {
        if (label == null) {
            JLabelDriver.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            JLabelDriver.$$$reportNull$$$0(3);
        }
        TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY)).matches(pattern);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JLabel label) {
        if (label == null) {
            JLabelDriver.$$$reportNull$$$0(4);
        }
        return JLabelTextQuery.textOf(label);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JLabelDriver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "requireText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "textOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

