/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.WindowAncestorFinder;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JMenuItemLocation;
import org.fest.swing.driver.JMenuPopupMenuQuery;
import org.fest.swing.driver.WindowMoveToFrontTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

@InternalApi
public class JMenuItemDriver
extends JComponentDriver {
    public JMenuItemDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JMenuItemDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void click(@Nonnull JMenuItem menuItem) {
        if (menuItem == null) {
            JMenuItemDriver.$$$reportNull$$$0(1);
        }
        this.show(menuItem);
        this.doClick(menuItem);
        this.ensurePopupIsShowing(menuItem);
    }

    @RunsInEDT
    private void show(@Nonnull JMenuItem menuItem) {
        if (menuItem == null) {
            JMenuItemDriver.$$$reportNull$$$0(2);
        }
        JMenuItemLocation location = JMenuItemDriver.locationOf(menuItem);
        this.activateParentIfIsMenu(location);
        this.moveParentWindowToFront(location);
        if (menuItem instanceof JMenu && !location.inMenuBar()) {
            this.waitForSubMenuToShow();
        }
    }

    @Nonnull
    @RunsInEDT
    private static JMenuItemLocation locationOf(final @Nonnull JMenuItem menuItem) {
        if (menuItem == null) {
            JMenuItemDriver.$$$reportNull$$$0(3);
        }
        JMenuItemLocation result = GuiActionRunner.execute(new GuiQuery<JMenuItemLocation>(){

            @Override
            protected JMenuItemLocation executeInEDT() {
                return new JMenuItemLocation(menuItem);
            }
        });
        JMenuItemLocation jMenuItemLocation = (JMenuItemLocation)Preconditions.checkNotNull((Object)result);
        if (jMenuItemLocation == null) {
            JMenuItemDriver.$$$reportNull$$$0(4);
        }
        return jMenuItemLocation;
    }

    @RunsInEDT
    private void activateParentIfIsMenu(@Nonnull JMenuItemLocation location) {
        if (location == null) {
            JMenuItemDriver.$$$reportNull$$$0(5);
        }
        if (!location.isParentAMenu()) {
            return;
        }
        Component c = location.parentOrInvoker();
        if (c instanceof JMenuItem) {
            this.click((JMenuItem)c);
        }
    }

    @RunsInEDT
    private void moveParentWindowToFront(@Nonnull JMenuItemLocation location) {
        if (location == null) {
            JMenuItemDriver.$$$reportNull$$$0(6);
        }
        if (!location.inMenuBar()) {
            return;
        }
        this.moveToFront(WindowAncestorFinder.windowAncestorOf(location.parentOrInvoker()));
    }

    @RunsInEDT
    private void doClick(@Nonnull JMenuItem menuItem) {
        if (menuItem == null) {
            JMenuItemDriver.$$$reportNull$$$0(7);
        }
        if (this.isMacOSMenuBar()) {
            JMenuItemDriver.validateAndDoClick(menuItem);
            return;
        }
        super.click(menuItem);
        this.robot.waitForIdle();
    }

    private boolean isMacOSMenuBar() {
        return Platform.isOSX() && (Boolean.getBoolean("apple.laf.useScreenMenuBar") || Boolean.getBoolean("com.apple.macos.useScreenMenuBar"));
    }

    @RunsInEDT
    private static void validateAndDoClick(final @Nonnull JMenuItem menuItem) {
        if (menuItem == null) {
            JMenuItemDriver.$$$reportNull$$$0(8);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(menuItem);
                menuItem.doClick();
            }
        });
    }

    @RunsInEDT
    private void ensurePopupIsShowing(@Nonnull JMenuItem menuItem) {
        if (menuItem == null) {
            JMenuItemDriver.$$$reportNull$$$0(9);
        }
        if (!(menuItem instanceof JMenu)) {
            return;
        }
        JPopupMenu popup = JMenuPopupMenuQuery.popupMenuOf((JMenu)menuItem);
        if (!this.waitForShowing(popup, this.robot.settings().timeoutToFindPopup())) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Clicking on menu item <", Formatting.format(menuItem), "> never showed a pop-up menu"}));
        }
        this.waitForSubMenuToShow();
    }

    private void waitForSubMenuToShow() {
        Pause.pause(this.robot.settings().timeoutToFindSubMenu());
    }

    @RunsInEDT
    private void moveToFront(@Nullable Window w) {
        if (w == null) {
            return;
        }
        WindowMoveToFrontTask.toFront(w);
        this.robot.waitForIdle();
        this.robot.moveMouse(w);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menuItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JMenuItemDriver";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JMenuItemDriver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "locationOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "click";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "locationOf";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "activateParentIfIsMenu";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveParentWindowToFront";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doClick";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateAndDoClick";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensurePopupIsShowing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

