/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JProgressBar;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JProgressBarIndeterminateQuery;
import org.fest.swing.driver.JProgressBarMinimumAndMaximumQuery;
import org.fest.swing.driver.JProgressBarStringQuery;
import org.fest.swing.driver.JProgressBarValueQuery;
import org.fest.swing.driver.JProgressBarWaitUntilIsDeterminate;
import org.fest.swing.driver.JProgressBarWaitUntilValueIsEqualToExpectedTask;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.Pair;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JProgressBarDriver
extends JComponentDriver
implements TextDisplayDriver<JProgressBar> {
    private static final Timeout DEFAULT_TIMEOUT = Timeout.timeout(30L, TimeUnit.SECONDS);
    private static final String TEXT_PROPERTY = "string";

    public JProgressBarDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JProgressBarDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JProgressBar progressBar, @Nullable String expected) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(1);
        }
        TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JProgressBar progressBar, @Nonnull Pattern pattern) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            JProgressBarDriver.$$$reportNull$$$0(3);
        }
        TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY)).matches(pattern);
    }

    @RunsInEDT
    public void requireValue(@Nonnull JProgressBar progressBar, int value) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(4);
        }
        ((IntAssert)Assertions.assertThat((int)JProgressBarValueQuery.valueOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "value"))).isEqualTo(value);
    }

    @RunsInEDT
    public void requireIndeterminate(@Nonnull JProgressBar progressBar) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(5);
        }
        this.requireIndeterminate(progressBar, true);
    }

    @RunsInEDT
    public void requireDeterminate(@Nonnull JProgressBar progressBar) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(6);
        }
        this.requireIndeterminate(progressBar, false);
    }

    @RunsInEDT
    private void requireIndeterminate(@Nonnull JProgressBar progressBar, boolean indeterminate) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(7);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)JProgressBarIndeterminateQuery.isIndeterminate(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "indeterminate"))).isEqualTo(indeterminate);
    }

    @RunsInEDT
    public void waitUntilValueIs(@Nonnull JProgressBar progressBar, int value) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(8);
        }
        this.waitUntilValueIs(progressBar, value, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilValueIs(@Nonnull JProgressBar progressBar, int value, @Nonnull Timeout timeout) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(9);
        }
        if (timeout == null) {
            JProgressBarDriver.$$$reportNull$$$0(10);
        }
        this.checkInBetweenMinAndMax(progressBar, value);
        Preconditions.checkNotNull((Object)timeout);
        JProgressBarWaitUntilValueIsEqualToExpectedTask.waitUntilValueIsEqualToExpected(progressBar, value, timeout);
    }

    @RunsInEDT
    private void checkInBetweenMinAndMax(@Nonnull JProgressBar progressBar, int value) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(11);
        }
        Pair<Integer, Integer> minAndMax = JProgressBarMinimumAndMaximumQuery.minimumAndMaximumOf(progressBar);
        this.assertIsInBetweenMinAndMax(value, (Integer)minAndMax.first, (Integer)minAndMax.second);
    }

    private void assertIsInBetweenMinAndMax(int value, int min, int max) {
        if (value >= min && value <= max) {
            return;
        }
        String msg = String.format("Value <%d> should be between <[%d, %d]>", value, min, max);
        throw new IllegalArgumentException(msg);
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(@Nonnull JProgressBar progressBar) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(12);
        }
        this.waitUntilIsDeterminate(progressBar, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(@Nonnull JProgressBar progressBar, @Nonnull Timeout timeout) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(13);
        }
        if (timeout == null) {
            JProgressBarDriver.$$$reportNull$$$0(14);
        }
        Preconditions.checkNotNull((Object)timeout);
        JProgressBarWaitUntilIsDeterminate.waitUntilValueIsDeterminate(progressBar, timeout);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JProgressBar progressBar) {
        if (progressBar == null) {
            JProgressBarDriver.$$$reportNull$$$0(15);
        }
        return JProgressBarStringQuery.stringOf(progressBar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressBar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JProgressBarDriver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "requireText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "requireValue";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "requireIndeterminate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "requireDeterminate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "waitUntilValueIs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInBetweenMinAndMax";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "waitUntilIsDeterminate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "textOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

