/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JSlider;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSliderLocation;
import org.fest.swing.driver.JSliderSetValueTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JSliderDriver
extends JComponentDriver {
    private final JSliderLocation location;

    public JSliderDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JSliderDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.location = new JSliderLocation();
    }

    @RunsInEDT
    public void slideToMaximum(@Nonnull JSlider slider) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(1);
        }
        this.slide(slider, JSliderDriver.findSlideToMaximumInfo(slider, this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findSlideToMaximumInfo(final @Nonnull JSlider slider, final @Nonnull JSliderLocation location) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(2);
        }
        if (location == null) {
            JSliderDriver.$$$reportNull$$$0(3);
        }
        Pair<Integer, GenericRange<Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(slider);
                int value = slider.getMaximum();
                GenericRange fromAndTo = JSliderDriver.slideInfo(slider, location, value);
                return Pair.of(value, fromAndTo);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JSliderDriver.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @RunsInEDT
    public void slideToMinimum(@Nonnull JSlider slider) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(5);
        }
        this.slide(slider, JSliderDriver.findSlideToMinimumInfo(slider, this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findSlideToMinimumInfo(final @Nonnull JSlider slider, final @Nonnull JSliderLocation location) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(6);
        }
        if (location == null) {
            JSliderDriver.$$$reportNull$$$0(7);
        }
        Pair<Integer, GenericRange<Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(slider);
                int value = slider.getMinimum();
                GenericRange fromAndTo = JSliderDriver.slideInfo(slider, location, value);
                return Pair.of(value, fromAndTo);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JSliderDriver.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @RunsInEDT
    private void slide(@Nonnull JSlider slider, @Nonnull Pair<Integer, GenericRange<Point>> slideInfo) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(9);
        }
        if (slideInfo == null) {
            JSliderDriver.$$$reportNull$$$0(10);
        }
        this.slide(slider, (Integer)slideInfo.first, (GenericRange)Preconditions.checkNotNull(slideInfo.second));
    }

    @RunsInEDT
    public void slide(@Nonnull JSlider slider, int value) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(11);
        }
        GenericRange<Point> slideInfo = JSliderDriver.findSlideInfo(slider, this.location(), value);
        this.slide(slider, value, slideInfo);
    }

    @RunsInEDT
    private void slide(@Nonnull JSlider slider, int value, @Nonnull GenericRange<Point> fromAndTo) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(12);
        }
        if (fromAndTo == null) {
            JSliderDriver.$$$reportNull$$$0(13);
        }
        this.moveMouseIgnoringAnyError(slider, fromAndTo.from());
        this.moveMouseIgnoringAnyError(slider, fromAndTo.to());
        JSliderSetValueTask.setValue(slider, value);
        this.robot.waitForIdle();
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findSlideInfo(final @Nonnull JSlider slider, final @Nonnull JSliderLocation location, final int value) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(14);
        }
        if (location == null) {
            JSliderDriver.$$$reportNull$$$0(15);
        }
        GenericRange<Point> result = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                JSliderDriver.checkValueInBounds(slider, value);
                ComponentPreconditions.checkEnabledAndShowing(slider);
                return JSliderDriver.slideInfo(slider, location, value);
            }
        });
        GenericRange genericRange = (GenericRange)Preconditions.checkNotNull(result);
        if (genericRange == null) {
            JSliderDriver.$$$reportNull$$$0(16);
        }
        return genericRange;
    }

    @RunsInCurrentThread
    private static void checkValueInBounds(@Nonnull JSlider slider, int value) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(17);
        }
        int min = slider.getMinimum();
        int max = slider.getMaximum();
        if (value >= min && value <= max) {
            return;
        }
        String msg = String.format("Value <%d> is not within the JSlider bounds of <%d> and <%d>", value, min, max);
        throw new IllegalArgumentException(msg);
    }

    @RunsInCurrentThread
    private static GenericRange<Point> slideInfo(@Nonnull JSlider slider, JSliderLocation location, int value) {
        if (slider == null) {
            JSliderDriver.$$$reportNull$$$0(18);
        }
        Point from = location.pointAt(slider, slider.getValue());
        Point to = location.pointAt(slider, value);
        return new GenericRange<Point>(from, to);
    }

    @Nonnull
    private JSliderLocation location() {
        JSliderLocation jSliderLocation = this.location;
        if (jSliderLocation == null) {
            JSliderDriver.$$$reportNull$$$0(19);
        }
        return jSliderLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 19: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slider";
                break;
            }
            case 3: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JSliderDriver";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slideInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromAndTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JSliderDriver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSlideToMaximumInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findSlideToMinimumInfo";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findSlideInfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "slideToMaximum";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSlideToMaximumInfo";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "slideToMinimum";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSlideToMinimumInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "slide";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSlideInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkValueInBounds";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "slideInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

