/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.data.TableCell;
import org.fest.util.Preconditions;

public final class JTableCellPreconditions {
    @RunsInCurrentThread
    public static void validateCellIsEditable(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableCellPreconditions.$$$reportNull$$$0(0);
        }
        if (!table.isCellEditable(row, column)) {
            String msg = String.format("Expecting cell [%d, %d] to be editable", row, column);
            throw new IllegalStateException(msg);
        }
    }

    @RunsInCurrentThread
    public static void checkCellIndicesInBounds(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableCellPreconditions.$$$reportNull$$$0(1);
        }
        if (cell == null) {
            JTableCellPreconditions.$$$reportNull$$$0(2);
        }
        Preconditions.checkNotNull((Object)cell);
        JTableCellPreconditions.checkCellIndicesInBounds(table, cell.row, cell.column);
    }

    @RunsInCurrentThread
    public static void checkCellIndicesInBounds(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableCellPreconditions.$$$reportNull$$$0(3);
        }
        if (table.getRowCount() == 0) {
            throw new IndexOutOfBoundsException("Table does not contain any rows");
        }
        JTableCellPreconditions.checkRowInBounds(table, row);
        JTableCellPreconditions.checkColumnInBounds(table, column);
    }

    @RunsInCurrentThread
    public static void checkRowInBounds(@Nonnull JTable table, int row) {
        if (table == null) {
            JTableCellPreconditions.$$$reportNull$$$0(4);
        }
        JTableCellPreconditions.checkIndexInBounds(row, table.getRowCount(), "row");
    }

    @RunsInCurrentThread
    public static void checkColumnInBounds(@Nonnull JTable table, int column) {
        if (table == null) {
            JTableCellPreconditions.$$$reportNull$$$0(5);
        }
        JTableCellPreconditions.checkIndexInBounds(column, table.getColumnCount(), "column");
    }

    @RunsInCurrentThread
    private static void checkIndexInBounds(int index, int itemCount, @Nonnull String indexName) {
        if (indexName == null) {
            JTableCellPreconditions.$$$reportNull$$$0(6);
        }
        if (index >= 0 && index < itemCount) {
            return;
        }
        String msg = String.format("%s <%d> should be between <0> and <%d>", indexName, index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    private JTableCellPreconditions() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JTableCellPreconditions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateCellIsEditable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCellIndicesInBounds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRowInBounds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkColumnInBounds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIndexInBounds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

