/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.table.JTableHeader;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.swing.util.TextMatcher;

public class JTableHeaderLocation {
    @Nonnull
    @RunsInCurrentThread
    public Pair<Integer, Point> pointAt(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher) {
        int index;
        if (tableHeader == null) {
            JTableHeaderLocation.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            JTableHeaderLocation.$$$reportNull$$$0(1);
        }
        if (this.isValidIndex(tableHeader, index = this.indexOf(tableHeader, matcher))) {
            Pair<Integer, Point> pair = Pair.of(index, JTableHeaderLocation.point(tableHeader, index));
            if (pair == null) {
                JTableHeaderLocation.$$$reportNull$$$0(2);
            }
            return pair;
        }
        String format = "Unable to find column with name matching %s %s";
        String msg = String.format(format, matcher.description(), matcher.formattedValues());
        throw new LocationUnavailableException(msg);
    }

    @RunsInCurrentThread
    private boolean isValidIndex(@Nonnull JTableHeader tableHeader, int index) {
        if (tableHeader == null) {
            JTableHeaderLocation.$$$reportNull$$$0(3);
        }
        int itemCount = this.columnCount(tableHeader);
        return index >= 0 && index < itemCount;
    }

    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTableHeader tableHeader, int index) {
        if (tableHeader == null) {
            JTableHeaderLocation.$$$reportNull$$$0(4);
        }
        Point point = JTableHeaderLocation.point(tableHeader, this.checkIndexInBounds(tableHeader, index));
        if (point == null) {
            JTableHeaderLocation.$$$reportNull$$$0(5);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point point(@Nonnull JTableHeader tableHeader, int index) {
        if (tableHeader == null) {
            JTableHeaderLocation.$$$reportNull$$$0(6);
        }
        Rectangle r = tableHeader.getHeaderRect(index);
        Point point = new Point(r.x + r.width / 2, r.y + r.height / 2);
        if (point == null) {
            JTableHeaderLocation.$$$reportNull$$$0(7);
        }
        return point;
    }

    @RunsInCurrentThread
    private int checkIndexInBounds(@Nonnull JTableHeader tableHeader, int index) {
        if (tableHeader == null) {
            JTableHeaderLocation.$$$reportNull$$$0(8);
        }
        int itemCount = this.columnCount(tableHeader);
        if (index >= 0 && index < itemCount) {
            return index;
        }
        String msg = String.format("Item index <%d> should be between <0> and <%d>", index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    @RunsInCurrentThread
    public int indexOf(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher) {
        if (tableHeader == null) {
            JTableHeaderLocation.$$$reportNull$$$0(9);
        }
        if (matcher == null) {
            JTableHeaderLocation.$$$reportNull$$$0(10);
        }
        int size = this.columnCount(tableHeader);
        for (int i = 0; i < size; ++i) {
            if (!matcher.isMatching(this.columnName(tableHeader, i))) continue;
            return i;
        }
        return -1;
    }

    @RunsInCurrentThread
    private int columnCount(@Nonnull JTableHeader header) {
        if (header == null) {
            JTableHeaderLocation.$$$reportNull$$$0(11);
        }
        return header.getColumnModel().getColumnCount();
    }

    @RunsInCurrentThread
    private String columnName(@Nonnull JTableHeader tableHeader, int index) {
        if (tableHeader == null) {
            JTableHeaderLocation.$$$reportNull$$$0(12);
        }
        return tableHeader.getTable().getModel().getColumnName(index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableHeader";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTableHeaderLocation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTableHeaderLocation";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "point";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIndexInBounds";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "columnCount";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "columnName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

