/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.util.Pair;
import org.fest.util.Preconditions;

final class PointAndParentForScrollingJTextFieldQuery {
    @Nonnull
    @RunsInCurrentThread
    static Pair<Point, Container> pointAndParentForScrolling(@Nonnull JTextField textField) {
        Container parent;
        if (textField == null) {
            PointAndParentForScrollingJTextFieldQuery.$$$reportNull$$$0(0);
        }
        Point origin = new Point(textField.getX(), textField.getY());
        for (parent = textField.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
            origin = PointAndParentForScrollingJTextFieldQuery.addRectangleToPoint((Rectangle)Preconditions.checkNotNull((Object)parent.getBounds()), origin);
        }
        Pair<Point, Container> pair = Pair.of(origin, parent);
        if (pair == null) {
            PointAndParentForScrollingJTextFieldQuery.$$$reportNull$$$0(1);
        }
        return pair;
    }

    @Nonnull
    private static Point addRectangleToPoint(@Nonnull Rectangle r, @Nonnull Point p) {
        if (r == null) {
            PointAndParentForScrollingJTextFieldQuery.$$$reportNull$$$0(2);
        }
        if (p == null) {
            PointAndParentForScrollingJTextFieldQuery.$$$reportNull$$$0(3);
        }
        Point newPoint = new Point(p);
        newPoint.x += r.x;
        newPoint.y += r.y;
        Point point = newPoint;
        if (point == null) {
            PointAndParentForScrollingJTextFieldQuery.$$$reportNull$$$0(4);
        }
        return point;
    }

    private PointAndParentForScrollingJTextFieldQuery() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/PointAndParentForScrollingJTextFieldQuery";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/PointAndParentForScrollingJTextFieldQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAndParentForScrolling";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addRectangleToPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pointAndParentForScrolling";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRectangleToPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

