/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.util.Platform;

final class WindowLikeContainers {
    private static final int MAXIMIZE_BUTTON_OFFSET = Platform.isOSX() ? 25 : (Platform.isWindows() ? -20 : 0);

    @Nonnull
    @RunsInCurrentThread
    static Point closeButtonLocation(@Nonnull Container c) {
        if (c == null) {
            WindowLikeContainers.$$$reportNull$$$0(0);
        }
        Insets insets = c.getInsets();
        if (Platform.isOSX()) {
            Point point = new Point(insets.left + 15, insets.top / 2);
            if (point == null) {
                WindowLikeContainers.$$$reportNull$$$0(1);
            }
            return point;
        }
        Point point = new Point(c.getWidth() - insets.right - 10, insets.top / 2);
        if (point == null) {
            WindowLikeContainers.$$$reportNull$$$0(2);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    static Point maximizeButtonLocation(@Nonnull Container c) {
        if (c == null) {
            WindowLikeContainers.$$$reportNull$$$0(3);
        }
        Point p = WindowLikeContainers.iconifyButtonLocation(c);
        p.x += MAXIMIZE_BUTTON_OFFSET;
        Point point = p;
        if (point == null) {
            WindowLikeContainers.$$$reportNull$$$0(4);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    static Point iconifyButtonLocation(@Nonnull Container c) {
        if (c == null) {
            WindowLikeContainers.$$$reportNull$$$0(5);
        }
        Insets insets = c.getInsets();
        Point p = new Point();
        p.y = insets.top / 2;
        if (Platform.isOSX()) {
            p.x = 35;
        }
        if (Platform.isWindows()) {
            int offset = Platform.isWindowsXP() ? 64 : 45;
            p.x = c.getWidth() - insets.right - offset;
        }
        Point point = p;
        if (point == null) {
            WindowLikeContainers.$$$reportNull$$$0(6);
        }
        return point;
    }

    private WindowLikeContainers() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/WindowLikeContainers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/WindowLikeContainers";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "closeButtonLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "maximizeButtonLocation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "iconifyButtonLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "closeButtonLocation";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "maximizeButtonLocation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iconifyButtonLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

