/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.SwingUtilities;
import org.fest.swing.edt.GuiAction;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.UnexpectedException;
import org.fest.util.Throwables;

@ThreadSafe
public class GuiActionRunner {
    @GuardedBy(value="GuiActionRunner.class")
    private static boolean executeInEDT = true;

    public static synchronized void executeInEDT(boolean b) {
        executeInEDT = b;
    }

    public static synchronized boolean executeInEDT() {
        return executeInEDT;
    }

    @Nullable
    public static <T> T execute(@Nonnull GuiQuery<T> query) {
        if (query == null) {
            GuiActionRunner.$$$reportNull$$$0(0);
        }
        if (!GuiActionRunner.executeInEDT()) {
            return GuiActionRunner.executeInCurrentThread(query);
        }
        GuiActionRunner.run(query);
        return GuiActionRunner.resultOf(query);
    }

    @Nullable
    private static <T> T executeInCurrentThread(@Nonnull GuiQuery<T> query) {
        if (query == null) {
            GuiActionRunner.$$$reportNull$$$0(1);
        }
        try {
            return query.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    public static void execute(@Nonnull GuiTask task) {
        if (task == null) {
            GuiActionRunner.$$$reportNull$$$0(2);
        }
        if (!GuiActionRunner.executeInEDT()) {
            GuiActionRunner.executeInCurrentThread(task);
            return;
        }
        GuiActionRunner.run(task);
        GuiActionRunner.rethrowCaughtExceptionIn(task);
    }

    private static void executeInCurrentThread(@Nonnull GuiTask task) {
        if (task == null) {
            GuiActionRunner.$$$reportNull$$$0(3);
        }
        try {
            task.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    private static void run(@Nonnull GuiAction action) {
        if (action == null) {
            GuiActionRunner.$$$reportNull$$$0(4);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        action.executionNotification(latch);
        SwingUtilities.invokeLater(action);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    private static <T> T resultOf(@Nonnull GuiQuery<T> query) {
        if (query == null) {
            GuiActionRunner.$$$reportNull$$$0(5);
        }
        T result = query.result();
        query.clearResult();
        GuiActionRunner.rethrowCaughtExceptionIn(query);
        return result;
    }

    private static void rethrowCaughtExceptionIn(@Nonnull GuiAction action) {
        if (action == null) {
            GuiActionRunner.$$$reportNull$$$0(6);
        }
        Throwable caughtException = action.catchedException();
        action.clearCaughtException();
        if (caughtException == null) {
            return;
        }
        if (caughtException instanceof RuntimeException) {
            Throwables.appendStackTraceInCurentThreadToThrowable((Throwable)caughtException, (String)"execute");
            throw (RuntimeException)caughtException;
        }
        if (caughtException instanceof Error) {
            caughtException.fillInStackTrace();
            throw (Error)caughtException;
        }
        throw UnexpectedException.unexpected(caughtException);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/edt/GuiActionRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCurrentThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resultOf";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "rethrowCaughtExceptionIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

