/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.fest.assertions.Description;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.JTableDriver;
import org.fest.swing.fixture.AbstractJPopupMenuInvokerFixture;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTableCellFixture;
import org.fest.swing.fixture.JTableHeaderFixture;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class JTableFixture
extends AbstractJPopupMenuInvokerFixture<JTableFixture, JTable, JTableDriver> {
    public JTableFixture(@Nonnull Robot robot, @Nonnull JTable target) {
        if (robot == null) {
            JTableFixture.$$$reportNull$$$0(0);
        }
        if (target == null) {
            JTableFixture.$$$reportNull$$$0(1);
        }
        super(JTableFixture.class, robot, target);
    }

    public JTableFixture(@Nonnull Robot robot, @Nullable String tableName) {
        if (robot == null) {
            JTableFixture.$$$reportNull$$$0(2);
        }
        super(JTableFixture.class, robot, tableName, JTable.class);
    }

    @Override
    @Nonnull
    protected JTableDriver createDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JTableFixture.$$$reportNull$$$0(3);
        }
        JTableDriver jTableDriver = new JTableDriver(robot);
        if (jTableDriver == null) {
            JTableFixture.$$$reportNull$$$0(4);
        }
        return jTableDriver;
    }

    public FontFixture fontAt(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(5);
        }
        Font font = ((JTableDriver)this.driver()).font((JTable)this.target(), cell);
        return new FontFixture((Font)Preconditions.checkNotNull((Object)font), this.cellProperty(cell, "font"));
    }

    @Nonnull
    public ColorFixture backgroundAt(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(6);
        }
        Color background = ((JTableDriver)this.driver()).background((JTable)this.target(), cell);
        ColorFixture colorFixture = new ColorFixture((Color)Preconditions.checkNotNull((Object)background), this.cellProperty(cell, "background"));
        if (colorFixture == null) {
            JTableFixture.$$$reportNull$$$0(7);
        }
        return colorFixture;
    }

    @Nonnull
    public ColorFixture foregroundAt(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(8);
        }
        Color foreground = ((JTableDriver)this.driver()).foreground((JTable)this.target(), cell);
        ColorFixture colorFixture = new ColorFixture((Color)Preconditions.checkNotNull((Object)foreground), this.cellProperty(cell, "foreground"));
        if (colorFixture == null) {
            JTableFixture.$$$reportNull$$$0(9);
        }
        return colorFixture;
    }

    @Nonnull
    private Description cellProperty(TableCell cell, String propertyName) {
        Description description = ComponentDriver.propertyName(this.target(), Strings.concat((Object[])new Object[]{propertyName, " ", cell}));
        if (description == null) {
            JTableFixture.$$$reportNull$$$0(10);
        }
        return description;
    }

    @Nonnull
    public JTableCellFixture cell(String value) {
        TableCell cell = ((JTableDriver)this.driver()).cell((JTable)this.target(), value);
        JTableCellFixture jTableCellFixture = new JTableCellFixture(this, cell);
        if (jTableCellFixture == null) {
            JTableFixture.$$$reportNull$$$0(11);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture cell(@Nonnull Pattern valuePattern) {
        if (valuePattern == null) {
            JTableFixture.$$$reportNull$$$0(12);
        }
        TableCell cell = ((JTableDriver)this.driver()).cell((JTable)this.target(), valuePattern);
        JTableCellFixture jTableCellFixture = new JTableCellFixture(this, cell);
        if (jTableCellFixture == null) {
            JTableFixture.$$$reportNull$$$0(13);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture cell(@Nonnull TableCellFinder cellFinder) {
        if (cellFinder == null) {
            JTableFixture.$$$reportNull$$$0(14);
        }
        TableCell cell = ((JTableDriver)this.driver()).cell((JTable)this.target(), cellFinder);
        JTableCellFixture jTableCellFixture = new JTableCellFixture(this, cell);
        if (jTableCellFixture == null) {
            JTableFixture.$$$reportNull$$$0(15);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableCellFixture cell(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(16);
        }
        ((JTableDriver)this.driver()).checkCellIndicesInBounds((JTable)this.target(), cell);
        JTableCellFixture jTableCellFixture = new JTableCellFixture(this, cell);
        if (jTableCellFixture == null) {
            JTableFixture.$$$reportNull$$$0(17);
        }
        return jTableCellFixture;
    }

    @Nonnull
    public JTableHeaderFixture tableHeader() {
        JTableHeader tableHeader = ((JTableDriver)this.driver()).tableHeaderOf((JTable)this.target());
        JTableHeaderFixture jTableHeaderFixture = new JTableHeaderFixture(this.robot(), (JTableHeader)Preconditions.checkNotNull((Object)tableHeader));
        if (jTableHeaderFixture == null) {
            JTableFixture.$$$reportNull$$$0(18);
        }
        return jTableHeaderFixture;
    }

    @Nullable
    public String selectionValue() {
        return ((JTableDriver)this.driver()).selectionValue((JTable)this.target());
    }

    @Nonnull
    public Point pointAt(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(19);
        }
        Point point = ((JTableDriver)this.driver()).pointAt((JTable)this.target(), cell);
        if (point == null) {
            JTableFixture.$$$reportNull$$$0(20);
        }
        return point;
    }

    @Nonnull
    public String[][] contents() {
        String[][] stringArray = ((JTableDriver)this.driver()).contents((JTable)this.target());
        if (stringArray == null) {
            JTableFixture.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    public int rowCount() {
        return ((JTableDriver)this.driver()).rowCountOf((JTable)this.target());
    }

    @Nullable
    public String valueAt(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(22);
        }
        return ((JTableDriver)this.driver()).value((JTable)this.target(), cell);
    }

    @Nonnull
    public JTableFixture selectCell(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(23);
        }
        ((JTableDriver)this.driver()).selectCell((JTable)this.target(), cell);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(24);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture selectCells(TableCell ... cells) {
        if (cells == null) {
            JTableFixture.$$$reportNull$$$0(25);
        }
        ((JTableDriver)this.driver()).selectCells((JTable)this.target(), cells);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(26);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture selectRows(int ... rows) {
        if (rows == null) {
            JTableFixture.$$$reportNull$$$0(27);
        }
        ((JTableDriver)this.driver()).selectRows((JTable)this.target(), rows);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(28);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture drag(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(29);
        }
        ((JTableDriver)this.driver()).drag((JTable)this.target(), cell);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(30);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture drop(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(31);
        }
        ((JTableDriver)this.driver()).drop((JTable)this.target(), cell);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(32);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture click(@Nonnull TableCell cell, @Nonnull MouseButton button) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(33);
        }
        if (button == null) {
            JTableFixture.$$$reportNull$$$0(34);
        }
        this.click(cell, button, 1);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(35);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture click(@Nonnull TableCell cell, @Nonnull MouseClickInfo mouseClickInfo) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(36);
        }
        if (mouseClickInfo == null) {
            JTableFixture.$$$reportNull$$$0(37);
        }
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.click(cell, mouseClickInfo.button(), mouseClickInfo.times());
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(38);
        }
        return jTableFixture;
    }

    void click(@Nonnull TableCell cell, @Nonnull MouseButton button, int times) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(39);
        }
        if (button == null) {
            JTableFixture.$$$reportNull$$$0(40);
        }
        ((JTableDriver)this.driver()).click((JTable)this.target(), cell, button, times);
    }

    @Nonnull
    public JTableFixture enterValue(@Nonnull TableCell cell, @Nonnull String value) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(41);
        }
        if (value == null) {
            JTableFixture.$$$reportNull$$$0(42);
        }
        ((JTableDriver)this.driver()).enterValueInCell((JTable)this.target(), cell, value);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(43);
        }
        return jTableFixture;
    }

    public void replaceCellReader(@Nonnull JTableCellReader cellReader) {
        if (cellReader == null) {
            JTableFixture.$$$reportNull$$$0(44);
        }
        ((JTableDriver)this.driver()).replaceCellReader(cellReader);
    }

    @Nonnull
    public JTableFixture requireRowCount(int expected) {
        ((JTableDriver)this.driver()).requireRowCount((JTable)this.target(), expected);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(45);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireSelectedRows(int ... rows) {
        if (rows == null) {
            JTableFixture.$$$reportNull$$$0(46);
        }
        ((JTableDriver)this.driver()).requireSelectedRows((JTable)this.target(), rows);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(47);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireColumnCount(int expected) {
        ((JTableDriver)this.driver()).requireColumnCount((JTable)this.target(), expected);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(48);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireEditable(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(49);
        }
        ((JTableDriver)this.driver()).requireEditable((JTable)this.target(), cell);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(50);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireNotEditable(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(51);
        }
        ((JTableDriver)this.driver()).requireNotEditable((JTable)this.target(), cell);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(52);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireNoSelection() {
        ((JTableDriver)this.driver()).requireNoSelection((JTable)this.target());
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(53);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireCellValue(@Nonnull TableCell cell, @Nullable String value) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(54);
        }
        ((JTableDriver)this.driver()).requireCellValue((JTable)this.target(), cell, value);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(55);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireCellValue(@Nonnull TableCell cell, @Nonnull Pattern pattern) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(56);
        }
        if (pattern == null) {
            JTableFixture.$$$reportNull$$$0(57);
        }
        ((JTableDriver)this.driver()).requireCellValue((JTable)this.target(), cell, pattern);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(58);
        }
        return jTableFixture;
    }

    @Nonnull
    public JTableFixture requireContents(@Nonnull String[][] contents) {
        if (contents == null) {
            JTableFixture.$$$reportNull$$$0(59);
        }
        ((JTableDriver)this.driver()).requireContents((JTable)this.target(), contents);
        JTableFixture jTableFixture = this;
        if (jTableFixture == null) {
            JTableFixture.$$$reportNull$$$0(60);
        }
        return jTableFixture;
    }

    public void replaceCellWriter(JTableCellWriter cellWriter) {
        ((JTableDriver)this.driver()).replaceCellWriter(cellWriter);
    }

    public int columnIndexFor(@Nonnull Object columnName) {
        if (columnName == null) {
            JTableFixture.$$$reportNull$$$0(61);
        }
        return ((JTableDriver)this.driver()).columnIndex((JTable)this.target(), columnName);
    }

    @Nonnull
    public JPopupMenuFixture showPopupMenuAt(@Nonnull TableCell cell) {
        if (cell == null) {
            JTableFixture.$$$reportNull$$$0(62);
        }
        JPopupMenuFixture jPopupMenuFixture = new JPopupMenuFixture(this.robot(), ((JTableDriver)this.driver()).showPopupMenuAt((JTable)this.target(), cell));
        if (jPopupMenuFixture == null) {
            JTableFixture.$$$reportNull$$$0(63);
        }
        return jPopupMenuFixture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 55: 
            case 58: 
            case 60: 
            case 63: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 55: 
            case 58: 
            case 60: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 55: 
            case 58: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/fixture/JTableFixture";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellFinder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cells";
                break;
            }
            case 27: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseClickInfo";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/fixture/JTableFixture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriver";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundAt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundAt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cellProperty";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "cell";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "tableHeader";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "contents";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCell";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCells";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "selectRows";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "drag";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "drop";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "click";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "enterValue";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRowCount";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "requireSelectedRows";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "requireColumnCount";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "requireEditable";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotEditable";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNoSelection";
                break;
            }
            case 55: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "requireCellValue";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "requireContents";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupMenuAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 55: 
            case 58: 
            case 60: 
            case 63: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fontAt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "backgroundAt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "foregroundAt";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cell";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "valueAt";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectCell";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "selectCells";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "selectRows";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "drag";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "click";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "enterValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "replaceCellReader";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "requireSelectedRows";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "requireEditable";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "requireNotEditable";
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "requireCellValue";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "requireContents";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "columnIndexFor";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenuAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 55: 
            case 58: 
            case 60: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

