/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;
import org.fest.swing.hierarchy.ChildrenFinder;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ParentFinder;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.util.Lists;
import org.fest.util.VisibleForTesting;

public class ExistingHierarchy
implements ComponentHierarchy {
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    private final ParentFinder parentFinder;
    private final ChildrenFinder childrenFinder;

    public ExistingHierarchy() {
        this(new ParentFinder(), new ChildrenFinder());
    }

    @VisibleForTesting
    ExistingHierarchy(@Nonnull ParentFinder parentFinder, @Nonnull ChildrenFinder childrenFinder) {
        if (parentFinder == null) {
            ExistingHierarchy.$$$reportNull$$$0(0);
        }
        if (childrenFinder == null) {
            ExistingHierarchy.$$$reportNull$$$0(1);
        }
        this.parentFinder = parentFinder;
        this.childrenFinder = childrenFinder;
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        ArrayList roots = Lists.newArrayList();
        for (Window w : windowMonitor.rootWindows()) {
            roots.add(w);
        }
        ArrayList arrayList = roots;
        if (arrayList == null) {
            ExistingHierarchy.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @RunsInCurrentThread
    public Container parentOf(@Nonnull Component c) {
        if (c == null) {
            ExistingHierarchy.$$$reportNull$$$0(3);
        }
        return this.parentFinder.parentOf(c);
    }

    @Override
    public boolean contains(@Nonnull Component c) {
        if (c == null) {
            ExistingHierarchy.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> childrenOf(@Nonnull Component c) {
        if (c == null) {
            ExistingHierarchy.$$$reportNull$$$0(5);
        }
        Collection<Component> collection = this.childrenFinder.childrenOf(c);
        if (collection == null) {
            ExistingHierarchy.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    @RunsInCurrentThread
    public void dispose(@Nonnull Window w) {
        if (w == null) {
            ExistingHierarchy.$$$reportNull$$$0(7);
        }
        if (AWT.isAppletViewer(w)) {
            return;
        }
        for (Window owned : w.getOwnedWindows()) {
            if (owned == null) continue;
            this.dispose(owned);
        }
        if (AWT.isSharedInvisibleFrame(w)) {
            return;
        }
        w.dispose();
    }

    @Nonnull
    ParentFinder parentFinder() {
        ParentFinder parentFinder = this.parentFinder;
        if (parentFinder == null) {
            ExistingHierarchy.$$$reportNull$$$0(8);
        }
        return parentFinder;
    }

    @Nonnull
    ChildrenFinder childrenFinder() {
        ChildrenFinder childrenFinder = this.childrenFinder;
        if (childrenFinder == null) {
            ExistingHierarchy.$$$reportNull$$$0(9);
        }
        return childrenFinder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFinder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenFinder";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/hierarchy/ExistingHierarchy";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/hierarchy/ExistingHierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "roots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOf";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parentFinder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parentOf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "childrenOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

