/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.hierarchy.IgnoreWindowTask;
import org.fest.swing.hierarchy.WindowFilter;
import org.fest.swing.util.AWTEvents;
import org.fest.util.Preconditions;

public final class TransientWindowListener
implements AWTEventListener {
    private final WindowFilter filter;

    TransientWindowListener(@Nonnull WindowFilter filter) {
        if (filter == null) {
            TransientWindowListener.$$$reportNull$$$0(0);
        }
        this.filter = filter;
    }

    @Override
    @RunsInEDT
    public void eventDispatched(AWTEvent event) {
        AWTEvent e = (AWTEvent)Preconditions.checkNotNull((Object)event);
        if (AWTEvents.wasWindowOpened(e) || AWTEvents.wasWindowShown(e)) {
            Window w = this.sourceOf(e);
            if (w != null) {
                this.filter(w);
            }
            return;
        }
        if (AWTEvents.wasWindowClosed(e)) {
            Window w = this.sourceOf(e);
            if (w == null) {
                return;
            }
            if (this.filter.isIgnored(w)) {
                return;
            }
            this.filter.implicitlyIgnore(w);
            SwingUtilities.invokeLater(new IgnoreWindowTask(w, this.filter));
        }
    }

    @Nullable
    private Window sourceOf(@Nonnull AWTEvent e) {
        if (e == null) {
            TransientWindowListener.$$$reportNull$$$0(1);
        }
        return (Window)e.getSource();
    }

    private void filter(@Nonnull Window w) {
        if (w == null) {
            TransientWindowListener.$$$reportNull$$$0(2);
        }
        if (this.filter.isImplicitlyIgnored(w)) {
            this.filter.recognize(w);
            return;
        }
        this.filterIfParentIsFiltered(w);
    }

    private void filterIfParentIsFiltered(@Nonnull Window w) {
        if (w == null) {
            TransientWindowListener.$$$reportNull$$$0(3);
        }
        if (!this.filter.isIgnored(w.getParent())) {
            return;
        }
        this.filter.ignore(w);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/hierarchy/TransientWindowListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sourceOf";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filterIfParentIsFiltered";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

