/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.lang.reflect.Array;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Objects;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.SystemProperties;

public final class Arrays {
    private static final String NO_COLUMNS = "[[]]";
    private static final String NO_ROWS = "[]";
    private static final String NULL = "null";

    public static boolean equal(@Nullable String[][] one, @Nullable String[][] two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.length != two.length) {
            return false;
        }
        if (one.length == 0) {
            return true;
        }
        if (one[0].length != two[0].length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            for (int j = 0; j < one[i].length; ++j) {
                if (Objects.areEqual((Object)one[i][j], (Object)two[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public static String format(@Nullable String[][] array) {
        if (array == null) {
            if (NULL == null) {
                Arrays.$$$reportNull$$$0(0);
            }
            return NULL;
        }
        int size = array.length;
        if (size == 0) {
            if (NO_ROWS == null) {
                Arrays.$$$reportNull$$$0(1);
            }
            return NO_ROWS;
        }
        if (array[0].length == 0) {
            if (NO_COLUMNS == null) {
                Arrays.$$$reportNull$$$0(2);
            }
            return NO_COLUMNS;
        }
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                b.append(SystemProperties.lineSeparator()).append(" ");
            }
            Arrays.addLine(array[i], b);
            if (i == size - 1) continue;
            b.append(",");
        }
        b.append("]");
        String string = b.toString();
        if (string == null) {
            Arrays.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void addLine(@Nullable String[] line, @Nonnull StringBuilder b) {
        if (b == null) {
            Arrays.$$$reportNull$$$0(4);
        }
        if (line == null) {
            b.append(NULL);
            return;
        }
        int lineSize = line.length;
        b.append("[");
        for (int i = 0; i < lineSize; ++i) {
            b.append(Strings.quote((String)line[i]));
            if (i == lineSize - 1) continue;
            b.append(", ");
        }
        b.append("]");
    }

    @Nonnull
    public static int[] copyOf(@Nonnull int[] array) {
        if (array == null) {
            Arrays.$$$reportNull$$$0(5);
        }
        Preconditions.checkNotNull((Object)array);
        int arraySize = array.length;
        int[] copy = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        if (copy == null) {
            Arrays.$$$reportNull$$$0(6);
        }
        return copy;
    }

    public static <T> T[] copyOf(@Nonnull T[] array) {
        if (array == null) {
            Arrays.$$$reportNull$$$0(7);
        }
        Preconditions.checkNotNull(array);
        int arraySize = array.length;
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), arraySize);
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    private Arrays() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/util/Arrays";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/util/Arrays";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyOf";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLine";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

