/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenArtifactCoordinatesArtifactIdConverter
extends MavenArtifactCoordinatesConverter {
    @Override
    protected boolean doIsValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId())) {
            return false;
        }
        if (manager.hasArtifactId(id.getGroupId(), id.getArtifactId())) {
            return true;
        }
        MavenProject mavenProject = this.findMavenProject(context);
        if (mavenProject != null) {
            for (MavenArtifact artifact : mavenProject.findDependencies(id.getGroupId(), id.getArtifactId())) {
                if (!artifact.isResolved()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public LookupElement createLookupElement(String s) {
        LookupElementBuilder res = LookupElementBuilder.create((String)s);
        res = res.withInsertHandler(MavenArtifactInsertHandler.INSTANCE);
        return res;
    }

    @Override
    protected Set<String> doGetVariants(MavenId id, MavenProjectIndicesManager manager) {
        if (StringUtil.isEmptyOrSpaces((String)id.getGroupId())) {
            return Collections.emptySet();
        }
        return manager.getArtifactIds(id.getGroupId());
    }

    private static class MavenArtifactInsertHandler
    implements InsertHandler<LookupElement> {
        public static final InsertHandler<LookupElement> INSTANCE = new MavenArtifactInsertHandler();

        private MavenArtifactInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            if (TemplateManager.getInstance((Project)context.getProject()).getActiveTemplate(context.getEditor()) != null) {
                return;
            }
            context.commitDocument();
            PsiFile contextFile = context.getFile();
            if (!(contextFile instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)contextFile;
            PsiElement element = xmlFile.findElementAt(context.getStartOffset());
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag == null) {
                return;
            }
            XmlTag dependencyTag = tag.getParentTag();
            DomElement domElement = DomManager.getDomManager((Project)context.getProject()).getDomElement(dependencyTag);
            if (!(domElement instanceof MavenDomDependency)) {
                return;
            }
            MavenDomDependency dependency = (MavenDomDependency)domElement;
            String artifactId = item.getLookupString();
            String groupId = dependency.getGroupId().getStringValue();
            if (StringUtil.isEmpty((String)groupId)) {
                String g = MavenArtifactInsertHandler.getUniqueGroupIdOrNull(context.getProject(), artifactId);
                if (g != null) {
                    dependency.getGroupId().setStringValue(g);
                    groupId = g;
                } else {
                    if (groupId == null) {
                        dependency.getGroupId().setStringValue("");
                    }
                    XmlTag groupIdTag = dependency.getGroupId().getXmlTag();
                    context.getEditor().getCaretModel().moveToOffset(groupIdTag.getValue().getTextRange().getStartOffset());
                    MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.SMART);
                    return;
                }
            }
            MavenDependencyCompletionUtil.addTypeAndClassifierAndVersion(context, dependency, groupId, artifactId);
        }

        private static String getUniqueGroupIdOrNull(@NotNull Project project, @NotNull String artifactId) {
            if (project == null) {
                MavenArtifactInsertHandler.$$$reportNull$$$0(0);
            }
            if (artifactId == null) {
                MavenArtifactInsertHandler.$$$reportNull$$$0(1);
            }
            MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(project);
            String res = null;
            for (String groupId : manager.getGroupIds()) {
                if (!manager.getArtifactIds(groupId).contains(artifactId)) continue;
                if (res == null) {
                    res = groupId;
                    continue;
                }
                return null;
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifactId";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesArtifactIdConverter$MavenArtifactInsertHandler";
            objectArray[2] = "getUniqueGroupIdOrNull";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

