/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CodeCompletionPanel {
    JPanel myPanel;
    private JCheckBox myCbAutocompletion;
    private JCheckBox myCbAutopopupJavaDoc;
    private JTextField myAutopopupJavaDocField;
    private JLabel myAutoInsertLabel;
    private JCheckBox myCbOnCodeCompletion;
    private JCheckBox myCbOnSmartTypeCompletion;
    private JCheckBox myCbParameterInfoPopup;
    private JTextField myParameterInfoDelayField;
    private JCheckBox myCbShowFullParameterSignatures;
    private JComboBox myCaseSensitiveCombo;
    private JCheckBox myCbSorting;
    private JBCheckBox myCbSelectByChars;
    private JCheckBox myCbCompleteFunctionWithParameters;
    private static final String CASE_SENSITIVE_ALL = ApplicationBundle.message((String)"combobox.autocomplete.case.sensitive.all", (Object[])new Object[0]);
    private static final String CASE_SENSITIVE_NONE = ApplicationBundle.message((String)"combobox.autocomplete.case.sensitive.none", (Object[])new Object[0]);
    private static final String CASE_SENSITIVE_FIRST_LETTER = ApplicationBundle.message((String)"combobox.autocomplete.case.sensitive.first.letter", (Object[])new Object[0]);
    private static final String[] CASE_VARIANTS = new String[]{CASE_SENSITIVE_ALL, CASE_SENSITIVE_NONE, CASE_SENSITIVE_FIRST_LETTER};

    public CodeCompletionPanel() {
        this.$$$setupUI$$$();
        this.myCaseSensitiveCombo.setModel(new DefaultComboBoxModel<String>(CASE_VARIANTS));
        ActionManager actionManager = ActionManager.getInstance();
        String basicShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("CodeCompletion"));
        String smartShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("SmartTypeCompletion"));
        if (StringUtil.isNotEmpty((String)basicShortcut)) {
            this.myCbOnCodeCompletion.setText(this.myCbOnCodeCompletion.getText() + " ( " + basicShortcut + " )");
        }
        if (StringUtil.isNotEmpty((String)smartShortcut)) {
            this.myCbOnSmartTypeCompletion.setText(this.myCbOnSmartTypeCompletion.getText() + " ( " + smartShortcut + " )");
        }
        this.myCbAutocompletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean selected = CodeCompletionPanel.this.myCbAutocompletion.isSelected();
                CodeCompletionPanel.this.myCbSelectByChars.setEnabled(selected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$1", "actionPerformed"));
            }
        });
        this.myCbAutopopupJavaDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CodeCompletionPanel.this.myAutopopupJavaDocField.setEnabled(CodeCompletionPanel.this.myCbAutopopupJavaDoc.isSelected());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$2", "actionPerformed"));
            }
        });
        this.myCbParameterInfoPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                CodeCompletionPanel.this.myParameterInfoDelayField.setEnabled(CodeCompletionPanel.this.myCbParameterInfoPopup.isSelected());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$3", "actionPerformed"));
            }
        });
        CodeCompletionPanel.hideOption(this.myCbOnSmartTypeCompletion, OptionId.COMPLETION_SMART_TYPE);
        CodeCompletionPanel.hideOption(this.myCbOnCodeCompletion, OptionId.AUTOCOMPLETE_ON_BASIC_CODE_COMPLETION);
        if (!this.myCbOnSmartTypeCompletion.isVisible() && !this.myCbOnCodeCompletion.isVisible()) {
            this.myAutoInsertLabel.setVisible(false);
        }
        this.reset();
    }

    private static void hideOption(JComponent component, OptionId id) {
        component.setVisible(OptionsApplicabilityFilter.isApplicable(id));
    }

    public void reset() {
        String value2;
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        switch (codeInsightSettings.COMPLETION_CASE_SENSITIVE) {
            case 1: {
                value2 = CASE_SENSITIVE_ALL;
                break;
            }
            case 2: {
                value2 = CASE_SENSITIVE_NONE;
                break;
            }
            default: {
                value2 = CASE_SENSITIVE_FIRST_LETTER;
            }
        }
        this.myCaseSensitiveCombo.setSelectedItem(value2);
        this.myCbSelectByChars.setSelected(codeInsightSettings.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS);
        this.myCbOnCodeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        this.myCbOnSmartTypeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        this.myCbAutopopupJavaDoc.setSelected(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setEnabled(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setText(String.valueOf(codeInsightSettings.JAVADOC_INFO_DELAY));
        this.myCbParameterInfoPopup.setSelected(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setEnabled(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setText(String.valueOf(codeInsightSettings.PARAMETER_INFO_DELAY));
        this.myCbShowFullParameterSignatures.setSelected(codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        this.myCbCompleteFunctionWithParameters.setSelected(codeInsightSettings.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        this.myCbSorting.setSelected(UISettings.getInstance().getSortLookupElementsLexicographically());
        this.myCbAutocompletion.setText(ApplicationBundle.message((String)"editbox.auto.complete", (Object[])new Object[0]) + (PowerSaveMode.isEnabled() ? " (not available in Power Save mode)" : ""));
    }

    public void apply() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        codeInsightSettings.COMPLETION_CASE_SENSITIVE = this.getCaseSensitiveValue();
        codeInsightSettings.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS = this.myCbSelectByChars.isSelected();
        codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION = this.myCbOnCodeCompletion.isSelected();
        codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = this.myCbOnSmartTypeCompletion.isSelected();
        codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO = this.myCbShowFullParameterSignatures.isSelected();
        codeInsightSettings.AUTO_POPUP_PARAMETER_INFO = this.myCbParameterInfoPopup.isSelected();
        codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP = this.myCbAutocompletion.isSelected();
        codeInsightSettings.AUTO_POPUP_JAVADOC_INFO = this.myCbAutopopupJavaDoc.isSelected();
        codeInsightSettings.PARAMETER_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myParameterInfoDelayField.getText(), 0);
        codeInsightSettings.JAVADOC_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myAutopopupJavaDocField.getText(), 0);
        codeInsightSettings.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION = this.myCbCompleteFunctionWithParameters.isSelected();
        UISettings.getInstance().setSortLookupElementsLexicographically(this.myCbSorting.isSelected());
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myPanel));
        if (project2 != null) {
            DaemonCodeAnalyzer.getInstance((Project)project2).settingsChanged();
        }
    }

    public boolean isModified() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        boolean isModified = false;
        isModified |= this.getCaseSensitiveValue() != codeInsightSettings.COMPLETION_CASE_SENSITIVE;
        isModified |= CodeCompletionPanel.isModified(this.myCbOnCodeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified((JCheckBox)this.myCbSelectByChars, codeInsightSettings.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS);
        isModified |= CodeCompletionPanel.isModified(this.myCbOnSmartTypeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbShowFullParameterSignatures, codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbParameterInfoPopup, codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutocompletion, codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        isModified |= CodeCompletionPanel.isModified(this.myCbCompleteFunctionWithParameters, codeInsightSettings.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutopopupJavaDoc, codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myParameterInfoDelayField, codeInsightSettings.PARAMETER_INFO_DELAY, 0);
        isModified |= CodeCompletionPanel.isModified(this.myAutopopupJavaDocField, codeInsightSettings.JAVADOC_INFO_DELAY, 0);
        return isModified |= CodeCompletionPanel.isModified(this.myCbSorting, UISettings.getInstance().getSortLookupElementsLexicographically());
    }

    private static boolean isModified(JCheckBox checkBox, boolean value2) {
        return checkBox.isSelected() != value2;
    }

    private static boolean isModified(JTextField textField2, int value2, int defaultValue) {
        return CodeCompletionPanel.getIntegerValue(textField2.getText(), defaultValue) != value2;
    }

    private static int getIntegerValue(String s, int defaultValue) {
        int value2 = StringUtilRt.parseInt((String)s, (int)defaultValue);
        return value2 < 0 ? defaultValue : value2;
    }

    private int getCaseSensitiveValue() {
        Object value2 = this.myCaseSensitiveCombo.getSelectedItem();
        if (CASE_SENSITIVE_ALL.equals(value2)) {
            return 1;
        }
        if (CASE_SENSITIVE_NONE.equals(value2)) {
            return 2;
        }
        return 3;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JBCheckBox jBCheckBox;
        JTextField jTextField2;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JLabel jLabel;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.code.completion"), (int)0, (int)0, null, null));
        this.myCbOnCodeCompletion = jCheckBox8 = new JCheckBox();
        jCheckBox8.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.basic"));
        jPanel3.add((Component)jCheckBox8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCbOnSmartTypeCompletion = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.autocomplete.smart.type"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCbSorting = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(2, 2, 2, 2));
        jCheckBox6.setText("Sort lookup items lexicographically");
        jPanel3.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myAutoInsertLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.autocomplete.when.only.one.choice"));
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbAutocompletion = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.auto.complete"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setEnabled(true);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("For explicitly invoked completion");
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbAutopopupJavaDoc = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.autopopup.javadoc.in"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel5.add((Component)jCheckBox4, gridBagConstraints);
        this.myAutopopupJavaDocField = jTextField2 = new JTextField();
        jTextField2.setColumns(4);
        jTextField2.setText("1000");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        jPanel5.add((Component)jTextField2, gridBagConstraints2);
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.ms"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        jPanel5.add((Component)jBLabel2, gridBagConstraints3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(7, 0, 1, 1, 0, 3, 0, 0, new Dimension(-1, 4), null, null));
        this.myCbSelectByChars = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Insert selected variant by typing dot, space, etc.");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 8, 2, 1, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.case.sensitive.completion"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.anchor = 17;
        jPanel7.add((Component)jLabel2, gridBagConstraints4);
        this.myCaseSensitiveCombo = jComboBox = new JComboBox();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 5, 0, 0);
        jPanel7.add(jComboBox, gridBagConstraints5);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.parameter.info"), (int)0, (int)0, null, null));
        this.myCbShowFullParameterSignatures = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.full.signatures"));
        jPanel8.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(186, 22), null));
        this.myCbCompleteFunctionWithParameters = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.complete.with.parameters"));
        jPanel8.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(186, 22), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        jPanel8.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbParameterInfoPopup = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.autopopup.in"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.anchor = 17;
        jPanel9.add((Component)jCheckBox, gridBagConstraints6);
        this.myParameterInfoDelayField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jTextField.setText("1000");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
        jPanel9.add((Component)jTextField, gridBagConstraints7);
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.ms"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 2;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.anchor = 17;
        jPanel9.add((Component)jBLabel3, gridBagConstraints8);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

