/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesControl;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRuleManager {
    private static final Set<ArrangementSettingsToken> MUTEXES = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION});
    private static final Set<ArrangementSettingsToken> TOKENS = ContainerUtilRt.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION, StdArrangementTokens.Regexp.TEXT});
    private Commenter myCommenter;
    private ArrangementSectionRulesControl myControl;
    private ArrangementMatchingRuleEditor myEditor;

    @Nullable
    public static ArrangementSectionRuleManager getInstance(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        if (language == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(0);
        }
        if (settingsManager == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(1);
        }
        if (colorsProvider == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(2);
        }
        if (control == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(3);
        }
        if (settingsManager.isSectionRulesSupported()) {
            return new ArrangementSectionRuleManager(language, settingsManager, colorsProvider, control);
        }
        return null;
    }

    private ArrangementSectionRuleManager(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        if (language == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(4);
        }
        if (settingsManager == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(5);
        }
        if (colorsProvider == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(6);
        }
        if (control == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(7);
        }
        this.myCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        this.myControl = control;
        ArrayList tokens = ContainerUtil.newArrayList();
        tokens.add(new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, (Collection)ContainerUtil.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION})));
        tokens.add(new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT));
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, tokens, colorsProvider, control);
    }

    public ArrangementMatchingRuleEditor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public static Set<ArrangementSettingsToken> getSectionMutexes() {
        Set<ArrangementSettingsToken> set2 = MUTEXES;
        if (set2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(8);
        }
        return set2;
    }

    public static boolean isEnabled(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(9);
        }
        return TOKENS.contains(token);
    }

    public void showEditor(int rowToEdit) {
        this.myControl.showEditor(this.myEditor, rowToEdit);
    }

    public boolean isSectionRule(@Nullable Object element) {
        return element instanceof StdArrangementMatchRule && this.getSectionRuleData((StdArrangementMatchRule)element) != null;
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull StdArrangementMatchRule element) {
        if (element == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(10);
        }
        ArrangementMatchCondition condition2 = element.getMatcher().getCondition();
        return this.getSectionRuleData(condition2);
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull ArrangementMatchCondition condition2) {
        if (condition2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(11);
        }
        final Ref isStart = new Ref();
        final Ref text2 = new Ref();
        condition2.invite(new ArrangementMatchConditionVisitor(){

            public void visit(@NotNull ArrangementAtomMatchCondition condition2) {
                ArrangementSettingsToken type2;
                if (condition2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((type2 = condition2.getType()).equals((Object)StdArrangementTokens.Section.START_SECTION)) {
                    isStart.set((Object)true);
                } else if (type2.equals((Object)StdArrangementTokens.Section.END_SECTION)) {
                    isStart.set((Object)false);
                } else if (type2.equals((Object)StdArrangementTokens.Regexp.TEXT)) {
                    text2.set((Object)condition2.getValue().toString());
                }
            }

            public void visit(@NotNull ArrangementCompositeMatchCondition condition2) {
                if (condition2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (ArrangementMatchCondition c : condition2.getOperands()) {
                    c.invite((ArrangementMatchConditionVisitor)this);
                    if (text2.isNull() || isStart.isNull()) continue;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$1", "visit"));
            }
        });
        if (isStart.isNull()) {
            return null;
        }
        return new ArrangementSectionRuleData(this.processSectionText(StringUtil.notNullize((String)((String)text2.get()))), (Boolean)isStart.get());
    }

    @NotNull
    public StdArrangementMatchRule createDefaultSectionRule() {
        ArrangementAtomMatchCondition type2 = new ArrangementAtomMatchCondition(StdArrangementTokens.Section.START_SECTION);
        ArrangementAtomMatchCondition text2 = new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT, (Object)this.createDefaultSectionText());
        ArrangementMatchCondition condition2 = ArrangementUtil.combine((ArrangementMatchCondition[])new ArrangementMatchCondition[]{type2, text2});
        StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher(condition2));
        if (stdArrangementMatchRule == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(12);
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    private String processSectionText(@NotNull String text2) {
        String lineCommentPrefix;
        if (text2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(13);
        }
        if ((lineCommentPrefix = this.myCommenter.getLineCommentPrefix()) != null && text2.startsWith(lineCommentPrefix)) {
            String string = text2;
            if (string == null) {
                ArrangementSectionRuleManager.$$$reportNull$$$0(14);
            }
            return string;
        }
        String prefix = this.myCommenter.getBlockCommentPrefix();
        String suffix = this.myCommenter.getBlockCommentSuffix();
        if (prefix != null && suffix != null && text2.length() >= prefix.length() + suffix.length() && text2.startsWith(prefix) && text2.endsWith(suffix)) {
            String string = text2;
            if (string == null) {
                ArrangementSectionRuleManager.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = lineCommentPrefix != null ? ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, text2) : (prefix != null && suffix != null ? ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, text2) : "");
        if (string == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private String createDefaultSectionText() {
        if (this.myCommenter != null) {
            String lineCommentPrefix = this.myCommenter.getLineCommentPrefix();
            if (StringUtil.isNotEmpty((String)lineCommentPrefix)) {
                String string = ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, "");
                if (string == null) {
                    ArrangementSectionRuleManager.$$$reportNull$$$0(17);
                }
                return string;
            }
            String prefix = this.myCommenter.getBlockCommentPrefix();
            String suffix = this.myCommenter.getBlockCommentSuffix();
            if (StringUtil.isNotEmpty((String)prefix) && StringUtil.isNotEmpty((String)suffix)) {
                String string = ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, " ");
                if (string == null) {
                    ArrangementSectionRuleManager.$$$reportNull$$$0(18);
                }
                return string;
            }
        }
        if ("" == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(19);
        }
        return "";
    }

    private static String wrapIntoBlockComment(@NotNull String prefix, @NotNull String suffix, @NotNull String text2) {
        if (prefix == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(20);
        }
        if (suffix == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(22);
        }
        return prefix + text2 + suffix;
    }

    private static String wrapIntoLineComment(@NotNull String lineCommentPrefix, @NotNull String text2) {
        if (lineCommentPrefix == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(23);
        }
        if (text2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(24);
        }
        return lineCommentPrefix + text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 13: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCommentPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionMutexes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultSectionRule";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processSectionText";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultSectionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSectionRuleData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processSectionText";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "wrapIntoBlockComment";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "wrapIntoLineComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ArrangementSectionRuleData {
        private boolean myIsSectionStart;
        private String myText;

        private ArrangementSectionRuleData(@NotNull String text2, boolean isStart) {
            if (text2 == null) {
                ArrangementSectionRuleData.$$$reportNull$$$0(0);
            }
            this.myText = text2;
            this.myIsSectionStart = isStart;
        }

        public boolean isSectionStart() {
            return this.myIsSectionStart;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ArrangementSectionRuleData.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$ArrangementSectionRuleData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$ArrangementSectionRuleData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

