/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementConstants;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRulesControl
extends ArrangementMatchingRulesControl {
    @NotNull
    public static final DataKey<ArrangementSectionRulesControl> KEY = DataKey.create((String)"Arrangement.Rule.Match.Control");
    @NotNull
    private static final Logger LOG = Logger.getInstance(ArrangementSectionRulesControl.class);
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @Nullable
    private final ArrangementSectionRuleManager mySectionRuleManager;
    @Nullable
    private ArrangementStandardSettingsManager myExtendedSettingsManager;

    public ArrangementSectionRulesControl(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl.RepresentationCallback callback) {
        if (language == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(0);
        }
        if (settingsManager == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(1);
        }
        if (colorsProvider == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(3);
        }
        super(settingsManager, colorsProvider, callback);
        this.mySectionRuleManager = ArrangementSectionRuleManager.getInstance(language, settingsManager, colorsProvider, this);
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
    }

    private static void appendBufferedSectionRules(@NotNull List<ArrangementSectionRule> result2, @NotNull List<StdArrangementMatchRule> buffer, @Nullable String currentSectionStart) {
        if (result2 == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(4);
        }
        if (buffer == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(5);
        }
        if (currentSectionStart == null) {
            return;
        }
        if (buffer.isEmpty()) {
            result2.add(ArrangementSectionRule.create((String)currentSectionStart, null, (StdArrangementMatchRule[])new StdArrangementMatchRule[0]));
        } else {
            result2.add(ArrangementSectionRule.create((String)currentSectionStart, null, (StdArrangementMatchRule[])new StdArrangementMatchRule[]{buffer.get(0)}));
            for (int j = 1; j < buffer.size(); ++j) {
                result2.add(ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{buffer.get(j)}));
            }
            buffer.clear();
        }
    }

    @Override
    protected ArrangementMatchingRulesControl.MatchingRulesRendererBase createRender() {
        return new MatchingRulesRenderer();
    }

    @Override
    @NotNull
    protected ArrangementMatchingRulesValidator createValidator() {
        ArrangementSectionRulesValidator arrangementSectionRulesValidator = new ArrangementSectionRulesValidator(this.getModel(), this.mySectionRuleManager);
        if (arrangementSectionRulesValidator == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(6);
        }
        return arrangementSectionRulesValidator;
    }

    @Nullable
    public ArrangementSectionRuleManager getSectionRuleManager() {
        return this.mySectionRuleManager;
    }

    public List<ArrangementSectionRule> getSections() {
        if (this.getModel().getSize() <= 0) {
            return Collections.emptyList();
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        ArrayList buffer = ContainerUtil.newArrayList();
        String currentSectionStart = null;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ArrangementSectionRuleManager.ArrangementSectionRuleData sectionRule;
            Object element = this.getModel().getElementAt(i);
            if (!(element instanceof StdArrangementMatchRule)) continue;
            ArrangementSectionRuleManager.ArrangementSectionRuleData arrangementSectionRuleData = sectionRule = this.mySectionRuleManager == null ? null : this.mySectionRuleManager.getSectionRuleData((StdArrangementMatchRule)element);
            if (sectionRule != null) {
                if (sectionRule.isSectionStart()) {
                    ArrangementSectionRulesControl.appendBufferedSectionRules(result2, buffer, currentSectionStart);
                    currentSectionStart = sectionRule.getText();
                    continue;
                }
                result2.add(ArrangementSectionRule.create((String)StringUtil.notNullize(currentSectionStart), (String)sectionRule.getText(), (List)buffer));
                buffer.clear();
                currentSectionStart = null;
                continue;
            }
            if (currentSectionStart == null) {
                result2.add(ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{(StdArrangementMatchRule)element}));
                continue;
            }
            buffer.add((StdArrangementMatchRule)element);
        }
        ArrangementSectionRulesControl.appendBufferedSectionRules(result2, buffer, currentSectionStart);
        return result2;
    }

    public void setSections(@Nullable List<ArrangementSectionRule> sections) {
        List rules = sections == null ? null : ArrangementUtil.collectMatchRules(sections);
        this.myComponents.clear();
        this.getModel().clear();
        if (rules == null) {
            return;
        }
        for (StdArrangementMatchRule rule : rules) {
            this.getModel().add(rule);
        }
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info("Arrangement matching rules list is refreshed. Given rules:");
            for (StdArrangementMatchRule rule : rules) {
                LOG.info("  " + rule.toString());
            }
        }
    }

    @Nullable
    public Collection<StdArrangementRuleAliasToken> getRulesAliases() {
        return this.myExtendedSettingsManager == null ? null : this.myExtendedSettingsManager.getRuleAliases();
    }

    public void setRulesAliases(@Nullable Collection<StdArrangementRuleAliasToken> aliases) {
        if (aliases != null) {
            this.myExtendedSettingsManager = new ArrangementStandardSettingsManager(this.mySettingsManager.getDelegate(), this.myColorsProvider, aliases);
            this.myEditor = new ArrangementMatchingRuleEditor(this.myExtendedSettingsManager, this.myColorsProvider, this);
        }
    }

    @Override
    public void showEditor(int rowToEdit) {
        if (this.mySectionRuleManager != null && this.mySectionRuleManager.isSectionRule(this.getModel().getElementAt(rowToEdit))) {
            this.mySectionRuleManager.showEditor(rowToEdit);
        } else {
            super.showEditor(rowToEdit);
        }
    }

    @NotNull
    public ArrangementRuleAliasDialog createRuleAliasEditDialog() {
        THashSet tokenIds = new THashSet();
        List<ArrangementSectionRule> sections = this.getSections();
        for (ArrangementSectionRule section : sections) {
            for (StdArrangementMatchRule rule : section.getMatchRules()) {
                rule.getMatcher().getCondition().invite(new ArrangementMatchConditionVisitor((Set)tokenIds){
                    final /* synthetic */ Set val$tokenIds;
                    {
                        this.val$tokenIds = set2;
                    }

                    public void visit(@NotNull ArrangementAtomMatchCondition condition2) {
                        if (condition2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (ArrangementUtil.isAliasedCondition((ArrangementAtomMatchCondition)condition2)) {
                            this.val$tokenIds.add(condition2.getType().getId());
                        }
                    }

                    public void visit(@NotNull ArrangementCompositeMatchCondition condition2) {
                        if (condition2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        for (ArrangementMatchCondition operand2 : condition2.getOperands()) {
                            operand2.invite((ArrangementMatchConditionVisitor)this);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl$1", "visit"));
                    }
                });
            }
        }
        Collection<StdArrangementRuleAliasToken> aliases = this.getRulesAliases();
        assert (aliases != null);
        ArrangementRuleAliasDialog arrangementRuleAliasDialog = new ArrangementRuleAliasDialog(null, this.mySettingsManager, this.myColorsProvider, aliases, (Set<String>)tokenIds);
        if (arrangementRuleAliasDialog == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(7);
        }
        return arrangementRuleAliasDialog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRuleAliasEditDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendBufferedSectionRules";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MatchingRulesRenderer
    extends ArrangementMatchingRulesControl.MatchingRulesRendererBase {
        private MatchingRulesRenderer() {
        }

        @Override
        public boolean allowModifications(StdArrangementMatchRule rule) {
            return ArrangementSectionRulesControl.this.mySectionRuleManager == null || !ArrangementSectionRulesControl.this.mySectionRuleManager.isSectionRule(rule);
        }
    }
}

