/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtil {
    private static final Logger LOG = Logger.getInstance(CodeInsightUtil.class);

    @Nullable
    public static PsiExpression findExpressionInRange(PsiFile file2, int startOffset, int endOffset) {
        int newEndOffset;
        PsiElement element;
        PsiJavaToken token;
        IElementType tokenType;
        PsiElement element2;
        if (!file2.getViewProvider().getLanguages().contains(StdLanguages.JAVA)) {
            return null;
        }
        PsiExpression expression2 = CodeInsightUtil.findElementInRange(file2, startOffset, endOffset, PsiExpression.class);
        if (expression2 == null && CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset).length == 0 && (element2 = file2.getViewProvider().findElementAt(endOffset - 1, StdLanguages.JAVA)) instanceof PsiJavaToken && (tokenType = (token = (PsiJavaToken)element2).getTokenType()).equals(JavaTokenType.SEMICOLON)) {
            expression2 = CodeInsightUtil.findElementInRange(file2, startOffset, element2.getTextRange().getStartOffset(), PsiExpression.class);
        }
        if (expression2 == null && CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset).length == 0 && (element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)file2.findElementAt(endOffset))) != null && (element = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element.getLastChild())) != null && (newEndOffset = element.getTextRange().getEndOffset()) < endOffset) {
            expression2 = CodeInsightUtil.findExpressionInRange(file2, startOffset, newEndOffset);
        }
        if (expression2 instanceof PsiReferenceExpression && expression2.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return expression2;
    }

    public static <T extends PsiElement> T findElementInRange(PsiFile file2, int startOffset, int endOffset, Class<T> klass) {
        return CodeInsightUtilCore.findElementInRange(file2, startOffset, endOffset, klass, StdLanguages.JAVA);
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(@NotNull PsiFile file2, int startOffset, int endOffset) {
        Language language;
        if (file2 == null) {
            CodeInsightUtil.$$$reportNull$$$0(0);
        }
        if ((language = CodeInsightUtil.findJavaOrLikeLanguage(file2)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement element1 = viewProvider.findElementAt(startOffset, language);
        PsiElement element2 = viewProvider.findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(2);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (true) {
            if (parent instanceof PsiStatement) {
                if (element1 instanceof PsiComment) break;
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PsiCodeBlock || FileTypeUtils.isInServerPageFile((PsiElement)parent) && parent instanceof PsiFile || parent instanceof PsiCodeFragment) break;
            if (parent == null || parent instanceof PsiFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    CodeInsightUtil.$$$reportNull$$$0(4);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(5);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (parent instanceof PsiCodeBlock && element1 == ((PsiCodeBlock)parent).getLBrace() && element2 == ((PsiCodeBlock)parent).getRBrace()) {
            if (parent.getParent() instanceof PsiBlockStatement) {
                PsiElement[] psiElementArray = new PsiElement[]{parent.getParent()};
                if (psiElementArray == null) {
                    CodeInsightUtil.$$$reportNull$$$0(7);
                }
                return psiElementArray;
            }
            PsiElement[] children2 = parent.getChildren();
            PsiElement[] psiElementArray = CodeInsightUtil.getStatementsInRange(children2, ((PsiCodeBlock)parent).getFirstBodyElement(), ((PsiCodeBlock)parent).getLastBodyElement());
            if (psiElementArray == null) {
                CodeInsightUtil.$$$reportNull$$$0(8);
            }
            return psiElementArray;
        }
        PsiElement[] children3 = parent.getChildren();
        PsiElement[] psiElementArray = CodeInsightUtil.getStatementsInRange(children3, element1, element2);
        if (psiElementArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiElement[] getStatementsInRange(PsiElement[] children2, PsiElement element1, PsiElement element2) {
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children2) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (child.equals(element2)) break;
        }
        for (PsiElement element : array) {
            if (element instanceof PsiStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    @Nullable
    public static Language findJavaOrLikeLanguage(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeInsightUtil.$$$reportNull$$$0(12);
        }
        Set languages = file2.getViewProvider().getLanguages();
        for (Language language : languages) {
            if (language != StdLanguages.JAVA) continue;
            return language;
        }
        for (Language language : languages) {
            if (!language.isKindOf(StdLanguages.JAVA)) continue;
            return language;
        }
        return null;
    }

    public static <T extends PsiMember & PsiDocCommentOwner> void sortIdenticalShortNamedMembers(T[] members, @NotNull PsiReference context) {
        if (context == null) {
            CodeInsightUtil.$$$reportNull$$$0(13);
        }
        if (members.length <= 1) {
            return;
        }
        PsiElement leaf = context.getElement().getFirstChild();
        Comparator<T> comparator2 = CodeInsightUtil.createSortIdenticalNamedMembersComparator(leaf);
        Arrays.sort(members, comparator2);
    }

    public static <T extends PsiMember & PsiDocCommentOwner> Comparator<T> createSortIdenticalNamedMembersComparator(PsiElement place) {
        PsiProximityComparator proximityComparator = new PsiProximityComparator(place);
        return (o1, o2) -> {
            String qname2;
            boolean deprecated1 = JavaCompletionUtil.isEffectivelyDeprecated((PsiDocCommentOwner)o1);
            boolean deprecated2 = JavaCompletionUtil.isEffectivelyDeprecated((PsiDocCommentOwner)o2);
            if (deprecated1 && !deprecated2) {
                return 1;
            }
            if (!deprecated1 && deprecated2) {
                return -1;
            }
            int compare = proximityComparator.compare(o1, o2);
            if (compare != 0) {
                return compare;
            }
            String qname1 = o1 instanceof PsiClass ? ((PsiClass)o1).getQualifiedName() : null;
            String string = qname2 = o2 instanceof PsiClass ? ((PsiClass)o2).getQualifiedName() : null;
            if (qname1 == null || qname2 == null) {
                return 0;
            }
            return qname1.compareToIgnoreCase(qname2);
        };
    }

    @NotNull
    public static PsiExpression[] findExpressionOccurrences(PsiElement scope, PsiExpression expr) {
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        CodeInsightUtil.addExpressionOccurrences(RefactoringUtil.unparenthesizeExpression(expr), array, scope);
        if (expr.isPhysical()) {
            boolean found = false;
            for (PsiExpression psiExpression : array) {
                if (!PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)psiExpression, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)expr, (boolean)false)) continue;
                found = true;
                break;
            }
            if (!found) {
                array.add(expr);
            }
        }
        PsiExpression[] psiExpressionArray = array.toArray(new PsiExpression[array.size()]);
        if (psiExpressionArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(14);
        }
        return psiExpressionArray;
    }

    private static void addExpressionOccurrences(PsiExpression expr, List<PsiExpression> array, PsiElement scope) {
        PsiElement[] children2;
        for (PsiElement child : children2 = scope.getChildren()) {
            if (child instanceof PsiExpression && JavaPsiEquivalenceUtil.areExpressionsEquivalent(RefactoringUtil.unparenthesizeExpression((PsiExpression)child), expr)) {
                array.add((PsiExpression)child);
                continue;
            }
            CodeInsightUtil.addExpressionOccurrences(expr, array, child);
        }
    }

    @NotNull
    public static PsiExpression[] findReferenceExpressions(PsiElement scope, PsiElement referee) {
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        if (scope != null) {
            CodeInsightUtil.addReferenceExpressions(array, scope, referee);
        }
        PsiExpression[] psiExpressionArray = array.toArray(new PsiExpression[array.size()]);
        if (psiExpressionArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(15);
        }
        return psiExpressionArray;
    }

    private static void addReferenceExpressions(ArrayList<PsiElement> array, PsiElement scope, PsiElement referee) {
        PsiElement[] children2;
        for (PsiElement child : children2 = scope.getChildren()) {
            PsiElement ref;
            if (child instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)child).resolve()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)ref, (PsiElement)referee)) {
                array.add(child);
            }
            CodeInsightUtil.addReferenceExpressions(array, child, referee);
        }
    }

    public static Editor positionCursorAtLBrace(Project project2, PsiFile targetFile, @NotNull PsiClass psiClass) {
        PsiElement lBrace;
        if (psiClass == null) {
            CodeInsightUtil.$$$reportNull$$$0(16);
        }
        return CodeInsightUtil.positionCursor(project2, targetFile, (PsiElement)((lBrace = psiClass.getLBrace()) != null ? lBrace : psiClass));
    }

    public static Editor positionCursor(Project project2, PsiFile targetFile, @NotNull PsiElement element) {
        TextRange range;
        if (element == null) {
            CodeInsightUtil.$$$reportNull$$$0(17);
        }
        LOG.assertTrue((range = element.getTextRange()) != null, (Object)("element: " + element + "; valid: " + element.isValid()));
        int textOffset = range.getStartOffset();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, targetFile.getVirtualFile(), textOffset);
        return FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, true);
    }

    public static boolean preparePsiElementsForWrite(PsiElement ... elements) {
        if (elements == null) {
            CodeInsightUtil.$$$reportNull$$$0(18);
        }
        return FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public static void processSubTypes(PsiType psiType, PsiElement context, boolean getRawSubtypes, @NotNull PrefixMatcher matcher, Consumer<PsiType> consumer) {
        if (matcher == null) {
            CodeInsightUtil.$$$reportNull$$$0(19);
        }
        int arrayDim = psiType.getArrayDimensions();
        if (!((psiType = psiType.getDeepComponentType()) instanceof PsiClassType)) {
            return;
        }
        PsiClassType baseType = JavaCompletionUtil.originalize((PsiClassType)psiType);
        PsiClassType.ClassResolveResult baseResult = baseType.resolveGenerics();
        PsiClass baseClass = baseResult.getElement();
        PsiSubstitutor baseSubstitutor = baseResult.getSubstitutor();
        if (baseClass == null) {
            return;
        }
        GlobalSearchScope scope = context.getResolveScope();
        Processor<PsiClass> inheritorsProcessor = CodeInsightUtil.createInheritorsProcessor(context, baseType, arrayDim, getRawSubtypes, consumer, baseClass, baseSubstitutor);
        CodeInsightUtil.addContextTypeArguments(context, baseType, inheritorsProcessor);
        if (baseClass.hasModifierProperty("final")) {
            return;
        }
        if (matcher.getPrefix().length() > 2) {
            JBTreeTraverser traverser = JBTreeTraverser.of(PsiClass::getInnerClasses);
            AllClassesGetter.processJavaClasses(matcher, context.getProject(), scope, (Processor<PsiClass>)((Processor)psiClass -> {
                FilteredTraverserBase inheritors = ((JBTreeTraverser)traverser.withRoot(psiClass)).filter(c -> c.isInheritor(baseClass, true));
                return ContainerUtil.process((Iterable)inheritors, (Processor)inheritorsProcessor);
            }));
        } else {
            Query baseQuery = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            FilteredQuery query = new FilteredQuery(baseQuery, psiClass -> {
                if (matcher == null) {
                    CodeInsightUtil.$$$reportNull$$$0(25);
                }
                if (psiClass instanceof PsiTypeParameter) return false;
                if (!ContainerUtil.exists(JavaCompletionUtil.getAllLookupStrings((PsiMember)psiClass), arg_0 -> ((PrefixMatcher)matcher).prefixMatches(arg_0))) return false;
                return true;
            });
            query.forEach(inheritorsProcessor);
        }
    }

    private static void addContextTypeArguments(PsiElement context, PsiClassType baseType, Processor<PsiClass> inheritorsProcessor) {
        PsiTypeParameterListOwner typed;
        HashSet usedNames = ContainerUtil.newHashSet();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiElement each = context;
        while ((typed = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)each, PsiTypeParameterListOwner.class)) != null) {
            for (PsiTypeParameter parameter2 : typed.getTypeParameters()) {
                if (!baseType.isAssignableFrom((PsiType)factory.createType((PsiClass)parameter2)) || !usedNames.add(parameter2.getName())) continue;
                inheritorsProcessor.process((Object)CompletionUtil.getOriginalOrSelf(parameter2));
            }
            each = typed;
        }
    }

    public static Processor<PsiClass> createInheritorsProcessor(PsiElement context, PsiClassType baseType, int arrayDim, boolean getRawSubtypes, Consumer<PsiType> result2, @NotNull PsiClass baseClass, PsiSubstitutor baseSubstitutor) {
        if (baseClass == null) {
            CodeInsightUtil.$$$reportNull$$$0(20);
        }
        PsiManager manager = context.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiElementFactory factory = facade.getElementFactory();
        return inheritor -> {
            if (baseClass == null) {
                CodeInsightUtil.$$$reportNull$$$0(24);
            }
            ProgressManager.checkCanceled();
            if (!resolveHelper.isAccessible((PsiMember)inheritor, context, null)) {
                return true;
            }
            if (inheritor.getQualifiedName() == null && !manager.areElementsEquivalent((PsiElement)inheritor.getContainingFile(), (PsiElement)context.getContainingFile().getOriginalFile())) {
                return true;
            }
            if (JavaCompletionUtil.isInExcludedPackage((PsiMember)inheritor, false)) {
                return true;
            }
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)baseClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (superSubstitutor == null) {
                return true;
            }
            List<PsiType> typeArgs = getRawSubtypes ? null : CodeInsightUtil.getExpectedTypeArgs(context, (PsiTypeParameterListOwner)inheritor, Arrays.asList(inheritor.getTypeParameters()), baseType);
            PsiClassType inheritorType = typeArgs == null || typeArgs.contains(null) ? factory.createType(inheritor, factory.createRawSubstitutor((PsiTypeParameterListOwner)inheritor)) : factory.createType(inheritor, typeArgs.toArray(PsiType.EMPTY_ARRAY));
            PsiType toAdd = CodeInsightUtil.addArrayDimensions(arrayDim, (PsiType)inheritorType);
            if (baseType.isAssignableFrom(toAdd)) {
                result2.consume((Object)toAdd);
            }
            return true;
        };
    }

    private static PsiType addArrayDimensions(int arrayDim, PsiType newType) {
        for (int i = 0; i < arrayDim; ++i) {
            newType = newType.createArrayType();
        }
        return newType;
    }

    @NotNull
    public static List<PsiType> getExpectedTypeArgs(PsiElement context, PsiTypeParameterListOwner paramOwner, Iterable<PsiTypeParameter> typeParams, PsiClassType expectedType) {
        if (paramOwner instanceof PsiClass) {
            PsiClassType.ClassResolveResult resolve2 = expectedType.resolveGenerics();
            PsiClass expectedClass = resolve2.getElement();
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)paramOwner), (PsiClass)expectedClass, (boolean)true)) {
                List list2 = ContainerUtil.map(typeParams, p -> null);
                if (list2 == null) {
                    CodeInsightUtil.$$$reportNull$$$0(21);
                }
                return list2;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)expectedClass, (PsiClass)((PsiClass)paramOwner), (PsiSubstitutor)PsiSubstitutor.EMPTY);
            assert (substitutor != null);
            List list3 = ContainerUtil.map(typeParams, p -> CodeInsightUtil.getExpectedTypeArg(context, resolve2, substitutor, p));
            if (list3 == null) {
                CodeInsightUtil.$$$reportNull$$$0(22);
            }
            return list3;
        }
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor((PsiMethod)paramOwner, (PsiType)expectedType);
        List list4 = ContainerUtil.map(typeParams, arg_0 -> ((PsiSubstitutor)substitutor).substitute(arg_0));
        if (list4 == null) {
            CodeInsightUtil.$$$reportNull$$$0(23);
        }
        return list4;
    }

    @Nullable
    private static PsiType getExpectedTypeArg(PsiElement context, PsiClassType.ClassResolveResult expectedType, PsiSubstitutor superClassSubstitutor, PsiTypeParameter typeParam) {
        PsiClass expectedClass = expectedType.getElement();
        assert (expectedClass != null);
        for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)expectedClass)) {
            PsiType paramSubstitution = superClassSubstitutor.substitute(parameter2);
            PsiClass inheritorCandidateParameter = PsiUtil.resolveClassInType((PsiType)paramSubstitution);
            if (inheritorCandidateParameter instanceof PsiTypeParameter && ((PsiTypeParameter)inheritorCandidateParameter).getOwner() == typeParam.getOwner() && inheritorCandidateParameter != typeParam) continue;
            PsiType argSubstitution = expectedType.getSubstitutor().substitute(parameter2);
            PsiType substitution = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper().getSubstitutionForTypeParameter(typeParam, paramSubstitution, argSubstitution, true, PsiUtil.getLanguageLevel((PsiElement)context));
            if (substitution == null || substitution == PsiType.NULL) continue;
            return substitution;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/CodeInsightUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findStatementsInRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsInRange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionOccurrences";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferenceExpressions";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findStatementsInRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findJavaOrLikeLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortIdenticalShortNamedMembers";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "positionCursorAtLBrace";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "positionCursor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "preparePsiElementsForWrite";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processSubTypes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createInheritorsProcessor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createInheritorsProcessor$4";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processSubTypes$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

