/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.proximity.KnownElementWeigher;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PreferByKindWeigher
extends LookupElementWeigher {
    public static final Key<Boolean> INTRODUCED_VARIABLE = Key.create((String)"INTRODUCED_VARIABLE");
    static final ElementPattern<PsiElement> IN_CATCH_TYPE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiCatchSection.class), PsiJavaPatterns.psiElement(PsiVariable.class).withParent(PsiCatchSection.class)}))));
    static final ElementPattern<PsiElement> IN_MULTI_CATCH_TYPE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiCatchSection.class)), PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiParameter.class)).withSuperParent(3, PsiCatchSection.class))});
    static final ElementPattern<PsiElement> INSIDE_METHOD_THROWS_CLAUSE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throws", ","})).inside((ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaElementType.THROWS_LIST));
    static final ElementPattern<PsiElement> IN_RESOURCE = PsiJavaPatterns.psiElement().withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiTypeElement.class)).withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiResourceVariable.class), PsiJavaPatterns.psiElement(PsiResourceList.class)})), PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiResourceExpression.class)}));
    private final CompletionType myCompletionType;
    private final PsiElement myPosition;
    private final Set<PsiField> myNonInitializedFields;
    private final Condition<PsiClass> myRequiredSuper;
    private final ExpectedTypeInfo[] myExpectedTypes;

    public PreferByKindWeigher(CompletionType completionType, PsiElement position, ExpectedTypeInfo[] expectedTypes) {
        super("kind");
        this.myCompletionType = completionType;
        this.myPosition = position;
        this.myNonInitializedFields = CheckInitialized.getNonInitializedFields(position);
        this.myRequiredSuper = PreferByKindWeigher.createSuitabilityCondition(position);
        this.myExpectedTypes = expectedTypes;
    }

    @NotNull
    private static Condition<PsiClass> createSuitabilityCondition(PsiElement position) {
        if (IN_CATCH_TYPE.accepts((Object)position) || IN_MULTI_CATCH_TYPE.accepts((Object)position)) {
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiTryStatement.class);
            ArrayList thrownExceptions = ContainerUtil.newArrayList();
            if (tryStatement != null && tryStatement.getTryBlock() != null) {
                for (PsiClassType type2 : ExceptionUtil.getThrownExceptions((PsiElement)tryStatement.getTryBlock())) {
                    ContainerUtil.addIfNotNull((Collection)thrownExceptions, (Object)type2.resolve());
                }
            }
            if (thrownExceptions.isEmpty()) {
                ContainerUtil.addIfNotNull((Collection)thrownExceptions, (Object)JavaPsiFacade.getInstance((Project)position.getProject()).findClass("java.lang.Throwable", position.getResolveScope()));
            }
            Condition condition2 = psiClass -> {
                for (PsiClass exception : thrownExceptions) {
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)exception, (boolean)true)) continue;
                    return true;
                }
                return false;
            };
            if (condition2 == null) {
                PreferByKindWeigher.$$$reportNull$$$0(0);
            }
            return condition2;
        }
        if (JavaSmartCompletionContributor.AFTER_THROW_NEW.accepts((Object)position) || INSIDE_METHOD_THROWS_CLAUSE.accepts((Object)position)) {
            Condition condition3 = psiClass -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Throwable");
            if (condition3 == null) {
                PreferByKindWeigher.$$$reportNull$$$0(1);
            }
            return condition3;
        }
        if (IN_RESOURCE.accepts((Object)position)) {
            Condition condition4 = psiClass -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.AutoCloseable");
            if (condition4 == null) {
                PreferByKindWeigher.$$$reportNull$$$0(2);
            }
            return condition4;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).accepts((Object)position)) {
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class);
            assert (annotation != null);
            PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner());
            Condition condition5 = psiClass -> psiClass.isAnnotationType() && AnnotationTargetUtil.findAnnotationTarget((PsiClass)psiClass, (PsiAnnotation.TargetType[])targets) != null;
            if (condition5 == null) {
                PreferByKindWeigher.$$$reportNull$$$0(3);
            }
            return condition5;
        }
        Condition condition6 = Conditions.alwaysFalse();
        if (condition6 == null) {
            PreferByKindWeigher.$$$reportNull$$$0(4);
        }
        return condition6;
    }

    @NotNull
    public MyResult weigh(@NotNull LookupElement item) {
        PsiClass containingClass;
        Object object;
        if (item == null) {
            PreferByKindWeigher.$$$reportNull$$$0(5);
        }
        if ((object = item.getObject()) instanceof PsiKeyword) {
            ThreeState result2 = this.isProbableKeyword(((PsiKeyword)object).getText());
            if (result2 == ThreeState.YES) {
                MyResult myResult = MyResult.probableKeyword;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(6);
                }
                return myResult;
            }
            if (result2 == ThreeState.NO) {
                MyResult myResult = MyResult.improbableKeyword;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(7);
                }
                return myResult;
            }
        }
        if (item.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY) != null) {
            MyResult myResult = MyResult.castVariable;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(8);
            }
            return myResult;
        }
        if (object instanceof PsiLocalVariable || object instanceof PsiParameter || object instanceof PsiThisExpression || object instanceof PsiField && !((PsiField)object).hasModifierProperty("static")) {
            MyResult myResult = this.isExpectedTypeItem(item) ? MyResult.expectedTypeVariable : MyResult.variable;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(9);
            }
            return myResult;
        }
        if (object instanceof String && item.getUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS) == Boolean.TRUE) {
            MyResult myResult = MyResult.superMethodParameters;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(10);
            }
            return myResult;
        }
        if (item.getUserData(FunctionalExpressionCompletionProvider.FUNCTIONAL_EXPR_ITEM) != null) {
            MyResult myResult = MyResult.funExpr;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(11);
            }
            return myResult;
        }
        if (object instanceof PsiMethod && (containingClass = ((PsiMethod)object).getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
            MyResult myResult = MyResult.collectionFactory;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(12);
            }
            return myResult;
        }
        if (object instanceof PsiClass && "java.lang.String".equals(((PsiClass)object).getQualifiedName()) && JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)this.myPosition)) {
            MyResult myResult = MyResult.unlikelyClass;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(13);
            }
            return myResult;
        }
        Boolean expectedTypeMember = (Boolean)item.getUserData(MembersGetter.EXPECTED_TYPE_MEMBER);
        if (expectedTypeMember != null) {
            MyResult myResult = expectedTypeMember.booleanValue() ? (object instanceof PsiField ? MyResult.expectedTypeConstant : MyResult.expectedTypeMethod) : MyResult.classNameOrGlobalStatic;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(14);
            }
            return myResult;
        }
        if (item instanceof TypeArgumentCompletionProvider.TypeArgsLookupElement) {
            MyResult myResult = MyResult.expectedTypeArgument;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(15);
            }
            return myResult;
        }
        JavaChainLookupElement chain = (JavaChainLookupElement)item.as(JavaChainLookupElement.CLASS_CONDITION_KEY);
        if (chain != null) {
            Object qualifier = chain.getQualifier().getObject();
            if (qualifier instanceof PsiLocalVariable || qualifier instanceof PsiParameter) {
                MyResult myResult = MyResult.variable;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(16);
                }
                return myResult;
            }
            if (qualifier instanceof PsiField) {
                MyResult myResult = MyResult.qualifiedWithField;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(17);
                }
                return myResult;
            }
            if (PreferByKindWeigher.isGetter(qualifier)) {
                MyResult myResult = MyResult.qualifiedWithGetter;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(18);
                }
                return myResult;
            }
            if (chain.getQualifier().getUserData(INTRODUCED_VARIABLE) == Boolean.TRUE) {
                MyResult myResult = MyResult.introducedVariable;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(19);
                }
                return myResult;
            }
            if (this.myCompletionType == CompletionType.SMART && qualifier instanceof PsiMethod && PreferByKindWeigher.isGetter(object)) {
                MyResult myResult = MyResult.getterQualifiedByMethod;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(20);
                }
                return myResult;
            }
        }
        if (this.myCompletionType == CompletionType.SMART) {
            if (PreferByKindWeigher.isGetter(object)) {
                MyResult myResult = chain == null && this.isAccessibleFieldGetter(object) ? MyResult.accessibleFieldGetter : MyResult.getter;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(21);
                }
                return myResult;
            }
            MyResult myResult = MyResult.normal;
            if (myResult == null) {
                PreferByKindWeigher.$$$reportNull$$$0(22);
            }
            return myResult;
        }
        if (this.myCompletionType == CompletionType.BASIC) {
            StaticallyImportable callElement = (StaticallyImportable)item.as(StaticallyImportable.CLASS_CONDITION_KEY);
            if (callElement != null && callElement.canBeImported() && !callElement.willBeImported()) {
                MyResult myResult = MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(23);
                }
                return myResult;
            }
            if (object instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)object))) {
                MyResult myResult = MyResult.annoMethod;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(24);
                }
                return myResult;
            }
            if (object instanceof PsiClass) {
                if (this.myRequiredSuper.value((Object)((PsiClass)object))) {
                    MyResult myResult = MyResult.suitableClass;
                    if (myResult == null) {
                        PreferByKindWeigher.$$$reportNull$$$0(25);
                    }
                    return myResult;
                }
                MyResult myResult = MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(26);
                }
                return myResult;
            }
            if (object instanceof PsiField && this.myNonInitializedFields.contains(object)) {
                MyResult myResult = MyResult.nonInitialized;
                if (myResult == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(27);
                }
                return myResult;
            }
        }
        MyResult myResult = MyResult.normal;
        if (myResult == null) {
            PreferByKindWeigher.$$$reportNull$$$0(28);
        }
        return myResult;
    }

    private boolean isExpectedTypeItem(@NotNull LookupElement item) {
        TypedLookupItem typed;
        if (item == null) {
            PreferByKindWeigher.$$$reportNull$$$0(29);
        }
        PsiType itemType = (typed = (TypedLookupItem)item.as(TypedLookupItem.CLASS_CONDITION_KEY)) == null ? null : typed.getType();
        return itemType != null && Arrays.stream(this.myExpectedTypes).anyMatch(info -> info.getType().isAssignableFrom(itemType));
    }

    @NotNull
    private ThreeState isProbableKeyword(String keyword) {
        PsiStatement parentStatement;
        if ("return".equals(keyword) && PreferByKindWeigher.isLastStatement(parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiStatement.class)) && !PreferByKindWeigher.isOnTopLevelInVoidMethod(parentStatement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(30);
            }
            return threeState;
        }
        if (("break".equals(keyword) || "continue".equals(keyword)) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiLoopStatement.class) != null && PreferByKindWeigher.isLastStatement((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiStatement.class))) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(31);
            }
            return threeState;
        }
        if ("else".equals(keyword) || "finally".equals(keyword) || "catch".equals(keyword)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(32);
            }
            return threeState;
        }
        if ("true".equals(keyword) || "false".equals(keyword)) {
            if (this.myCompletionType == CompletionType.SMART) {
                boolean inReturn = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiReturnStatement.class})).accepts((Object)this.myPosition);
                ThreeState threeState = inReturn ? ThreeState.YES : ThreeState.UNSURE;
                if (threeState == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(33);
                }
                return threeState;
            }
            if (Arrays.stream(this.myExpectedTypes).anyMatch(info -> PsiType.BOOLEAN.isConvertibleFrom(info.getDefaultType())) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class, PsiMember.class}) == null) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    PreferByKindWeigher.$$$reportNull$$$0(34);
                }
                return threeState;
            }
        }
        if ("interface".equals(keyword) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)this.myPosition)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(35);
            }
            return threeState;
        }
        if ("null".equals(keyword) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE})))).accepts((Object)this.myPosition)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(36);
            }
            return threeState;
        }
        if (JavaKeywordCompletion.PRIMITIVE_TYPES.contains(keyword) || "void".equals(keyword)) {
            boolean inCallArg = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiExpressionList.class})).accepts((Object)this.myPosition);
            ThreeState threeState = inCallArg || PreferByKindWeigher.isInMethodTypeArg(this.myPosition) ? ThreeState.NO : ThreeState.UNSURE;
            if (threeState == null) {
                PreferByKindWeigher.$$$reportNull$$$0(37);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            PreferByKindWeigher.$$$reportNull$$$0(38);
        }
        return threeState;
    }

    private boolean isAccessibleFieldGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiField field = PropertyUtil.getFieldOfGetter((PsiMethod)object);
        return field != null && PsiResolveHelper.SERVICE.getInstance((Project)this.myPosition.getProject()).isAccessible((PsiMember)field, this.myPosition, null);
    }

    static boolean isInMethodTypeArg(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position);
    }

    private static boolean isOnTopLevelInVoidMethod(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            PreferByKindWeigher.$$$reportNull$$$0(39);
        }
        if (!(statement2.getParent() instanceof PsiCodeBlock)) {
            return false;
        }
        PsiElement parent = statement2.getParent().getParent();
        if (parent instanceof PsiMethod) {
            return ((PsiMethod)parent).isConstructor() || PsiType.VOID.equals((Object)((PsiMethod)parent).getReturnType());
        }
        if (parent instanceof PsiLambdaExpression) {
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
            return method != null && PsiType.VOID.equals((Object)method.getReturnType());
        }
        return false;
    }

    private static boolean isGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)object;
        if (!PropertyUtilBase.hasGetterName((PsiMethod)method)) {
            return false;
        }
        return !KnownElementWeigher.isGetClass(method);
    }

    private static boolean isLastStatement(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        if (!(statement2.getParent() instanceof PsiCodeBlock)) {
            return true;
        }
        PsiStatement[] siblings = ((PsiCodeBlock)statement2.getParent()).getStatements();
        PsiStatement lastOne = siblings[siblings.length - 1];
        if (statement2 == lastOne) {
            return true;
        }
        if (siblings.length >= 2 && statement2 == siblings[siblings.length - 2] && lastOne instanceof PsiExpressionStatement) {
            int start = statement2.getTextRange().getStartOffset();
            int end = lastOne.getTextRange().getStartOffset();
            return !StringUtil.contains((CharSequence)statement2.getContainingFile().getViewProvider().getContents(), (int)start, (int)end, (char)'\n');
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 29: 
            case 39: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 29: 
            case 39: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/PreferByKindWeigher";
                break;
            }
            case 5: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitabilityCondition";
                break;
            }
            case 5: 
            case 29: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/PreferByKindWeigher";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "weigh";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "isProbableKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedTypeItem";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isOnTopLevelInVoidMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 29: 
            case 39: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum MyResult {
        annoMethod,
        probableKeyword,
        castVariable,
        expectedTypeVariable,
        funExpr,
        variable,
        getter,
        qualifiedWithField,
        qualifiedWithGetter,
        superMethodParameters,
        expectedTypeConstant,
        expectedTypeArgument,
        getterQualifiedByMethod,
        accessibleFieldGetter,
        normal,
        collectionFactory,
        expectedTypeMethod,
        suitableClass,
        nonInitialized,
        classNameOrGlobalStatic,
        introducedVariable,
        unlikelyClass,
        improbableKeyword;

    }
}

