/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterPrefixMatcher
extends PrefixMatcher {
    private final PrefixMatcher myOriginal;
    @Nullable
    private final CamelHumpMatcher myHumpMatcher;
    private final int myMinMatchingDegree;

    public BetterPrefixMatcher(PrefixMatcher original, int minMatchingDegree) {
        super(original.getPrefix());
        this.myOriginal = original;
        this.myHumpMatcher = original instanceof CamelHumpMatcher ? (CamelHumpMatcher)original : null;
        this.myMinMatchingDegree = minMatchingDegree;
    }

    @NotNull
    public BetterPrefixMatcher improve(CompletionResult result2) {
        int degree = RealPrefixMatchingWeigher.getBestMatchingDegree(result2.getLookupElement(), result2.getPrefixMatcher());
        if (degree <= this.myMinMatchingDegree) {
            BetterPrefixMatcher betterPrefixMatcher = this;
            if (betterPrefixMatcher == null) {
                BetterPrefixMatcher.$$$reportNull$$$0(0);
            }
            return betterPrefixMatcher;
        }
        BetterPrefixMatcher betterPrefixMatcher = this.createCopy(this.myOriginal, degree);
        if (betterPrefixMatcher == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(1);
        }
        return betterPrefixMatcher;
    }

    @NotNull
    protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
        BetterPrefixMatcher betterPrefixMatcher = new BetterPrefixMatcher(original, degree);
        if (betterPrefixMatcher == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(2);
        }
        return betterPrefixMatcher;
    }

    public boolean prefixMatches(@NotNull String name2) {
        if (name2 == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(3);
        }
        return this.prefixMatchesEx(name2) == MatchingOutcome.BETTER_MATCH;
    }

    protected MatchingOutcome prefixMatchesEx(String name2) {
        return this.myHumpMatcher != null ? this.matchOptimized(name2, this.myHumpMatcher) : this.matchGeneric(name2);
    }

    private MatchingOutcome matchGeneric(String name2) {
        if (!this.myOriginal.prefixMatches(name2)) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!this.myOriginal.isStartMatch(name2)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return this.myOriginal.matchingDegree(name2) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    private MatchingOutcome matchOptimized(String name2, CamelHumpMatcher matcher) {
        FList<TextRange> fragments = matcher.matchingFragments(name2);
        if (fragments == null) {
            return MatchingOutcome.NON_MATCH;
        }
        if (!MinusculeMatcher.isStartMatch(fragments)) {
            return MatchingOutcome.WORSE_MATCH;
        }
        return matcher.matchingDegree(name2, fragments) >= this.myMinMatchingDegree ? MatchingOutcome.BETTER_MATCH : MatchingOutcome.WORSE_MATCH;
    }

    public boolean isStartMatch(String name2) {
        return this.myOriginal.isStartMatch(name2);
    }

    public int matchingDegree(String string) {
        return this.myOriginal.matchingDegree(string);
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(4);
        }
        BetterPrefixMatcher betterPrefixMatcher = this.createCopy(this.myOriginal.cloneWithPrefix(prefix), this.myMinMatchingDegree);
        if (betterPrefixMatcher == null) {
            BetterPrefixMatcher.$$$reportNull$$$0(5);
        }
        return betterPrefixMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "improve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AutoRestarting
    extends BetterPrefixMatcher {
        private final CompletionResultSet myResult;

        public AutoRestarting(@NotNull CompletionResultSet result2) {
            if (result2 == null) {
                AutoRestarting.$$$reportNull$$$0(0);
            }
            this(result2, result2.getPrefixMatcher(), Integer.MIN_VALUE);
        }

        private AutoRestarting(CompletionResultSet result2, PrefixMatcher original, int minMatchingDegree) {
            super(original, minMatchingDegree);
            this.myResult = result2;
        }

        @Override
        @NotNull
        protected BetterPrefixMatcher createCopy(PrefixMatcher original, int degree) {
            AutoRestarting autoRestarting = new AutoRestarting(this.myResult, original, degree);
            if (autoRestarting == null) {
                AutoRestarting.$$$reportNull$$$0(1);
            }
            return autoRestarting;
        }

        @Override
        protected MatchingOutcome prefixMatchesEx(String name2) {
            MatchingOutcome outcome = super.prefixMatchesEx(name2);
            if (outcome == MatchingOutcome.WORSE_MATCH) {
                this.myResult.restartCompletionOnAnyPrefixChange();
            }
            return outcome;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher$AutoRestarting";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/BetterPrefixMatcher$AutoRestarting";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static enum MatchingOutcome {
        NON_MATCH,
        WORSE_MATCH,
        BETTER_MATCH;

    }
}

