/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ExternalToolPassFactory;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(ExternalToolPass.class);
    private final Document myDocument;
    private final AnnotationHolderImpl myAnnotationHolder;
    private final ExternalToolPassFactory myExternalToolPassFactory;
    private final boolean myMainHighlightingPass;
    private final List<MyData> myAnnotationData;

    ExternalToolPass(@NotNull ExternalToolPassFactory factory, @NotNull PsiFile file2, @NotNull Editor editor, int startOffset, int endOffset) {
        if (factory == null) {
            ExternalToolPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ExternalToolPass.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ExternalToolPass.$$$reportNull$$$0(2);
        }
        this(factory, file2, editor.getDocument(), editor, startOffset, endOffset, new DefaultHighlightInfoProcessor(), false);
    }

    ExternalToolPass(@NotNull ExternalToolPassFactory factory, @NotNull PsiFile file2, @NotNull Document document, @Nullable Editor editor, int startOffset, int endOffset, @NotNull HighlightInfoProcessor processor2, boolean mainHighlightingPass) {
        if (factory == null) {
            ExternalToolPass.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ExternalToolPass.$$$reportNull$$$0(4);
        }
        if (document == null) {
            ExternalToolPass.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            ExternalToolPass.$$$reportNull$$$0(6);
        }
        super(file2.getProject(), document, "External annotators", file2, editor, new TextRange(startOffset, endOffset), false, processor2);
        this.myAnnotationData = new ArrayList<MyData>();
        this.myDocument = document;
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        this.myExternalToolPassFactory = factory;
        this.myMainHighlightingPass = mainHighlightingPass;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ExternalToolPass.$$$reportNull$$$0(7);
        }
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        HighlightingLevelManager highlightingManager = HighlightingLevelManager.getInstance(this.myProject);
        HashMap<PsiFile, List> allAnnotators = new HashMap<PsiFile, List>();
        int externalAnnotatorsInRoots = 0;
        for (Language language : viewProvider.getLanguages()) {
            List annotators;
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!highlightingManager.shouldInspect((PsiElement)psiRoot) || (annotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot)).isEmpty()) continue;
            externalAnnotatorsInRoots += annotators.size();
            allAnnotators.put(psiRoot, annotators);
        }
        this.setProgressLimit(externalAnnotatorsInRoots);
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        boolean errorFound = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().wasErrorFound(this.myDocument);
        Editor editor = this.getEditor();
        for (PsiFile psiRoot : allAnnotators.keySet()) {
            for (ExternalAnnotator annotator : (List)allAnnotators.get(psiRoot)) {
                String shortName = annotator.getPairedBatchInspectionShortName();
                if (shortName != null) {
                    HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
                    LOG.assertTrue(key2 != null || ApplicationManager.getApplication().isUnitTestMode(), (Object)("Paired tool '" + shortName + "' not found for external annotator: " + annotator));
                    if (key2 == null || !profile2.isToolEnabled(key2, (PsiElement)this.myFile)) continue;
                }
                Object collectedInfo = null;
                try {
                    collectedInfo = editor != null ? annotator.collectInformation(psiRoot, editor, errorFound) : annotator.collectInformation(psiRoot);
                }
                catch (Throwable t) {
                    ExternalToolPass.process(t, annotator, psiRoot);
                }
                this.advanceProgress(1L);
                if (collectedInfo == null) continue;
                this.myAnnotationData.add(new MyData(annotator, psiRoot, collectedInfo));
            }
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        if (this.myProject.isDisposed()) {
            List<HighlightInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                ExternalToolPass.$$$reportNull$$$0(8);
            }
            return list2;
        }
        if (this.myMainHighlightingPass) {
            this.doAnnotate();
            this.applyRelevant();
            List<HighlightInfo> list3 = this.getHighlights();
            if (list3 == null) {
                ExternalToolPass.$$$reportNull$$$0(9);
            }
            return list3;
        }
        List<HighlightInfo> list4 = super.getInfos();
        if (list4 == null) {
            ExternalToolPass.$$$reportNull$$$0(10);
        }
        return list4;
    }

    @Override
    protected void applyInformationWithProgress() {
        final long modificationStampBefore = this.myDocument.getModificationStamp();
        Update update2 = new Update(this.myFile){

            public void setRejected() {
                super.setRejected();
                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
            }

            public void run() {
                if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                    return;
                }
                ExternalToolPass.this.doAnnotate();
                ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                        return;
                    }
                    ExternalToolPass.this.applyRelevant();
                    ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
                });
            }
        };
        this.myExternalToolPassFactory.scheduleExternalActivity(update2);
    }

    private boolean documentChanged(long modificationStampBefore) {
        return this.myDocument.getModificationStamp() != modificationStampBefore;
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myAnnotationHolder.size());
        Iterator iterator = this.myAnnotationHolder.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            ExternalToolPass.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private void applyRelevant() {
        for (MyData data : this.myAnnotationData) {
            if (data.annotationResult == null || data.psiRoot == null || !data.psiRoot.isValid()) continue;
            try {
                data.annotator.apply(data.psiRoot, data.annotationResult, (AnnotationHolder)this.myAnnotationHolder);
            }
            catch (Throwable t) {
                ExternalToolPass.process(t, data.annotator, data.psiRoot);
            }
        }
    }

    private void doFinish(@NotNull List<HighlightInfo> highlights, long modificationStampBefore) {
        if (highlights == null) {
            ExternalToolPass.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            void highlights;
            if (highlights == null) {
                ExternalToolPass.$$$reportNull$$$0(13);
            }
            if (this.documentChanged(modificationStampBefore) || this.myProject.isDisposed()) {
                return;
            }
            int start = this.myRestrictRange.getStartOffset();
            int end = this.myRestrictRange.getEndOffset();
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, start, end, (Collection<HighlightInfo>)highlights, this.getColorsScheme(), this.getId());
            DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
        }, ModalityState.stateForComponent((Component)this.getEditor().getComponent()));
    }

    private void doAnnotate() {
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        for (MyData data : this.myAnnotationData) {
            if (dumbService.isDumb() && !DumbService.isDumbAware((Object)data.annotator)) continue;
            try {
                data.annotationResult = data.annotator.doAnnotate(data.collectedInfo);
            }
            catch (Throwable t) {
                ExternalToolPass.process(t, data.annotator, data.psiRoot);
            }
        }
    }

    private static void process(Throwable t, ExternalAnnotator annotator, PsiFile root) {
        if (t instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)t;
        }
        VirtualFile file2 = root.getVirtualFile();
        LOG.error("annotator: " + annotator + " (" + annotator.getClass() + ")", new Attachment[]{new Attachment("root_path.txt", file2 != null ? file2.getPath() : root.getName()), new Attachment("stack", t)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ExternalToolPass";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ExternalToolPass";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFinish";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doFinish$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyData {
        private final ExternalAnnotator annotator;
        private final PsiFile psiRoot;
        private final Object collectedInfo;
        private volatile Object annotationResult;

        private MyData(ExternalAnnotator annotator, PsiFile psiRoot, Object collectedInfo) {
            this.annotator = annotator;
            this.psiRoot = psiRoot;
            this.collectedInfo = collectedInfo;
        }
    }
}

