/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaReferenceImporter
implements ReferenceImporter {
    @Override
    public boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JavaReferenceImporter.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JavaReferenceImporter.$$$reportNull$$$0(1);
        }
        return CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY && JavaReferenceImporter.autoImportReferenceAtCursor(editor, file2, false);
    }

    public static boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2, boolean allowCaretNearRef) {
        if (editor == null) {
            JavaReferenceImporter.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JavaReferenceImporter.$$$reportNull$$$0(3);
        }
        if (!file2.getViewProvider().getLanguages().contains(JavaLanguage.INSTANCE)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caretOffset);
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file2, startOffset, endOffset);
        for (PsiElement element : elements) {
            PsiJavaCodeReferenceElement ref;
            if (!(element instanceof PsiJavaCodeReferenceElement) || (ref = (PsiJavaCodeReferenceElement)element).multiResolve(true).length != 0) continue;
            new ImportClassFix(ref).doFix(editor, false, allowCaretNearRef);
            return true;
        }
        return false;
    }

    @Override
    public boolean autoImportReferenceAt(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        PsiJavaCodeReferenceElement ref;
        if (editor == null) {
            JavaReferenceImporter.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            JavaReferenceImporter.$$$reportNull$$$0(5);
        }
        if (!CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY) {
            return false;
        }
        if (!file2.getViewProvider().getLanguages().contains(JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiReference element = file2.findReferenceAt(offset);
        if (element instanceof PsiJavaCodeReferenceElement && (ref = (PsiJavaCodeReferenceElement)element).multiResolve(true).length == 0) {
            new ImportClassFix(ref).doFix(editor, false, true);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaReferenceImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "autoImportReferenceAtCursor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "autoImportReferenceAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

