/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveSuppressWarningAction
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction");
    @NotNull
    private final String myID;
    private final String myProblemLine;

    public RemoveSuppressWarningAction(@NotNull String ID2, String problemLine) {
        if (ID2 == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(0);
        }
        this.myID = ID2;
        this.myProblemLine = problemLine;
    }

    public RemoveSuppressWarningAction(@NotNull String id) {
        if (id == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(1);
        }
        int idx = id.indexOf(";");
        if (idx > -1) {
            this.myID = id.substring(0, idx);
            this.myProblemLine = id.substring(idx);
        } else {
            this.myID = id;
            this.myProblemLine = null;
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.suppression.action.family", new Object[0]);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(4);
        }
        PsiElement element = descriptor2.getPsiElement();
        try {
            PsiJavaDocumentedElement commentOwner;
            if (element != null && (commentOwner = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiJavaDocumentedElement.class)) != null) {
                PsiElement psiElement = JavaSuppressionUtil.getElementMemberSuppressedIn(commentOwner, this.myID);
                if (psiElement instanceof PsiAnnotation) {
                    this.removeFromAnnotation((PsiAnnotation)psiElement);
                } else if (psiElement instanceof PsiDocComment) {
                    this.removeFromJavaDoc((PsiDocComment)psiElement);
                } else {
                    final HashSet comments = new HashSet();
                    commentOwner.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitComment(PsiComment comment) {
                            super.visitComment(comment);
                            if (comment.getText().contains(RemoveSuppressWarningAction.this.myID)) {
                                comments.add(comment);
                            }
                        }
                    });
                    for (PsiComment comment : comments) {
                        try {
                            this.removeFromComment(comment, comments.size() > 1);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("remove.suppression.action.name", this.myID);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void removeFromComment(PsiComment comment, boolean checkLine) throws IncorrectOperationException {
        PsiStatement statement2;
        if (checkLine && (statement2 = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, PsiStatement.class)) != null && !Comparing.strEqual((String)statement2.getText(), (String)this.myProblemLine)) {
            return;
        }
        String newText = this.removeFromElementText(new PsiElement[]{comment});
        if (newText != null) {
            if (newText.isEmpty()) {
                comment.delete();
            } else {
                PsiComment newComment = JavaPsiFacade.getInstance((Project)comment.getProject()).getElementFactory().createCommentFromText("// noinspection " + newText, (PsiElement)comment);
                comment.replace((PsiElement)newComment);
            }
        }
    }

    private void removeFromJavaDoc(PsiDocComment docComment) throws IncorrectOperationException {
        PsiDocTag tag = docComment.findTagByName("noinspection");
        if (tag == null) {
            return;
        }
        String newText = this.removeFromElementText(tag.getDataElements());
        if (newText != null && newText.isEmpty()) {
            tag.delete();
        } else if (newText != null) {
            newText = "@noinspection " + newText;
            PsiDocTag newTag = JavaPsiFacade.getInstance((Project)tag.getProject()).getElementFactory().createDocTagFromText(newText);
            tag.replace((PsiElement)newTag);
        }
    }

    @Nullable
    private String removeFromElementText(PsiElement ... elements) {
        String text2 = "";
        for (PsiElement element : elements) {
            text2 = text2 + StringUtil.trimStart((String)element.getText(), (String)"//").trim();
        }
        text2 = StringUtil.trimStart((String)text2, (String)"@").trim();
        List ids = StringUtil.split((String)(text2 = StringUtil.trimStart((String)text2, (String)"noinspection").trim()), (String)",");
        int i = ArrayUtil.find((Object[])ids.toArray(), (Object)this.myID);
        if (i == -1) {
            return null;
        }
        ids.remove(i);
        return StringUtil.join((Collection)ids, (String)",");
    }

    private void removeFromAnnotation(PsiAnnotation annotation) throws IncorrectOperationException {
        PsiNameValuePair[] attributes;
        for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value2 = attribute.getValue();
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                    if (!this.removeFromValue((PsiAnnotationMemberValue)annotation, initializer, initializers.length == 1)) continue;
                    return;
                }
            }
            if (!this.removeFromValue((PsiAnnotationMemberValue)annotation, value2, attributes.length == 1)) continue;
            return;
        }
    }

    private boolean removeFromValue(PsiAnnotationMemberValue parent, PsiAnnotationMemberValue value2, boolean removeParent) throws IncorrectOperationException {
        String text2 = value2.getText();
        text2 = StringUtil.trimStart((String)text2, (String)"\"");
        if (this.myID.equals(text2 = StringUtil.trimEnd((String)text2, (String)"\""))) {
            if (removeParent) {
                parent.delete();
            } else {
                value2.delete();
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

