/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.BundleBase;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.IdeValidationHost;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitor
extends XmlElementVisitor
implements HighlightVisitor,
IdeValidationHost {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor");
    private static boolean ourDoJaxpTesting;
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES;
    private HighlightInfoHolder myHolder;

    private void addElementsForTag(XmlTag tag, @NotNull String localizedMessage, HighlightInfoType type2) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(0);
        }
        this.addElementsForTagWithManyQuickFixes(tag, localizedMessage, type2, new IntentionAction[]{null});
    }

    private void addElementsForTagWithManyQuickFixes(XmlTag tag, @NotNull String localizedMessage, HighlightInfoType type2, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(1);
        }
        this.bindMessageToTag(tag, type2, -1, localizedMessage, quickFixActions);
    }

    public void visitXmlToken(XmlToken token) {
        XmlTag tag;
        String marker;
        String s;
        int i;
        IElementType tokenType = token.getTokenType();
        if (tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) {
            PsiElement element = token.getPrevSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
            if (element instanceof XmlToken) {
                PsiElement parent;
                if (((XmlToken)element).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element.getParent()) instanceof XmlTag && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkTag((XmlTag)parent);
                }
            } else {
                PsiElement parent = token.getParent();
                if (parent instanceof XmlAttribute && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkAttribute((XmlAttribute)parent);
                }
            }
        } else if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && token.getParent() instanceof XmlText && token.textContains(']') && token.textContains('>') && (i = (s = token.getText()).indexOf(marker = "]]>")) != -1 && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)token, XmlTag.class)) != null && XmlExtension.getExtensionByElement((PsiElement)tag).shouldBeHighlightedAsTag(tag) && !XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            TextRange textRange = token.getTextRange();
            int start = textRange.getStartOffset() + i;
            HighlightInfoType type2 = tag instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            String description = XmlErrorMessages.message("cdata.end.should.not.appear.in.content.unless.to.mark.end.of.cdata.section", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(type2).range(start, start + marker.length()).descriptionAndTooltip(description).create();
            this.addToResults(info);
        }
    }

    private void checkTag(XmlTag tag) {
        if (ourDoJaxpTesting) {
            return;
        }
        if (!this.myHolder.hasErrorResults()) {
            this.checkTagByDescriptor(tag);
        }
        if (!this.myHolder.hasErrorResults() && !XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            XmlElementDescriptor descriptor2 = tag.getDescriptor();
            if (tag instanceof HtmlTag && (descriptor2 instanceof AnyXmlElementDescriptor || descriptor2 == null)) {
                return;
            }
            this.checkReferences((PsiElement)tag);
        }
    }

    private void bindMessageToTag(XmlTag tag, HighlightInfoType warning, int messageLength, @NotNull String localizedMessage, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(2);
        }
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, messageLength, localizedMessage, quickFixActions);
        childByRole = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, messageLength, localizedMessage, quickFixActions);
    }

    public void visitXmlProcessingInstruction(XmlProcessingInstruction processingInstruction) {
        super.visitXmlProcessingInstruction(processingInstruction);
        PsiElement parent = processingInstruction.getParent();
        if (parent instanceof XmlProlog && processingInstruction.getText().startsWith("<?xml")) {
            PsiElement e = PsiTreeUtil.prevLeaf((PsiElement)processingInstruction);
            while (e != null) {
                if (!(e instanceof PsiWhiteSpace && PsiTreeUtil.prevLeaf((PsiElement)e) != null || e instanceof OuterLanguageElement)) {
                    PsiElement eParent = e.getParent();
                    if (eParent instanceof PsiComment) {
                        e = eParent;
                    }
                    if (eParent instanceof XmlProcessingInstruction) break;
                    String description = XmlErrorMessages.message("xml.declaration.should.precede.all.document.content", new Object[0]);
                    this.addToResults(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(e).descriptionAndTooltip(description).create());
                }
                e = PsiTreeUtil.prevLeaf((PsiElement)e);
            }
        }
        this.checkReferences((PsiElement)processingInstruction);
    }

    private void bindMessageToAstNode(PsiElement childByRole, HighlightInfoType warning, int length, @NotNull String localizedMessage, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(3);
        }
        if (childByRole != null) {
            TextRange textRange = childByRole.getTextRange();
            if (length == -1) {
                length = textRange.getLength();
            }
            int startOffset = textRange.getStartOffset();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(warning).range(childByRole, startOffset, startOffset + length).descriptionAndTooltip(localizedMessage).create();
            if (highlightInfo == null) {
                highlightInfo = HighlightInfo.newHighlightInfo(warning).range(new TextRange(startOffset, startOffset + length)).textAttributes(NONEMPTY_TEXT_ATTRIBUTES).descriptionAndTooltip(localizedMessage).create();
            }
            for (IntentionAction quickFixAction : quickFixActions) {
                if (quickFixAction == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, textRange, quickFixAction);
            }
            this.addToResults(highlightInfo);
        }
    }

    private void checkTagByDescriptor(XmlTag tag) {
        XmlElementDescriptor elementDescriptor;
        String name2 = tag.getName();
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            elementDescriptor = XmlUtil.getDescriptorFromContext(tag);
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null && elementDescriptor == null && XmlHighlightVisitor.shouldBeValidated(tag)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                this.addElementsForTag(tag, XmlErrorMessages.message("element.is.not.allowed.here", name2), XmlHighlightVisitor.getTagProblemInfoType(tag));
                return;
            }
            if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
                elementDescriptor = tag.getDescriptor();
            }
            if (elementDescriptor == null) {
                return;
            }
        } else {
            elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null) {
                this.addElementsForTag(tag, XmlErrorMessages.message("element.must.be.declared", name2), HighlightInfoType.WRONG_REF);
                return;
            }
        }
        if (elementDescriptor instanceof Validator) {
            ((Validator)elementDescriptor).validate(tag, this);
        }
    }

    private static HighlightInfoType getTagProblemInfoType(XmlTag tag) {
        if (tag instanceof HtmlTag && "http://www.w3.org/1999/html".equals(tag.getNamespace())) {
            if (XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)tag)) {
                return HighlightInfoType.INFORMATION;
            }
            return HighlightInfoType.WARNING;
        }
        return HighlightInfoType.WRONG_REF;
    }

    public static boolean isInjectedWithoutValidation(PsiElement element) {
        return InjectedLanguageManager.FRANKENSTEIN_INJECTION.get((UserDataHolder)element.getContainingFile()) == Boolean.TRUE;
    }

    public static boolean skipValidation(PsiElement context) {
        return context instanceof XmlElement && ((XmlElement)context).skipValidation();
    }

    public static void setSkipValidation(@NotNull PsiElement element) {
        if (element == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(4);
        }
        element.putUserData(XmlElement.DO_NOT_VALIDATE, (Object)Boolean.TRUE);
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
    }

    private void checkAttribute(XmlAttribute attribute) {
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            return;
        }
        String name2 = attribute.getName();
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)attribute);
        if (!(prevLeaf instanceof PsiWhiteSpace)) {
            TextRange textRange = attribute.getTextRange();
            HighlightInfoType type2 = tag instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            String description = XmlErrorMessages.message("attribute.should.be.preceded.with.space", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(type2).range(textRange.getStartOffset(), textRange.getStartOffset()).descriptionAndTooltip(description).create();
            this.addToResults(info);
        }
        if (attribute.isNamespaceDeclaration() || "http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            return;
        }
        XmlElementDescriptor elementDescriptor = tag.getDescriptor();
        if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor || ourDoJaxpTesting) {
            return;
        }
        XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
        if (attributeDescriptor == null) {
            PsiFile file2;
            String localizedMessage;
            HighlightInfo highlightInfo;
            if (!XmlUtil.attributeFromTemplateFramework(name2, tag) && (highlightInfo = this.reportAttributeProblem(tag, name2, attribute, localizedMessage = XmlErrorMessages.message("attribute.is.not.allowed.here", name2))) != null && (file2 = tag.getContainingFile()) != null) {
                for (XmlUndefinedElementFixProvider fixProvider : (XmlUndefinedElementFixProvider[])Extensions.getExtensions(XmlUndefinedElementFixProvider.EP_NAME)) {
                    IntentionAction[] fixes = fixProvider.createFixes(attribute);
                    if (fixes == null) continue;
                    for (IntentionAction action : fixes) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, action);
                    }
                    break;
                }
            }
        } else {
            this.checkDuplicateAttribute(tag, attribute);
            PsiReference[] attrRefs = attribute.getReferences();
            this.doCheckRefs((PsiElement)attribute, attrRefs, !attribute.getNamespacePrefix().isEmpty() ? 2 : 1);
        }
    }

    @Nullable
    private HighlightInfo reportAttributeProblem(XmlTag tag, String localName, XmlAttribute attribute, @NotNull String localizedMessage) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(5);
        }
        RemoveAttributeIntentionFix removeAttributeIntention = new RemoveAttributeIntentionFix(localName, attribute);
        if (!(tag instanceof HtmlTag)) {
            HighlightInfoType tagProblemInfoType = HighlightInfoType.WRONG_REF;
            ASTNode node = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (node != null);
            ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
            assert (child != null);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(tagProblemInfoType).range(child).descriptionAndTooltip(localizedMessage).create();
            this.addToResults(highlightInfo);
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)removeAttributeIntention);
            return highlightInfo;
        }
        return null;
    }

    private void checkDuplicateAttribute(XmlTag tag, XmlAttribute attribute) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            return;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        PsiFile containingFile = tag.getContainingFile();
        XmlExtension extension = containingFile instanceof XmlFile ? XmlExtension.getExtension(containingFile) : DefaultXmlExtension.DEFAULT_EXTENSION;
        for (XmlAttribute tagAttribute : attributes) {
            ProgressManager.checkCanceled();
            if (attribute == tagAttribute || !Comparing.strEqual((String)attribute.getName(), (String)tagAttribute.getName())) continue;
            String localName = attribute.getLocalName();
            if (extension.canBeDuplicated(tagAttribute)) continue;
            ASTNode attributeNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (attributeNode != null);
            ASTNode attributeNameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attributeNode);
            assert (attributeNameNode != null);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(XmlHighlightVisitor.getTagProblemInfoType(tag)).range(attributeNameNode).descriptionAndTooltip(XmlErrorMessages.message("duplicate.attribute", localName)).create();
            this.addToResults(highlightInfo);
            RemoveAttributeIntentionFix intentionAction = new RemoveAttributeIntentionFix(localName, attribute);
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)intentionAction);
        }
    }

    public void visitXmlDocument(XmlDocument document) {
        PsiMetaData psiMetaData;
        if (document.getLanguage() == DTDLanguage.INSTANCE && (psiMetaData = document.getMetaData()) instanceof Validator) {
            ((Validator)psiMetaData).validate(document, this);
        }
    }

    public void visitXmlTag(XmlTag tag) {
    }

    public void visitXmlAttributeValue(XmlAttributeValue value2) {
        String error;
        XmlAttributeDescriptor attributeDescriptor;
        this.checkReferences((PsiElement)value2);
        PsiElement parent = value2.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return;
        }
        XmlAttribute attribute = (XmlAttribute)parent;
        XmlTag tag = attribute.getParent();
        XmlElementDescriptor elementDescriptor = tag.getDescriptor();
        XmlAttributeDescriptor xmlAttributeDescriptor = attributeDescriptor = elementDescriptor != null ? elementDescriptor.getAttributeDescriptor(attribute) : null;
        if (attributeDescriptor != null && !XmlHighlightVisitor.skipValidation((PsiElement)value2) && (error = attributeDescriptor.validateValue((XmlElement)value2, attribute.getValue())) != null) {
            HighlightInfoType type2 = XmlHighlightVisitor.getTagProblemInfoType(tag);
            this.addToResults(HighlightInfo.newHighlightInfo(type2).range((PsiElement)value2).descriptionAndTooltip(error).create());
        }
    }

    private void checkReferences(PsiElement value2) {
        if (value2 == null) {
            return;
        }
        this.doCheckRefs(value2, value2.getReferences(), 0);
    }

    private void doCheckRefs(PsiElement value2, PsiReference[] references, int start) {
        for (int i = start; i < references.length; ++i) {
            LocalQuickFix[] fixes;
            PsiElement parent;
            PsiReference reference = references[i];
            ProgressManager.checkCanceled();
            if (XmlHighlightVisitor.isUrlReference(reference) || !XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
            String description = XmlHighlightVisitor.getErrorDescription(reference);
            int startOffset = reference.getElement().getTextRange().getStartOffset();
            TextRange referenceRange = reference.getRangeInElement();
            if (referenceRange.getStartOffset() > referenceRange.getEndOffset()) {
                LOG.error("Reference range start offset > end offset:  " + reference + ", start offset: " + referenceRange.getStartOffset() + ", end offset: " + referenceRange.getEndOffset());
            }
            HighlightInfoType type2 = XmlHighlightVisitor.getTagProblemInfoType((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value2, XmlTag.class));
            if (value2 instanceof XmlAttributeValue && (parent = value2.getParent()) instanceof XmlAttribute) {
                String name2 = ((XmlAttribute)parent).getName().toLowerCase();
                if (type2.getSeverity(null).compareTo(HighlightInfoType.WARNING.getSeverity(null)) > 0 && name2.endsWith("stylename")) {
                    type2 = HighlightInfoType.WARNING;
                }
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(type2).range(startOffset + referenceRange.getStartOffset(), startOffset + referenceRange.getEndOffset()).descriptionAndTooltip(description).create();
            this.addToResults(info);
            if (reference instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
                InspectionManager manager = InspectionManager.getInstance((Project)reference.getElement().getProject());
                for (LocalQuickFix fix : fixes) {
                    ProblemDescriptor descriptor2 = manager.createProblemDescriptor(value2, description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true);
                    QuickFixAction.registerQuickFixAction(info, (IntentionAction)new LocalQuickFixAsIntentionAdapter(fix, descriptor2));
                }
            }
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(reference, new QuickFixActionRegistrarImpl(info));
        }
    }

    public static boolean isUrlReference(PsiReference reference) {
        return reference instanceof FileReferenceOwner || reference instanceof AnchorReference;
    }

    @NotNull
    public static String getErrorDescription(@NotNull PsiReference reference) {
        String description;
        if (reference == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(6);
        }
        String message2 = reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern() : PsiBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        try {
            description = BundleBase.format((String)message2, (Object[])new Object[]{reference.getCanonicalText()});
        }
        catch (IllegalArgumentException ex) {
            description = message2;
        }
        String string = description;
        if (string == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean hasBadResolve(PsiReference reference, boolean checkSoft) {
        if (!checkSoft && reference.isSoft()) {
            return false;
        }
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length == 0;
        }
        return reference.resolve() == null;
    }

    public void visitXmlDoctype(XmlDoctype xmlDoctype) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)xmlDoctype)) {
            return;
        }
        this.checkReferences((PsiElement)xmlDoctype);
    }

    private void addToResults(HighlightInfo info) {
        this.myHolder.add(info);
    }

    public static void setDoJaxpTesting(boolean doJaxpTesting) {
        ourDoJaxpTesting = doJaxpTesting;
    }

    @Override
    public void addMessage(PsiElement context, String message2, int type2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMessage(PsiElement context, String message2, @NotNull Validator.ValidationHost.ErrorType type2) {
        if (type2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(8);
        }
        this.addMessageWithFixes(context, message2, type2, new IntentionAction[0]);
    }

    @Override
    public void addMessageWithFixes(PsiElement context, String message2, @NotNull Validator.ValidationHost.ErrorType type2, IntentionAction ... fixes) {
        if (type2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(9);
        }
        if (fixes == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(10);
        }
        if (message2 != null && !message2.isEmpty()) {
            HighlightInfoType defaultInfoType;
            PsiFile containingFile = context.getContainingFile();
            HighlightInfoType highlightInfoType = type2 == Validator.ValidationHost.ErrorType.ERROR ? HighlightInfoType.ERROR : (defaultInfoType = type2 == Validator.ValidationHost.ErrorType.WARNING ? HighlightInfoType.WARNING : HighlightInfoType.WEAK_WARNING);
            if (context instanceof XmlTag && XmlExtension.getExtension(containingFile).shouldBeHighlightedAsTag((XmlTag)context)) {
                this.addElementsForTagWithManyQuickFixes((XmlTag)context, message2, defaultInfoType, fixes);
            } else {
                HighlightInfo highlightInfo;
                PsiLanguageInjectionHost contextOfFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
                if (contextOfFile != null) {
                    TextRange range = InjectedLanguageManager.getInstance((Project)context.getProject()).injectedToHost(context, context.getTextRange());
                    highlightInfo = HighlightInfo.newHighlightInfo(defaultInfoType).range(range).descriptionAndTooltip(message2).create();
                } else {
                    highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(context).descriptionAndTooltip(message2).create();
                }
                for (IntentionAction quickFixAction : fixes) {
                    if (quickFixAction == null) continue;
                    QuickFixAction.registerQuickFixAction(highlightInfo, quickFixAction);
                }
                this.addToResults(highlightInfo);
            }
        }
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(11);
        }
        if (file2 instanceof XmlFile) {
            return true;
        }
        for (PsiFile psiFile : file2.getViewProvider().getAllFiles()) {
            if (!(psiFile instanceof XmlFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(12);
        }
        element.accept((PsiElementVisitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(14);
        }
        if (action == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(15);
        }
        this.myHolder = holder;
        try {
            action.run();
        }
        finally {
            this.myHolder = null;
        }
        return true;
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        XmlHighlightVisitor xmlHighlightVisitor = new XmlHighlightVisitor();
        if (xmlHighlightVisitor == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(16);
        }
        return xmlHighlightVisitor;
    }

    @Override
    public int order() {
        return 1;
    }

    public static String getUnquotedValue(XmlAttributeValue value2, XmlTag tag) {
        String unquotedValue = value2.getValue();
        if (tag instanceof HtmlTag) {
            unquotedValue = unquotedValue.toLowerCase();
        }
        return unquotedValue;
    }

    public static boolean shouldBeValidated(@NotNull XmlTag tag) {
        PsiElement parent;
        if (tag == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(17);
        }
        if ((parent = tag.getParent()) instanceof XmlTag) {
            return !XmlHighlightVisitor.skipValidation(parent) && !XmlUtil.tagFromTemplateFramework(tag);
        }
        return true;
    }

    static {
        NONEMPTY_TEXT_ATTRIBUTES = new TextAttributes(){

            public boolean isEmpty() {
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElementsForTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addElementsForTagWithManyQuickFixes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindMessageToTag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindMessageToAstNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSkipValidation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportAttributeProblem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
            case 7: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMessageWithFixes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeValidated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

